<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Login');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to  true in `app/Config/Feature.php` and set the following to true.
$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.

// AUTH DEACTIVATE BY MISSING FILTERS
$routes->group('crontask', static function($routes){
    $routes->get(                   '/',                            'Crontask::index');
    $routes->get(                   'rodar',                        'Crontask::rodar');
    $routes->get(                   'evuptMotor',                   'Crontask::evuptMotor');
});

$routes->group('retorno', static function($routes){
    $routes->match(['get','post'],  'asaasBoleto',                  'Retorno::asaasBoleto');
    $routes->get(                   'pixel?(:segment)',             'Retorno::pixel/$1');
});

$routes->group('login', static function($routes){
    $routes->get(                   '/',                            'Login::index');
    $routes->post(                  'signin',                       'Login::signin');
    $routes->get(                   'signout',                      'Login::signout');
});

$routes->group('loginCliente', static function($routes){
    $routes->get(                   '/',                            'LoginCliente::index');
    $routes->post(                  'signin',                       'LoginCliente::signin');
    $routes->get(                   'signout',                      'LoginCliente::signout');
    $routes->match(['get','post'],  'recuperar',                    'LoginCliente::recuperar');
    $routes->match(['get','post'],  'recuperacao/(:num)/(:segment)','LoginCliente::recuperacao/$1/$2');
    $routes->get(                   'fatura/(:segment)',            'LoginCliente::fatura/$1');
});

// AUTH ACTIVATE BY FILTERS
$routes->get(                       '/',                            'Painel::index', ['filter' => 'auth']); // root
$routes->get(                       '/painel',                      'Painel::index', ['filter' => 'auth']);
$routes->post(                      '/painel/fetch',                'Painel::fetch', ['filter' => 'auth']);

$routes->group('organizacao', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                            'Organizacao::index');
    $routes->match(['get','post'],  'cadastra',                     'Organizacao::cadastra');
    $routes->match(['get','post'],  'edita/(:num)',                 'Organizacao::edita/$1');
    $routes->get(                   'exclui/(:num)',                'Organizacao::exclui/$1');
});

$routes->group('usuario', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                            'Usuario::index');
    $routes->match(['get','post'],  'cadastra',                     'Usuario::cadastra');
    $routes->match(['get','post'],  'edita/(:num)',                 'Usuario::edita/$1');
    $routes->get(                   'exclui/(:num)',                'Usuario::exclui/$1');
});

$routes->group('orcamento', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                            'Orcamento::index/$1');
    $routes->match(['get','post'],  'cadastra',                     'Orcamento::cadastra');
    $routes->match(['get','post'],  'edita/(:num)',                 'Orcamento::edita/$1');
    $routes->get(                   'exclui/(:num)',                'Orcamento::exclui/$1');
    $routes->get(                   'lembretewhats/(:num)',         'Orcamento::lembreteWhats/$1');
});

$routes->group('cliente', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                            'Cliente::index');
    $routes->match(['get','post'],  'cadastra',                     'Cliente::cadastra');
    $routes->match(['get','post'],  'edita/(:num)',                 'Cliente::edita/$1');
    $routes->get(                   'exclui/(:num)',                'Cliente::exclui/$1');
    $routes->get(                   'painel/(:num)',                'Cliente::painel/$1');
    $routes->get(                   'avatarexcluir/(:num)',         'Cliente::avatarexcluir/$1');
    $routes->get(                   'bemvindo/(:num)',              'Cliente::bemvindo/$1');
    $routes->get(                   'ativar/(:num)',                'Cliente::ativar/$1');
    $routes->post(                  'ativarZpro/(:num)',            'Cliente::ativarZpro/$1');
    $routes->get(                   'alteraStatus/(:num)',            'Cliente::alteraStatus/$1');
    $routes->get(                   'lembreteWhats/(:num)',         'Cliente::lembreteWhats/$1');
});

$routes->group('clienteDetalhe', ['filter' => 'auth'], static function($routes){
    $routes->match(['get','post'],  'cadastra/(:num)',               'ClienteDetalhe::cadastra/$1');
    $routes->match(['get','post'],  'edita/(:num)',                  'ClienteDetalhe::edita/$1');
    $routes->get(                   'exclui/(:num)',                 'ClienteDetalhe::exclui/$1');
});

$routes->group('clientePedido', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                             'ClientePedido::index');
    $routes->match(['get','post'],  'cadastra/(:segment)',           'ClientePedido::cadastra/$1');
    $routes->get(                   'edita/(:num)',                  'ClientePedido::edita/$1');
    $routes->post(                  'edita/(:num)',                  'ClientePedido::editar/$1');
    $routes->get(                   'exclui/(:num)',                 'ClientePedido::exclui/$1');
});

$routes->group('produto', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                             'Produto::index');
    $routes->match(['get','post'],  'cadastra',                      'Produto::cadastra');
    $routes->get(                   'edita/(:num)',                  'Produto::edita/$1');
    $routes->post(                  'edita/(:num)',                  'Produto::editar/$1');
    $routes->get(                   'exclui/(:num)',                 'Produto::exclui/$1');
});

$routes->group('fatura', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                             'Fatura::index');
    $routes->get(                   'cadastra/(:segment)',           'Fatura::cadastra/$1');
    $routes->post(                  'cadastra/(:segment)',           'Fatura::cadastrar/$1');
    $routes->get(                   'edita/(:num)',                  'Fatura::edita/$1');
    $routes->post(                  'edita/(:num)',                  'Fatura::editar/$1');
    $routes->get(                   'exclui/(:num)',                 'Fatura::exclui/$1');
    $routes->post(                  'lembrete',                      'Fatura::lembrete');
    $routes->get(                   'boletar/(:num)',                'Fatura::boletar/$1');
    $routes->get(                   'pagamentoConfirma/(:num)',      'Fatura::pagamentoConfirma/$1');
    $routes->get(                   'aprovarpagamento/(:num)',       'Fatura::aprovarpagamento/$1');
});

$routes->group('faturaFormapgto', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                             'FaturaFormapgto::index');
    $routes->get(                   'cadastra/',                     'FaturaFormapgto::cadastra/$1');
    $routes->post(                  'cadastra/',                     'FaturaFormapgto::cadastrar/$1');
    $routes->get(                   'edita/(:num)',                  'FaturaFormapgto::edita/$1');
    $routes->post(                  'edita/(:num)',                  'FaturaFormapgto::editar/$1');
    $routes->get(                   'exclui/(:num)',                 'FaturaFormapgto::exclui/$1');
});

$routes->group('contabil', ['filter' => 'auth'], static function($routes){
    $routes->get(                   'nfse/(:num)/(:num)',            'Contabil::nfse/$1/$2');
    $routes->get(                   'consultar/(:num)/(:num)',       'Contabil::consultar/$1/$2');
    $routes->get(                   'cancelar/(:num)/(:segment)',    'Contabil::cancelar/$1/$2');
    $routes->get(                   'enviaremail/(:num)',            'Contabil::enviaremail/$1');
});
$routes->post(                      '/contabil/gatilho_retorno',     'Contabil::gatilho_retorno'); // sem auth
// $routes->get(                       '/contabil/gatilho',             'Contabil::gatilho');

$routes->group('faturamento', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                             'Faturamento::index');
    $routes->post(                  'cadastra/',                     'Faturamento::cadastra/$1');
    $routes->get(                   'edita/(:num)',                  'Faturamento::edita/$1');
    $routes->post(                  'edita/(:num)',                  'Faturamento::editar/$1');
    $routes->get(                   'exclui/(:num)',                 'Faturamento::exclui/$1');
});

$routes->group('faturamentoCategoria', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                             'FaturamentoCategoria::index');
    $routes->get(                   'cadastra/',                     'FaturamentoCategoria::cadastra/$1');
    $routes->post(                  'cadastra/',                     'FaturamentoCategoria::cadastrar/$1');
    $routes->get(                   'edita/(:num)',                  'FaturamentoCategoria::edita/$1');
    $routes->post(                  'edita/(:num)',                  'FaturamentoCategoria::editar/$1');
    $routes->get(                   'exclui/(:num)',                 'FaturamentoCategoria::exclui/$1');
});

$routes->group('midia', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                            'Midia::index');
    $routes->post(                  'upload/',                      'Midia::upload');
    $routes->get(                   'remove/(:num)',                'Midia::remove/$1');
});

$routes->group('evupt', ['filter' => 'auth'], static function($routes){
    $routes->get(                   '/',                            'Evupt::index');
    $routes->get(                   'cadastra',                     'Evupt::cadastra');
    $routes->post(                  'cadastra',                     'Evupt::cadastrar');
    $routes->match(['get','post'],  'edita/(:num)',                 'Evupt::edita/$1');
    $routes->get(                   'exclui/(:num)',                'Evupt::exclui/$1');
    $routes->get(                   'testarDisparo/(:num)/(:num)',  'Evupt::testarDisparo/$1/$2');
    $routes->get(                   'testarStatus/(:num)',          'Evupt::testarStatus/$1');
    $routes->get(                   'botRemoveSessao/(:num)',       'Evupt::botRemoveSessao/$1');
    $routes->get(                   'botCriaSessao/(:num)',         'Evupt::botCriaSessao/$1');
    $routes->get(                   'contatoCadastra/(:num)',       'Evupt::contatoCadastra/$1');
    $routes->post(                  'contatoCadastra/(:num)',       'Evupt::contatoCadastrar/$1');
    $routes->match(['get','post'],  'contatoEdita/(:num)',          'Evupt::contatoEdita/$1');
    $routes->get(                   'contatoExclui/(:num)',         'Evupt::contatoExclui/$1');
    $routes->get(                   'templateCadastra/(:num)',      'Evupt::templateCadastra/$1');
    $routes->post(                  'templateCadastra/(:num)',      'Evupt::templateCadastrar/$1');
    $routes->match(['get','post'],  'templateEdita/(:num)',         'Evupt::templateEdita/$1');
    $routes->get(                   'templateExclui/(:num)',        'Evupt::templateExclui/$1');
    $routes->get(                   'testarDisparoTemplate/(:segment)/(:num)/(:num)', 'Evupt::testarDisparoTemplate/$1/$2/$3');
});
$routes->get(                   'evupt/inscricao/(:segment)',       'Evupt::inscricao/$1'); // sem autenticação
$routes->get(                   'evupt/inscricaoCancela/(:segment)','Evupt::inscricaoCancela/$1'); // sem autenticação


//
// AUTH ACTIVATE BY FILTERS
$routes->group('painelCliente', ['filter' => 'authCliente'], static function($routes){
    $routes->get(                   '/',                            'PainelCliente::index'); // com authCliente
});



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
