<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClienteDetalheModel;

class ClienteDetalhe extends BaseController
{



    /**
     * CADASTRA} Cadastra um novo cliente
     * 
     * @param int $id_cliente
     * @return array
     */
    public function cadastra(int $id_cliente) {

        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_atributo' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira um atributo.',
                    ],
                ],
                'input_descricao' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira o conteúdo.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // Retorna
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();
                $formulario['input_publico'] = (!isset($formulario['input_publico']))? 0 : 1;
                $dados = [
                    'id_cliente'        => $formulario['id_cliente'],
                    'clidet_atributo'    => $formulario['input_atributo'],
                    'clidet_descricao'     => $formulario['input_descricao'],
                    'clidet_publico'     => $formulario['input_publico'],
                ];

                // Chama base de dados
                $clienteDetalheModel = new ClienteDetalheModel();

                // insere na base : apresentou erro
                if(!$clienteDetalheModel->save($dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Erro No Cadastrado do Detalhe.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Detalhe Cadastrado com Sucesso ao Cliente.');
                    return redirect()->to('/cliente/painel/'.$id_cliente);
                endif;
            }
            
        }

        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Detalhes do Cliente | Cadastre um novo detalhe',
            'id_cliente'    =>  $id_cliente,
        ];

        // constroi pagina
        return view('admin/cliente/clienteDetalhe-cadastra', $dados);
    }



    /**
     * EDITA} Mostra as informações de um cliente e edita
     * 
     * @param int $id_clientedetalhe
     * @return string
     */
    public function edita(int $id_clientedetalhe) {

        // seleciona informações do atributo
        $clienteDetalheModel = new ClienteDetalheModel();
        $dadosClienteDetalhe = $clienteDetalheModel->where('id_clientedetalhe',$id_clientedetalhe)->first();
        
        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_atributo' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira um atributo.',
                    ],
                ],
                'input_descricao' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira o conteúdo.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // Retorna
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();
                $formulario['input_publico'] = (!isset($formulario['input_publico']))? 0 : 1;
                $dados = [
                    'clidet_atributo'    => $formulario['input_atributo'],
                    'clidet_descricao'     => $formulario['input_descricao'],
                    'clidet_publico'     => $formulario['input_publico'],
                ];

                // Chama base de dados
                $clienteDetalheModel = new ClienteDetalheModel();

                // insere na base : apresentou erro
                if(!$clienteDetalheModel->update($id_clientedetalhe, $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Erro em Editar o Detalhe do Cliente.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Detalhe do Cliente Editado com Sucesso.');
                    return redirect()->to('/cliente/painel/'.$dadosClienteDetalhe['id_cliente']);
                endif;
            }
            
        }

        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Detalhes do Cliente | Editar detalhe',
            'clienteDetalhe'    =>  $dadosClienteDetalhe,
        ];

        // constroi pagina
        return view('admin/cliente/clienteDetalhe-edita', $dados);

    }



    /**
     * EXCLUI} Remove as informações de um cliente da base de dados
     * 
     * @param int $id_clientedetalhe
     * @return string
     */
    public function exclui(int $id_clientedetalhe) {

        // Exclui usuário        
        $clienteDetalheModel = new ClienteDetalheModel();
        $retorno = $clienteDetalheModel->where('id_clientedetalhe',$id_clientedetalhe)->first();
        $confirma = $clienteDetalheModel->delete($id_clientedetalhe);

        // excluir cliente retornou erro
        if(!$confirma):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao Excluir Detalhe do Cliente.');
            return redirect()->to('/cliente/painel/'.$retorno['id_cliente']);

        // excluiu cliente com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Detalhe do Cliente Excluído com sucesso.');
            return redirect()->to('/cliente/painel/'.$retorno['id_cliente']);

        endif;
    }




}
