<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClientePedidoModel;
use App\Models\ClienteModel;
use App\Models\ProdutoModel;
use DateTime;
use DateTimeZone;

class Clientepedido extends BaseController
{



    /**
     * INDEX } Listagem com todos os pedido
     * 
     * @param false
     * @return string
     */
    public function index() : string {

        // clean received information
        $cliped_status = strip_tags(trim($this->request->getGet('status')));

        // select database join values
        $clientePedidoModel = new ClientePedidoModel();
        $clientePedidoModel->select('cliente.cli_nome,cliente.cli_email,produto.pro_nome,cliente_pedido.*');
        $clientePedidoModel->join('cliente','cliente.id_cliente = cliente_pedido.id_cliente');
        $clientePedidoModel->join('produto','produto.id_produto = cliente_pedido.id_produto');

        // interpret response from database
        if(isset($cliped_status)&&($cliped_status!="")):
            $dadosClientePedido = $clientePedidoModel->onlyDeleted()->findAll();
        else:
            $dadosClientePedido = $clientePedidoModel->findAll();
        endif;

        // organiza array unindo todos os produtos do mesmo cliente
        if($dadosClientePedido):
            foreach($dadosClientePedido as $row):

                // if an entry for this user id hasn't been created in the result, add this object
                if (!isset($result[$row['id_cliente']])) {

                    $result[$row['id_cliente']][0] = $row;

                // otherwise, implement the key number to the existing entry
                } else {

                        // o numero de array sempre é um numero a mais nao precisa de +1 por que inicia no zero
                    $op = count($result[$row['id_cliente']]);
                    
                    // adiciona dados à array
                    $result[$row['id_cliente']][$op] = $row;
                }
            endforeach;
        else:
            $result = null;
        endif;

        // define informacoes e constrói a pagina
        $dados = [
            'TituloPagina'      => 'Listagem',
            'listagem'          => $result,
            
        ];
        return view('admin/cliente/clientePedido-index', $dados);
    }



    /**
     * CADASTRA } Cadastra um novo pedido para o cliente
     * 
     * @param int $id_cliente
     * @return array
     */
    public function cadastra($id_cliente) {

        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_produto' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Selecione o Produto.',
                    ],
                ],
                'input_dominio' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe o Domínio relacionado.',
                    ],
                ],
                'input_login' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe o login.',
                    ],
                ],
                'input_senha' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe a senha.',
                    ],
                ],
                'input_valor' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe o valor negociado.',
                    ],
                ],
                'input_datainicio' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe data inicio.',
                    ],
                ],
                'input_pagamentoproximo' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe o próximo pagamento.',
                    ],
                ],
                'input_pagamentoperiodo' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe o período de cobrança.',
                    ],
                ],
                'input_status' => [
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Informe o status.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // Retorna com as informações preservadas
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();

                // se veio id
                if($formulario['id_cliente'] != 'new'):
                    $dados = [
                        'id_cliente'                => $formulario['id_cliente'],
                        'id_produto'                => $formulario['input_produto'],
                        'cliped_dominio'            => $formulario['input_dominio'],
                        'cliped_login'              => $formulario['input_login' ],
                        'cliped_senha'              => $formulario['input_senha' ],
                        'cliped_valor'              => $formulario['input_valor' ],
                        'cliped_datainicio'         => $formulario['input_datainicio' ],
                        'cliped_pagamentoproximo'   => $formulario['input_pagamentoproximo' ],
                        'cliped_pagamentoperiodo'   => $formulario['input_pagamentoperiodo' ],
                        'cliped_status'             => $formulario['input_status'],
                    ];
                // se veio 'new'
                else:
                    $dados = [
                        'id_cliente'                => $formulario['input_cliente'],
                        'id_produto'                => $formulario['input_produto'],
                        'cliped_dominio'            => $formulario['input_dominio'],
                        'cliped_login'              => $formulario['input_login' ],
                        'cliped_senha'              => $formulario['input_senha' ],
                        'cliped_valor'              => $formulario['input_valor' ],
                        'cliped_datainicio'         => $formulario['input_datainicio' ],
                        'cliped_pagamentoproximo'   => $formulario['input_pagamentoproximo' ],
                        'cliped_pagamentoperiodo'   => $formulario['input_pagamentoperiodo' ],
                        'cliped_status'             => $formulario['input_status'],
                    ];
                endif;

                // Chama base de dados
                $ClientePedidoModel = new ClientePedidoModel();

                // insere na base : apresentou erro
                if(!$ClientePedidoModel->save($dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Erro No Cadastrado do Pedido.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Pedido Cadastrado com Sucesso.');
                    return redirect()->to('/cliente/painel/'.$dados['id_cliente']);
                endif;
            }
            
        }

        // continua se não veio por post

        // seleciona dados do cliente
        $clienteModel = new ClienteModel();
        $clienteModel->select('id_cliente,cli_nome');
        if(is_numeric($id_cliente)):
            $clienteModel->where('id_cliente',$id_cliente);
            $dadosCliente = $clienteModel->first();
        else:
            $dadosCliente = $clienteModel->findAll();
        endif;
        

        // seleciona dados de produtos
        $produtoModel = new ProdutoModel();
        $dadosProduto = $produtoModel->findAll();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Pedidos do Pedido | Cadastre um novo pedido',
            'cliente'    =>  $dadosCliente,
            'produto'    =>  $dadosProduto,
        ];

        // constroi pagina
        return view('admin/cliente/clientePedido-cadastra', $dados);
    }



    /**
     * EDITA} Mostra as informações do pedido para edição
     * 
     * @param int $id_clientepedido
     * @return string
     */
    public function edita(int $id_clientepedido) : string {

        // seleciona informações do pedido
        $ClientePedidoModel = new ClientePedidoModel();
        $dadosClientePedido = $ClientePedidoModel->where('id_clientepedido',$id_clientepedido)->withDeleted()->first();

        // seleciona informações do cliente
        $clienteModel = new ClienteModel();
        $clienteModel->select('id_cliente, cli_nome');
        $dadosCliente = $clienteModel->where('id_cliente',$dadosClientePedido['id_cliente'])->first();

        // seleciona produtos
        $produtoModel = new ProdutoModel();
        $produtoModel->select('id_produto, pro_nome');
        $dadosProduto = $produtoModel->withDeleted()->findAll();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  => 'Pedidos do Cliente | Editar pedido',
            'clientePedido' => $dadosClientePedido,
            'cliente'       => $dadosCliente,
            'produto'       => $dadosProduto,
        ];

        // constroi pagina
        return view('admin/cliente/clientePedido-edita', $dados);
    }



    /**
     * EDITAR} DESENVOLVE A AÇÃO EDITAR O PEDIDO
     * 
     * @param int $id_clientepedido
     * @return object
     */
    public function editar(int $id_clientepedido) : object {
        
        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {

            // redireciona se veio por outro método
            return redirect()->to('/cliente');
        }

        // cria regras de formulario
        $rules = [
            'input_produto' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Selecione o Produto.',
                ],
            ],
            'input_dominio' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe o Domínio relacionado.',
                ],
            ],
            'input_login' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe o login.',
                ],
            ],
            'input_senha' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe a senha.',
                ],
            ],
            'input_valor' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe o valor negociado.',
                ],
            ],
            'input_datainicio' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe data inicio.',
                ],
            ],
            'input_pagamentoproximo' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe o próximo pagamento.',
                ],
            ],
            'input_pagamentoperiodo' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe o período de cobrança.',
                ],
            ],
            'input_status' => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe o status.',
                ],
            ],
        ];

        

        // se Validar : apresentou erro
        if(!$this->validate($rules)){
            
            // Retorna
            session()->setFlashdata('msgType','warning');
            session()->setFlashdata('msg','Campos inválidos');
            return redirect()->back()->withInput();

        // senão Validar : executou com sucesso
        }else{

            // agrupa os dados
            $formulario = $this->request->getPost();

            $formulario['input_deleted'] = ($formulario['input_deleted']=='')? NULL : $formulario['input_deleted'] ;

            $dados = [
                'id_cliente'                => $formulario['id_cliente'],
                'id_produto'                => $formulario['input_produto'],
                'cliped_dominio'            => $formulario['input_dominio'],
                'cliped_login'              => $formulario['input_login' ],
                'cliped_senha'              => $formulario['input_senha' ],
                'cliped_valor'              => $formulario['input_valor' ],
                'cliped_datainicio'         => $formulario['input_datainicio' ],
                'cliped_pagamentoproximo'   => $formulario['input_pagamentoproximo' ],
                'cliped_pagamentoperiodo'   => $formulario['input_pagamentoperiodo' ],
                'cliped_status'             => $formulario['input_status'],
                'deleted_at'                => $this->sanitize_data($formulario['input_deleted']),
            ];

            // Chama base de dados
            $ClientePedidoModel = new ClientePedidoModel();
            $sucesso = $ClientePedidoModel->update($id_clientepedido, $dados);

            // se atualiza na base : apresentou erro
            if(!$sucesso):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro em Editar o Pedido do Pedido.');
                return redirect()->back()->withInput();

            //  senao atualiza na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Pedido do Pedido Editado com Sucesso.');
                return redirect()->to('/cliente/painel/'.$formulario['id_cliente']);
            endif;
        }
    }



    /**
     * EXCLUI} Remove as informações de um pedido da base de dados
     * 
     * @param int $id_clientepedido
     * @return string
     */
    public function exclui(int $id_clientepedido) {

        // exclui com soft delete
        $clientePedidoModel = new ClientePedidoModel();
        $datahoje = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
        $datahoje = $datahoje->format('Y-m-d H:i:s');
        $clientePedidoModel->resetQuery();
        $clientePedidoModel->where('id_clientepedido',$id_clientepedido);
        $clientePedidoModel->set('cliped_status','0');
        $clientePedidoModel->set('deleted_at',$datahoje);
        $confirma = $clientePedidoModel->update();

        // excluir pedido retornou erro
        if(!$confirma):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao Excluir Pedido do Pedido.');
            return redirect()->back();

        // excluiu pedido com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Pedido do Pedido Excluído com sucesso.');
            return redirect()->back();

        endif;
    }



    /**
     * SANITIZE} Verifica data se veio em branco
     * 
     * @param string $data
     * @return string
     */
    public function sanitize_data($data) {

        // se :parâmetros inválidos
        if( $data=="0000-00-00 00:00:00" || $data=="____-__-__ __:__:__" ):
            
            // erro validacao
            return NULL;

        // senão : parametros válidos
        else:

            // acerto validacao
            return $data;

        endif;

    }




}
