<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClienteModel;
use App\Models\ContabilModel;
use App\Models\OrganizacaoModel;
use App\Models\FaturaModel;
use DateTime;
use DateTimeZone;

class Contabil extends BaseController {



    // NOTA FISCAL DE SERVIÇO
    // NOTA FISCAL DE SERVIÇO
    // NOTA FISCAL DE SERVIÇO



    // // // // // // // // //
    //constroi em qual AMBIENTE o sistema estará funcionando 
    //
    //
    private function ambiente(){
        //para ambiente de testes
        $homologacao = array(
            'server'    =>  'https://homologacao.focusnfe.com.br',
            //'login'     =>  '3aPIFqdGzOt78lj8EPkAQGAISFaEw2oH', // homologação está utilizando de outra organizacao. Camboriu não possui homologação;
            'login'     =>  'KbPi1Y4T6q95P6n8B6JjL1LJ6cYAIvln',
        );
        //para uso real
        $producao = array(
            'server'    =>  'https://api.focusnfe.com.br/',
            'login'     =>  '9pAFd1GJzVgeSrjQ72nbnaJS7blQ7Kbo',
        );

        //define aqui o Ambiente
        //alterar para $homologacao se ambiente de testes ou $producao
        //$ambiente = $homologacao; // quando para testes
        $ambiente = $producao;

        return $ambiente;
    }



    // // // // // // // // //
    //constroi o FILTRO UID
    //
    private function filtro($uid=NULL){

        //remove espacos em branco
        $uid = trim($uid);
        
        // cria filtros de erros
        $filtro = 0;
        // se existe uid
        $filtro = (isset($uid)) ? $filtro : $filtro+1;
        // se uid for diferente de vazio
        $filtro = ($uid!='') ? $filtro : $filtro+1;
        // se uid for numero e nao string
        $filtro = (is_numeric($uid)) ? $filtro : $filtro+1;
        
        //retorna resultado
        if($filtro == 0):
            return '0';
        else:
            return '1';
        endif;
    }



 	//-----------------------------------------------------------------[SETOR Contábil > Index]
	//constroi a secao Index/ [ desativada ]
	//
	private function index(){
        //data atual
        $agora = new DateTime('NOW', new DateTimeZone('Brazil/East'));
        echo $agora->format('Y-m-d h:i:s');

        //informa qual ambiente está rodando
        echo '<h3>Ambientes para verificacao</h3>';
        $ambiente = $this->ambiente();
        echo 'Server: ' . $ambiente['server'];
        echo '<hr>';

        //relatorio de notas
        echo '<h3>Relatório de NFe emitidas</h3>';
        $contabilModel = new ContabilModel();
        $listagem = $contabilModel->findAll();
        foreach($listagem as $l):
            echo $l['id_contabil_s'];
            echo $l['id_fatura'];
            echo $l['con_data_emissao'];
            echo $l['con_cnpj_prestador'];
            echo $l['con_ref'];
            echo $l['con_status'];
            echo $l['con_status_sefaz'];
            echo $l['con_mensagem_sefaz'];
            echo $l['con_chave_nfe'];
            echo $l['con_numero'];
            echo $l['con_serie'];
            echo $l['con_caminho_xml_nota_fiscal'];
            echo $l['con_caminho_danfe'];
            echo '<hr>';
        endforeach;
    }



    //-----------------------------------------------------------------[SETOR Contábil > nfe]
    //constroi a secao NFS-e
    //
    // $pid = recebe id_fatura para gerar uma nova nota fiscal
    // $eid = recebe id_organizacao para identificar qual organizacao é a geradora
    //
    // verifica se existe tentativas anteriores de autorização da nota
    // encaminha para function consultar se existir a referência à nota
    //
    // retorna string
    //
    public function nfse($pid, $eid){

        helper('funcoes');

        // -------------------- ================ [ iniciando ]
        //verifica se $pid vazio e se é numero
        if(($pid == "")||(!is_numeric($pid))):
            session()->setFlashdata('msgType','error');
            session()->setFlashdata('msg','sem permissão para abrir uma nota desta fatura.');
            return redirect()->to('painel');
        endif;
        //verifica se $eid vazio e se é numero
        if(($eid == "")||(!is_numeric($eid))):
            session()->setFlashdata('msgType','error');
            session()->setFlashdata('msg','sem permissão para abrir uma nota nesta organizacao');
            return redirect()->to('painel');
        endif;

        // -------------------- ================ [ * verificando ]
        //carrega as bases de dados
        $organizacaoModel = new OrganizacaoModel();
        $contabilModel = new ContabilModel();

        // Dados Organizacao
        $organizacaoModel->select('org_cnpj, org_insc_municipal');
        $organizacaoModel->where('id_organizacao',$eid);
        $organizacao = $organizacaoModel->first();

        // * verificando se já existe NFSe da fatura da organizacao em questão
        $contabilModel->where('id_fatura',$pid);
        $contabilModel->where('con_cnpj_prestador',$organizacao['org_cnpj']);
        $contabil_s = $contabilModel->first();

        // se já existir NFSe da fatura
        // e status qualquer coisa além de erro_autorizacao
        // quando erro_autorizacao, tentar emitir novamente aquela nota e referencia
        if(($contabil_s == TRUE) && ($contabil_s['con_status']!='erro_autorizacao')):
            //redireciona para a página de consulta
            session()->setFlashdata('msgType','info');
            session()->setFlashdata('msg','NFe já foi gerada para esta fatura.');
            return redirect()->to('contabil/consultar/'.$contabil_s['con_ref'].'/'.$eid);
        endif;

        // se ja existir NFSe da fatura
        // e status for erro_autorizaco
        if(($contabil_s == TRUE) && ($contabil_s['con_status']=='erro_autorizacao')):
            // quando erro de autorizacao pode emitir uma nova nota
            // usando a referencia obtida na primeira consulta que resultou em erro
            // encapsula a referencia da fatura
            $con_ref = $contabil_s['con_ref'];
        
        // se ainda não tem NFSe da fatura
        else:
            //encapsula NULL como referencia da fatura.
            //Para criar uma nova nota fiscal
            $con_ref = NULL;
        endif;
        
        // -------------------- ================ [ relacionando ]
        //carrega as bases de dados
        $faturaModel = new FaturaModel();
        $clienteModel = new ClienteModel();

        // Dados da fatura
        $faturaModel->where('id_fatura',$pid);
        $fatura = $faturaModel->first();
        
        // Dados Cliente
        $clienteModel->where('id_cliente',$fatura['id_cliente']);
        $cliente = $clienteModel->first();
        
        // -------------------- ================ [ normatizando ]
        //ajusta data da fatura
        $fatura_data = new DateTime($fatura['fat_data']);
        $hoje_data   = new DateTime('NOW', new DateTimeZone('America/Sao_Paulo'));

        //ajusta cpf ou cnpj do cliente pelo tamanho
        $cliente['cli_cpf'] = str_replace('.','',$cliente['cli_cpfcnpj']);
        $cliente['cli_cpf'] = str_replace(',','.',$cliente['cli_cpf']);
        $cliente['cli_cnpj'] = NULL;
        $quantidade = strlen($cliente['cli_cpf']);
        // se maior então é cnpj
        if($quantidade > 12):
            $cliente['cli_cnpj'] = $cliente['cli_cpf'];
            $cliente['cli_cpf'] = NULL;
        endif;

        // Complemento endereço vazio define NULL
        $cliente['cli_endereco_compl'] = $cliente['cli_endereco_compl'] != "" ? $cliente['cli_endereco_compl'] : NULL ;

        // ajusta pontuação valor
        $fatura['fat_valor'] = str_replace('.','',$fatura['fat_valor']);
        $fatura['fat_valor'] = str_replace(',','.',$fatura['fat_valor']);

        // Compoe a NFe Completa
        $nfse = array (
            "id_fatura"                 => $fatura['id_fatura'],
            //REFERENCIA
            "con_ref"                   => $con_ref,
            "data_emissao"              => $fatura['fat_data'],
            "incentivador_cultural"     => "false",
            "natureza_operacao"         => "1",
            "optante_simples_nacional"  => "true",
            "prestador"     => array (
            //ORGANIZACAO
                "cnpj"                  => cnpf_limpa_pontuacao($organizacao['org_cnpj']),
                "inscricao_municipal"   => $organizacao['org_insc_municipal'],
                "codigo_municipio"      => "4203204", //CAMBORIU
            ),
            "tomador"       => array (  
            //CLIENTE
                "cpf"                   => $cliente['cli_cpf'],
                "cnpj"                  => $cliente['cli_cnpj'],
                "razao_social"          => $cliente['cli_nome'],
                "email"                 => $cliente['cli_email'],
                "endereco"   => array (
                    //"codigo_municipio"  => "4203204", //CAMBORIU
                    "logradouro"        => $cliente['cli_endereco'],
                    "numero"            => $cliente['cli_endereco_numero'],
                    "complemento"       => $cliente['cli_endereco_compl'],
                    "bairro"            => $cliente['cli_bairro'],
                    "uf"                => $cliente['cli_estado_uf'],
                    "cep"               => $cliente['cli_cep'],
                ),
            ),
            //FATURA
            "servico"       => array(   
                "discriminacao"          => $fatura['fat_descricao'],
                "iss_retido"             => "false",
                "item_lista_servico"     => "201", //Serviço pesquisas desenvolvimento qualquer natureza.
                "valor_servicos"         => $fatura['fat_valor'],
            )

        );

        // -------------------- ================ [ filtrando ]
        //filtra inconformidades
        $retorno = 0;
        $retorno = ($nfse['tomador']['razao_social'] != '') ? $retorno+0 : $retorno+1 ;
        $retorno = ( ($nfse['tomador']['cpf'] != '') || ($nfse['tomador']['cnpj'] != '') ) ? $retorno+0 : $retorno+1 ;

        //cria array de informacoes para template;
        $listagem = array(
            'conteudo'  =>  '',
        );

        // se filtro continuou zero
        if($retorno == '0'):

            // -------------------- ================ [ Enviando ]
            // envia NFe para autorizacao
            $autoriza = $this->autorizar($nfse);

            // se retorna erros
            if(isset($autoriza["erros"])):
                //filtra se gerou erros
                $listagem['conteudo'] .= '<b>http_code: ' . $autoriza['http_code'] . ' | ' . $autoriza['codigo'] . '</b><br> ' . $autoriza['mensagem'] . ':<br>';
                foreach($autoriza['erros'] as $erro):
                    $listagem['conteudo'] .= '> ' . $erro['mensagem'] . '<br>';
                endforeach;
            endif;

            //se acessou mas deu erro no retorno
            if(isset($autoriza["codigo"])=="erro_validacao_schema"):
                //filtra se gerou erros
                $listagem['conteudo'] .= '<b>http_code: ' . $autoriza['http_code'] . ' | ' . $autoriza['codigo'] . '</b><br> ' . $autoriza['mensagem'] . '<br>Status: ' . $autoriza['status'];

            // se autorizada com sucesso
            else:

                //retorna informações da criacão da NFe
                if(isset($autoriza['referencia'])):
                    return redirect()->to('contabil/consultar/'.$autoriza['referencia'].'/'.$eid);
                else:
                    var_dump($autoriza);
                endif;

            endif;

        // se não, filtro retornou erro
        else:
            $listagem['conteudo'] .= "Informe Nome, CPF ou CNPJ.<br> Total erros: " . $retorno;
        endif;

        //informa qual ambiente está rodando
        $listagem['TituloPagina']   = 'NFS-e';
        $listagem['ambiente']   = $this->ambiente();
        $listagem['id_fatura']  = $fatura['id_fatura'];
        $listagem['con_ref']    = $con_ref;
        $listagem['referencia'] = $autoriza['referencia'];


        // constroi pagina
        return view('admin/contabil/perfil', $listagem);
    }



    //-----------------------------------------------------------------[SETOR Contábil > Autorizar]
    //constroi a function Autorizar produção de nota fiscal
    //
    // $nfse = recebe array() com todas as informações para gerar a nota fiscal
    //
    // retorna array da focusNfe
    //
    private function autorizar($nfse){

        //verifica se existe referencia da nota já criada
        if(isset($nfse['con_ref'])):
            //define a mesma referencia
            $ref = $nfse['con_ref'];

        //se não existir referencia já definida
        else:
            //seleciona ultima nfse cadastrada da organizacao em questão
            $contabilModel = new ContabilModel();
            $contabilModel->where('con_cnpj_prestador =', $nfse['prestador']['cnpj']);
            $contabilModel->orderBy('id_contabil_s', 'DESC');
            $listagem = $contabilModel->first();

            //se não tiver nenhum registro, define referencia zero
            if(empty($listagem['con_ref'])): $listagem['con_ref'] = 0; endif;

            //acrescenta um numero à referencia para solicitar a nova NFe
            $ref = $listagem['con_ref']+1;
        endif;

        //chama dados do ambiente
        $ambiente = $this->ambiente();
        $login = $ambiente['login'];
        $password = "";
        $server = $ambiente['server'];

        // Envio das informações usando o cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $server."/v2/nfse?ref=" . $ref);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($nfse));
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
        $body = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // retorno da validacao
        $resultado = json_decode($body,true);
        //var_dump($resultado);

        //pega o primeiro numero do codigo de retorno
        $rest = substr($http_code, 0,1);

        //se for do grupo 2 é por que passou
        if($rest == '2'):

            //verifica se existe referencia da nota já criada na base
            if(isset($nfse['con_ref'])):
                //seleciona o id da organizacao
                $organizacaoModel = new OrganizacaoModel();
                $organizacaoModel->where('org_cnpj',$nfse['prestador']['cnpj']);
                $id_organizacao = $organizacaoModel->first();
                //redireciona antes que gere outra referencia na base de dados
                redirect('contabil/consultar/'.$nfse['con_ref'].'/'.$id_organizacao['id_organizacao']);
            endif;

            //gera data de hoje
            $agora = new DateTime('NOW', new DateTimeZone('Brazil/East'));
            
            //organiza as informacoes de retorno
            $dados = array(
                'id_fatura'                    => $nfse['id_fatura'],
                'con_cnpj_prestador'           => $resultado['cnpj_prestador'],
                'con_ref'                      => $ref, //pega do que foi gerado aqui
                'con_numero_rps'               => '',
                'con_serie_rps'                => '',
                'con_status'                   => $resultado['status'],
                //pega do retorno, deveria ser igual a $ref
                //quando consultar, ele atualiza a base de dados com o numero definitivo
                //sem sobrescrever a referencia do sistema
                'con_numero'                   => $resultado['ref'],
                'con_codigo_verificacao'       => '',
                'con_data_emissao'             => $agora->format('Y-m-d h:i:s'),
                'con_url'                      => '',
                'con_caminho_xml_nota_fiscal'  => '',
            );

            //grava na base de dados
            $sucesso = $contabilModel->insert($dados);

            //se sucesso
            if($sucesso):
                //retorna
                $resultado['http_code'] = $http_code;
                $resultado['mensagem'] = 'Nota sendo gerada e Base de Dados Atualizada.';
                $resultado['referencia'] = strval($ref);
                return $resultado;
            //senao sucesso
            else:
                //retorna
                $resultado['http_code'] = $http_code;
                $resultado['mensagem'] = 'Nota sendo gerada mas não foi possível grava-la na base de dados.';
                $resultado['referencia'] = strval($ref);
                return $resultado;
            endif;

        //se houve erro no codigo retorno  no focus
        else:
            //retorna
            $resultado['http_code'] = $http_code;
            $resultado['status'] = "Alerta Focus";
            $resultado['referencia'] = NULL;
            return $resultado;
        endif;            
        
        
    }



 	//-----------------------------------------------------------------[SETOR Contábil > Consultar]
	//constroi a secao Consultar nota fiscal
    //
	// $ref = passa contabil.con_referencia da nota através desta variavel
    // $eid = passa o id da organizacao
    //
    // se status da consulta != status da base de dados,
    // aproveita a oportunidade e atualiza a base de dados
    //
    // retorna sting view
    //
	public function consultar($ref,$eid){

        // cria filtros de conformidades ref e eid; apenas int num
        $retorno = 1;
        $retorno = $this->filtro($ref); // retorna zero se ok

        // verifica qual organizacao irá consultar
        // $eid = 1 ? 1 = _imperhome : 2 = _qualixlav;
        
        //chama dados do ambiente conforme a organizacao que irá consultar
        //$ambiente = $this->ambiente_qualix();
        $ambiente = $this->ambiente();

        //inicia informacoes para construcao do template    
        $listagem = array(
            'TituloPagina'  => 'NFS-e | Consultar Nota',
            'referencia'    => $ref,        //que vem da url | define na primeira linha da function
            'ambiente'      => $ambiente,   //onde está rodando | gera logo acima
            'conteudo'      => '',          //tudo o que retornar cabe aqui
            'id_fatura'     => NULL,        //se encontrou de fato a ref | define na pesquisa da base
            'con_ref'       => NULL,        //retorno da referencia da nota fiscal
        );

        // se filtro continuou zero
        if($retorno == '0'):
            // Inicia Requisições a API
            $login = $ambiente['login'];
            $password = "";
            $server = $ambiente['server'];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $server."/v2/nfse/" . $ref);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            //tratando retorno
            $resultado = json_decode($body,true);

            var_dump($resultado);

            //pega o primeiro numero do codigo de retorno
            $rest = substr($http_code, 0,1);

            //se for do grupo 2 é por que passou
            if($rest == '2'):
                //imprimindo na tela
                $listagem['conteudo'] .= '<h3>Código de retorno: ' . $http_code . '</h3>';
                $listagem['conteudo'] .= 'cnpj_prestador: ' . $resultado['cnpj_prestador'].'<br>';
                $listagem['conteudo'] .= 'ref: ' . $resultado['ref'].'<br>';
                $listagem['conteudo'] .= 'numero_rps: ' . $resultado['numero_rps'].'<br>';
                //$listagem['conteudo'] .= 'serie_rps: ' . $resultado['serie_rps'].'<br>';
                $listagem['conteudo'] .= 'Status: ' . $resultado['status'] . ' | ';
                switch($resultado['status']):
                    case 'processando_autorizacao' : $listagem['conteudo'] .= ' A NFSe está sendo processada internamente (API Focus NFe) e/ou pela prefeitura, consulte após alguns minutos.';
                    break;
                    case 'autorizado' : $listagem['conteudo'] .= ' A NFSe foi autorizada com sucesso, neste caso, é fornecido os caminhos para acessar a DANFSe e XML.';
                    break;
                    case 'cancelado' : $listagem['conteudo'] .= ' Indica que a operação de cancelamento do documento foi realizada com sucesso.';
                    break;
                    case 'erro_autorizacao' : $listagem['conteudo'] .= ' Houve algum erro durante a emissão da NFSe. A mensagem de erro você encontrará dentro do campo "erros". É possível reenviar a nota com a mesma referência após realizar as correções indicadas.';
                    break;
                    case 'substituido' : $listagem['conteudo'] .= ' Este documento foi substituído por outra NFSe. Consulte o campo numero_nfse_substituta.';
                    break;
                    default: $listagem['conteudo'] .= $resultado['status'];
                endswitch;
                $listagem['conteudo'] .= '<br>';
                if(isset($resultado['codigo_verificacao'])&&($resultado['codigo_verificacao']!="")):
                    $listagem['conteudo'] .= 'codigo_verificacao: ' . $resultado['codigo_verificacao'].'<br>';
                else:
                    $resultado['chave_nfe'] = NULL;
                endif;
                if(isset($resultado['numero'])):
                    $listagem['conteudo'] .= 'numero: ' . $resultado['numero'].'<br>';
                else:
                    $resultado['numero'] = NULL;
                endif;
                if(isset($resultado['nucodigo_verificacaomero'])):
                    $listagem['conteudo'] .= 'codigo_verificacao: ' . $resultado['codigo_verificacao'].'<br>';
                else:
                    $resultado['codigo_verificacao'] = NULL;
                endif;
                if(isset($resultado['data_emissao'])):
                    $listagem['conteudo'] .= 'data_emissao: ' . $resultado['data_emissao'].'<br>';
                else:
                    $resultado['data_emissao'] = NULL;
                endif;
                if(isset($resultado['url'])):
                    $listagem['conteudo'] .= 'url:<br>';
                    $listagem['conteudo'] .= '<a href="' . $resultado['url'] . '" target="_blank">';
                    $listagem['conteudo'] .= $resultado['url'];
                    $listagem['conteudo'] .= '</a><br>';
                else:
                    $resultado['url'] = NULL;
                endif;
                if(isset($resultado['caminho_xml_nota_fiscal'])):
                    $listagem['conteudo'] .= 'caminho_xml_nota_fiscal:<br>';
                    $listagem['conteudo'] .= '<a href="' . $ambiente['server'] . $resultado['caminho_xml_nota_fiscal'] . '" target="_blank">';
                    $listagem['conteudo'] .= $resultado['caminho_xml_nota_fiscal'];
                    $listagem['conteudo'] .= '</a><br>';
                else:
                    $resultado['caminho_xml_nota_fiscal'] = NULL;
                endif;
                
                if(isset($resultado['caminho_xml_carta_correcao'])):
                    $listagem['conteudo'] .= 'caminho_xml_carta_correcao:<br> ';
                    $listagem['conteudo'] .= '<a href="' . $ambiente['server'] . $resultado['caminho_xml_carta_correcao'].'" target="_blank">';
                    $listagem['conteudo'] .= $resultado['caminho_xml_carta_correcao'];
                    $listagem['conteudo'] .= '</a>';
                    $listagem['conteudo'] .= '<br>';
                    $listagem['conteudo'] .= 'caminho_pdf_carta_correcao:<br> ';
                    $listagem['conteudo'] .= '<a href="' . $ambiente['server'] . $resultado['caminho_pdf_carta_correcao'].'" target="_blank">';
                    $listagem['conteudo'] .= $resultado['caminho_pdf_carta_correcao'];
                    $listagem['conteudo'] .= '</a>';
                    $listagem['conteudo'] .= '<br>';
                    $listagem['conteudo'] .= 'numero_carta_correcao: ' . $resultado['numero_carta_correcao'];
                else:
                    $resultado['caminho_xml_carta_correcao'] = NULL;
                endif;
                if(isset($resultado['caminho_xml_cancelamento'])):
                    $listagem['conteudo'] .= 'caminho_xml_cancelamento: <br>';
                    $listagem['conteudo'] .= '<a href="' . $ambiente['server'] . $resultado['caminho_xml_cancelamento'] . '" target="_blank">';
                    $listagem['conteudo'] .= $resultado['caminho_xml_cancelamento'];
                    $listagem['conteudo'] .= '</a>';
                else:
                    $resultado['caminho_xml_cancelamento'] = NULL;
                endif;

            //se for de outro grupo além do 2
            else:
                
                //imprimindo erro na tela
                $listagem['conteudo'] .= '<h3>Código de retorno: ' . $http_code . '</h3>';
                $listagem['conteudo'] .= $resultado['codigo'] . ' : ' . $resultado['mensagem'];
                //cria referencia null para pesquisa da nota, já que não retornou uma ação valida
                $resultado['ref'] = NULL;
            endif;

            // pega as informacoes da nota atual
            $contabilModel = new ContabilModel();
            $contabilModel->where('con_ref',$resultado['ref']);
            $nfbase = $contabilModel->findAll();
            
            // se gerou resultado pesquisando a nota no db
            if($nfbase):
                // compara se o status da base de dados é diferente ao status de retorno da consulta
                if($nfbase[0]['con_status'] != $resultado['status']):
                    //atualiza na base de dados
                    $dados = array(
                        'con_numero_rps'               => $resultado['numero_rps'],
                        'con_serie_rps'                => '',
                        'con_status'                   => $resultado['status'],
                        'con_numero'                   => $resultado['numero'],
                        'con_codigo_verificacao'       => $resultado['codigo_verificacao'],
                        'con_data_emissao'             => $resultado['data_emissao'],
                        'con_url'                      => $resultado['url'],
                        'con_caminho_xml_nota_fiscal'  => $resultado['caminho_xml_nota_fiscal'],
                    );
                    $contabilModel->where('id_contabil_s',$nfbase[0]['id_contabil_s']);
                    $contabilModel->set($dados);
                    $nfbaseatualiza = $contabilModel->update();
                endif;

                //cria identificação para cancelamento e/ou inutilizacao
                $listagem['con_ref'] = $nfbase[0]['con_ref'];

                //pega o id_fatura
                $listagem['fat_numero'] = $nfbase[0]['id_fatura'];
                $listagem['id_fatura'] = $nfbase[0]['id_fatura'];

            // se não gerou resultado pesquisando a nota no db
            else:
                session()->setFlashdata(' Não foi localizada esta referência de nota em nossa base de dados.','danger');
            endif;
        
        // se o filtro uid retornou erro
        else:
            $listagem['conteudo'] .= "Perdeu o caminho";
            $listagem['conteudo'] .= '<br>';
            $listagem['conteudo'] .= 'Total de erros no filtro: ' . $retorno;
        endif;

        //var_dump($resultado);


        
        // constroi pagina
        return view('admin/contabil/perfil', $listagem);    
    }



    //-----------------------------------------------------------------[SETOR Contábil > Enviar Email]
    //constroi a secao Enviar email da nota/
    //
    // $ref = passar o contabil_s.con_ref da nota através desta variavel
    // $email = passar o email destinatário através desta variavel
    //
    public function enviaremail($ref){

        // seleciona email do cliente
        $contabilModel = new ContabilModel();
        $contabilModel->join('fatura','contabil_s.id_fatura = fatura.id_fatura');
        $contabilModel->join('cliente','fatura.id_cliente = cliente.id_cliente');
        $contabilModel->where('contabil_s.con_ref',$ref);
        $contabilModel->select('cliente.cli_email');
        $retorno = $contabilModel->first();

        //chama dados do ambiente
        $ambiente = $this->ambiente();
        $login = $ambiente['login'];
        $password = "";
        $server = $ambiente['server'];

        $para = [
            'emails'    => [
                $retorno['cli_email'],
            ]
        ] ;
        
        // Inicia Requisições a API
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $server."/v2/nfse/" . $ref . "/email");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($para));
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
        $body = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        //tratando retorno
        $resultado = json_decode($body,true);

        $result = '<hr>';
        $result .= $http_code;
        $result .= '<br>';
        $result .= $resultado['emails'][0];

        // constroi pagina
        session()->setFlashdata('msgType','success');
        session()->setFlashdata('msg', $result );
        return redirect()->back();
    }



    //-----------------------------------------------------------------[SETOR Contábil > Cancelar]
    //constroi a secao Cancelar
    //
    // $uid = passa a contabil_s.con_ref (referencia) da nota
    // $justificativa = passar a razão do cancelamento
    //
    public function cancelar($uid=NULL,$justificativa=NULL){

        //verifica se vem por post
        if(isset($_POST['informacao_extra'])):
            $justificativa = $_POST['informacao_extra'];
        endif;
        
        //chama dados do ambiente
        $ambiente = $this->ambiente();
        
        //inicia informacoes para construcao do template    
        $listagem = array(
            'referencia'    => $uid,        //que vem da url | define na primeira linha da function
            'ambiente'      => $ambiente,   //onde está rodando | gera logo acima
            'conteudo'      => '',          //tudo o que retornar cabe aqui
            'id_fatura'     => NULL,        //se encontrou de fato a ref | defone na pesquisa da base
            'con_ref'       => NULL,        //se encontrou de fato a ref | define na pesquisa da base
        );

        // cria filtros de conformidades uid
        $retorno = 1;
        $retorno = $this->filtro($uid);
        if($justificativa==NULL): $retorno = $retorno+1; endif;

        // se filtro continuou zero
        if($retorno == '0'):
            //chama dados do ambiente
            $login = $ambiente['login'];
            $password = "";
            $server = $ambiente['server'];
            // $justifica = array("justificativa" => "Teste de cancelamento de nota"); // em homologação usar esta
            $justifica = array("justificativa" => $justificativa); // em produção usar $

            // Inicia Requisições a API
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $server . "/v2/nfse/" . $listagem['referencia']);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($justifica));
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            //tratando retorno
            $resultado = json_decode($body,true);
            var_dump($body);

            //pega o primeiro numero do codigo de retorno
            $rest = substr($http_code, 0,1);
            var_dump($http_code);

            //se for do grupo 2 é por que passou
            if($rest == '2'):
                $listagem['conteudo'] .= 'status_sefaz: ' . $resultado["status_sefaz"] . '<br>';
                $listagem['conteudo'] .= 'mensagem_sefaz: ' . $resultado["mensagem_sefaz"] . '<br>';
                $listagem['conteudo'] .= 'status: ' . $resultado["status"] . '<br>';
                if(isset($resultado["caminho_xml_cancelamento"])):
                    $listagem['conteudo'] .= 'caminho_xml_cancelamento: ';
                    $listagem['conteudo'] .= $ambiente['server'] . $resultado["caminho_xml_cancelamento"] . '<br>';
                endif;
                
            //se houve erro no codigo retorno  no focus
            else:
                //retorna
                $listagem['conteudo'] .= '<hr>';
                $listagem['conteudo'] .= $http_code;
                $listagem['conteudo'] .= '<br>';
                $listagem['conteudo'] .= 'Codigo: ' . $resultado['codigo'] . '<br>';
                $listagem['conteudo'] .= 'Mensagem: ' . $resultado['mensagem'] . '<br>';
            endif; 

        else:
            $listagem['conteudo'] .= "Perdeu o caminho";
        endif;

        // constroi pagina
        return view('admin/contabil/perfil', $listagem);
    }



    //-----------------------------------------------------------------[SETOR Contábil > Inutilizar]
    //constroi a secao Inutilizar / [ desativada ]
    //
    // $uid = passar o contabil_s.con_ref da nota através desta variavel
    // $justificativa = passar a razão da inutilizacao
    //
    private function inutilizar($uid=NULL){

        //verifica se vem por post
        $justificativa=NULL;
        if(isset($_POST['informacao_extra'])):
            $justificativa = $_POST['informacao_extra'];
        endif;
        
        //chama dados do ambiente
        $ambiente = $this->ambiente();
        
        //inicia informacoes para construcao do template    
        $listagem = array(
            'referencia'    => $uid,        //que vem da url | define na primeira linha da function
            'ambiente'      => $ambiente,   //onde está rodando | gera logo acima
            'conteudo'      => '',          //tudo o que retornar cabe aqui
            'fat_numero'    => NULL,        //se encontrou de fato a ref | defone na pesquisa da base
            'con_ref'      => NULL,        //se encontrou de fato a ref | define na pesquisa da base
        );

        //precisa tratar array, diferente das outras functions
        $inutiliza = array (
            "cnpj"              => "20875727000120",
            "serie"             => "1",
            "numero_inicial"    => $listagem['referencia'], //numero inicial do lote de nfe a ser cancelado
            "numero_final"      => $listagem['referencia'], //numero final do lote de nfe a ser cancelado
            "justificativa"     => $justificativa,  //Teste+de+inutilizacao+de+nota
        );

        // cria filtros de conformidades uid
        $retorno = 1;
        $retorno = $this->filtro($uid);
        if($justificativa==NULL): $retorno = $retorno+1; endif;

        // se filtro continuou zero
        if($retorno == '0'):
            //chama dados do ambiente
            $login = $ambiente['login'];
            $password = "";
            $server = $ambiente['server'];

            // Inicia Requisições a API
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $server."/v2/nfe/inutilizacao");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($inutiliza));
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            //tratando retorno
            $resultado = json_decode($body,true);

            if(isset($resultado['codigo'])):
                $listagem['conteudo'] .= '<hr>';
                $listagem['conteudo'] .= $http_code;
                $listagem['conteudo'] .= '<br>';
                $listagem['conteudo'] .= $resultado['codigo'];
                $listagem['conteudo'] .= $resultado['mensagem'];
                var_dump($resultado);
            endif;
            
            if(isset($resultado['status_sefaz'])):
                $listagem['conteudo'] .= 'status_sefaz: ' . $resultado["status_sefaz"] ;
                $listagem['conteudo'] .= '<hr>';
                $listagem['conteudo'] .= 'mensagem_sefaz: ' . $resultado["mensagem_sefaz"] . '<br>';
                $listagem['conteudo'] .= 'cnpj: ' . $resultado["cnpj"] . '<br>';
                $listagem['conteudo'] .= 'modelo: ' . $resultado["modelo"] . '<br>';
                $listagem['conteudo'] .= 'serie: ' . $resultado["serie"] . '<br>';
                $listagem['conteudo'] .= 'numero_inicial: ' . $resultado["numero_inicial"] . '<br>';
                $listagem['conteudo'] .= 'numero_final: ' . $resultado["numero_final"] . '<br>';
                $listagem['conteudo'] .= 'status: ' . $resultado["status"] . '<br>';// status "autorizado"
                if($resultado["status"]=='autorizado'):
                    $listagem['conteudo'] .= 'caminho_xml: ';
                    $listagem['conteudo'] .= '<a href="' . $ambiente['server'] . $resultado["caminho_xml"] . '" target="_blank">';
                    $listagem['conteudo'] .= $resultado["caminho_xml"];
                    $listagem['conteudo'] .= '</a><br>';
                    $listagem['conteudo'] .= 'protocolo_sefaz   : ' . $resultado["protocolo_sefaz"] . '<br>';
                endif;
                //var_dump($resultado);
            endif;
        
        else:
            $listagem['conteudo'] .= "Perdeu o caminho ".$retorno;
        endif;

        // constroi pagina
        return view('admin/contabil/perfil', $listagem);
    }


    // // // // // // // // //
    //constroi GATILHO /  [ ativar quando necessário ]
    //
    // homologação $hook_id = ""; // ambiente de teste
    // api $hook_id = "";
    //
    private function gatilho(){
        
        $valor = $this->request->getGet('valor');
        $valor = NULL;
 
        //chama dados do ambiente
        $ambiente = $this->ambiente();
        $login = $ambiente['login'];
        $password = "";
        // Para ambiente de produção alterne aqui
        $server = $ambiente['server'];
        // Inicia Requisições a API
        
        if($valor=='cria'):
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $server."/v2/hooks");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array("cnpj" => "20087520000190",
            "event" => "nfse", "url" => "https://nucleodenegociosweb.com.br/crm/contabil/gatilho_retorno")));
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            // As próximas três linhas são um exemplo de como imprimir as informações de retorno da API.
            print($http_code."\n");
            print($body."\n\n");
            print("");
            curl_close($ch);

            //200 { "id": "65gayNGP", "url": "https://nucleodenegociosweb.com.br/crm/contabil/gatilho_retorno", "authorization": null, "authorization_header": null, "event": "nfse", "cnpj": "20087520000190" }
            
            
        endif;

        if($valor=='consulta'):
            $ch = curl_init();
            $hook_id = "65gayNGP";
            curl_setopt($ch, CURLOPT_URL, $server."/v2/hooks/" . $hook_id);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            // As próximas três linhas são um exemplo de como imprimir as informações de retorno da API.
            print($http_code."\n");
            print($body."\n\n");
            print("");
            curl_close($ch);
        endif;


        if($valor == 'exclusao'):
            $ch = curl_init();
            $hook_id = "DRqyOZRZ";
            curl_setopt($ch, CURLOPT_URL, $server . "/v2/hooks/" . $hook_id);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $result = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            // As próximas três linhas são um exemplo de como imprimir as informações de retorno da API.
            print($http_code."\n");
            print($body."\n\n");
            print("");
            curl_close($ch);
        endif;


        if($valor == 'testa'):
            
            $con_ref = "3";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $server . "/v2/nfse/".$con_ref."/hook");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
            $body = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $result = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            // As próximas três linhas são um exemplo de como imprimir as informações de retorno da API.
            print($http_code."\n");
            print($body."\n\n");
            print($result."\n\n");
            curl_close($ch);
            
        endif;


    }


    // // // // // // // // //
    //RETORNO GATILHO
    //
    // Função public que pode ser acessada sem autenticação
    // Funçao public que é acessada pelo retorno da api.focus com informacoes sefaz nfe
    //
    public function gatilho_retorno(){
        //recebe retorno json por post
        $arr = json_decode(file_get_contents('php://input'));

        //se vier conteudo
        if(!empty($arr)):
            //armazena dados
            $dados = array(
                'con_numero_rps'               => $arr->numero_rps,
                'con_serie_rps'                => '',
                'con_status'                   => $arr->status,
                'con_numero'                   => $arr->numero,
                'con_codigo_verificacao'       => $arr->codigo_verificacao,
                'con_data_emissao'             => $arr->data_emissao,
                'con_url'                      => $arr->url,
                'con_caminho_xml_nota_fiscal'  => $arr->caminho_xml_nota_fiscal,
            );
            //chama model
            $contabilModel = new ContabilModel();

            //update na base de dados
            $contabilModel->where("con_ref", $arr->ref);
            $contabilModel->set($dados);
            $contabilModel->update();

        //senao vier conteudo, ou seja, vazio:
        else:
            //escreve na tela
            echo '<hr>';
            echo 'vazio';
        endif;
    }







/* END CLASS*/
}