<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\EvuptContatoModel;
use App\Models\EvuptDisparadorModel;
use App\Models\EvuptTemplateModel;

class Evupt extends BaseController
{



    /**
     * DISPARADOR | INDEX }
     * cria página index
     * 
     * @param NULL
     * @return string
     */
    public function index() : string {

        if($this->request->getGet('status')=='excluidos'):
            // lista todos os disparadores excluídos
            $disparadorModel = new EvuptDisparadorModel();
            $listagemDisparadores = $disparadorModel->onlyDeleted()->findAll();
            $disparadorModel->resetQuery();
        else:

            // lista todos os disparadores ativos
            $disparadorModel = new EvuptDisparadorModel();
            $listagemDisparadores = $disparadorModel->findAll();
            $disparadorModel->resetQuery();
        endif;

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          =>  'EVUPT | Página principal',
            'listagemDisparadores'  => $listagemDisparadores,

        ];
        return view('admin/evupt/evuptDisparador-index', $dados);
    }



    /**
     * DISPARADOR | CADASTRA }
     * cria a página de cadastro de disparador
     * 
     * @param null
     * @return string
     */
    public function cadastra() : string {

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          =>  'EVUPT | Cadastrar novo disparador',

        ];
        return view('admin/evupt/evuptDisparador-cadastra', $dados);
    }



    /**
     * DISPARADOR | CADASTRAR}
     * cria a funcionalidade de cadastro
     * ao final reotrna para a function cadastra
     * 
     * @param null
     * @return string
     */
    public function cadastrar() {

        // recebe informações do formulário disparador
        $formulario = $this->request->getPost();

        // cria regras de formulario
        $rules = [
            'input_nome' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_email' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_reply' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_senha' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_secure' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_smtp' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_porta' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_boturl' =>[
                'rules'     => 'permit_empty',
                'errors'    => [],
            ],
            'input_botauth' =>[
                'rules'     => 'permit_empty',
                'errors'    => [],
            ],
            'input_bothash' =>[
                'rules'     => 'permit_empty',
                'errors'    => [],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)){
            // recarrega a página
            return redirect()->back()->withInput();

        // Validação executou com sucesso
        }else{

            // organiza dados
            $dados = [
                'dis_nome'      => $formulario['input_nome'],
                'dis_email'     => $formulario['input_email'],
                'dis_reply'     => $formulario['input_reply'],
                'dis_senha'     => $formulario['input_senha'],
                'dis_secure'    => $formulario['input_secure'],
                'dis_smtp'      => $formulario['input_smtp'],
                'dis_porta'     => $formulario['input_porta'],
                'dis_boturl'    => $formulario['input_boturl'],
                'dis_botauth'   => $formulario['input_botauth'],
                'dis_bothash'   => $formulario['input_bothash'],
            ];

            // insere na base de dados
            $disparadorModel = new EvuptDisparadorModel();

            // insere na base : apresentou erro
            if(!$disparadorModel->save($dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro No Cadastrado do Disparador.');
                return redirect()->back()->withInput();

            //  insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Disparador cadastrado com Sucesso.');
                return redirect()->to('/evupt');
            endif;
   
        }
        
    }



    /**
     * DISPARADOR | EDITA }
     * editar informações do disparadorr
     * 
     * @param $id
     * @return string
     */
    public function edita($id) {

        // sanitiza informacao recebida
        $id_disparador = trim($id);

        // se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_nome' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_email' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_senha' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_secure' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_smtp' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_reply' =>[
                    'rules'     => 'permit_empty',
                ],
                'input_porta' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_boturl' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [],
                ],
                'input_botauth' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [],
                ],
                'input_bothash' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                session()->setFlashdata('msgType','danger');
                session()->setFlashdata('msg','Não validou');
                return redirect()->back()->withInput();

            }else{

                // recebe os dados
                $formulario = $this->request->getPost();

                // organiza dados
                $dados = [
                    'dis_nome'          => $formulario['input_nome'],
                    'dis_email'         => $formulario['input_email'],
                    'dis_senha'         => $formulario['input_senha'],
                    'dis_secure'        => $formulario['input_secure'],
                    'dis_smtp'          => $formulario['input_smtp'],
                    'dis_reply'         => $formulario['input_reply'],
                    'dis_porta'         => $formulario['input_porta'],
                    'dis_boturl'        => $formulario['input_boturl'],
                    'dis_botauth'       => $formulario['input_botauth'],
                    'dis_bothash'       => $formulario['input_bothash'],
                ];

                // insere na base de dados
                $disparadorModel = new EvuptDisparadorModel();

                // Atualiza na base : apresentou erro
                if(!$disparadorModel->update($id_disparador, $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'danger');
                    session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                    return redirect()->back()->withInput();

                //  Atualiza na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Template Atualizado com sucesso.');
                    return redirect()->to('/evupt/edita/'.$id_disparador);
                endif;
            }
        }

        // continua se não veio por post

        // listar disparador
        $disparadorModel = new EvuptDisparadorModel();
        $disparadorModel->where('id_disparador',$id_disparador);
        $disparador = $disparadorModel->first();
        $disparadorModel->resetQuery();
        
        // listar cadastros relacionados        
        $contatoModel = new EvuptContatoModel();
        $contatoModel->where('id_disparador',$id_disparador);
        $cadastro = $contatoModel->findAll();
        $contatoModel->resetQuery();
        
        // listar templates de mensagens relacionados
        $templateModel = new EvuptTemplateModel();
        $templateModel->where('id_disparador',$id_disparador);
        $template = $templateModel->findAll();
        $templateModel->resetQuery();

        // relatorio de disparos relacionados
        $contatoModel->where('id_disparador',$id_disparador);
        $contatoModel->orderBy('updated_at','ASC');
        $relatorio = $contatoModel->findAll(5);
        $templateModel->resetQuery();
        
        // total disparado / total restante
        $contatoModel->where('id_disparador',$id_disparador);
        $contatoModel->where('con_status',1);
        $total['lista'] = $contatoModel->countAllResults();
        $templateModel->resetQuery();

        $total['disparado'] = ' ';

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          => 'EVUPT | Disparador > Editar',
            'disparador'            => $disparador,
            'cadastro'              => $cadastro,
            'template'              => $template,
            'relatorio'             => $relatorio,
            'total'                 => $total,

        ];
        return view('admin/evupt/evuptDisparador-edita', $dados);
    }



    /**
     * 
     * DISPARADOR | TESTAR DISPARO }
     * cria estrutura de disparo teste do whatsapp
     * cria estrutura de disparo teste do EMAIL
     * 
     */ 

    // função realiza disparo de um template
    // sugerido antes de iniciar uma campanha
    public function testarDisparoTemplate($meio,$id_disparador,$id_template){

        $meio = 'email';

        // requere informacoes do template
        $evuptTemplateModel = new EvuptTemplateModel();
        $evuptTemplateModel->where('id_template', $id_template);
        $template = $evuptTemplateModel->first();
        $evuptTemplateModel->resetQuery();

        // customiza variaveis
        $find = [ '{{nome}}' ];
        $replace = [ 'nome' => 'ale' ];
        $template['tem_corpo'] = str_replace($find, $replace, $template['tem_corpo']);

        // faz envio
        $retorno = $this->testarDisparoEmail( $id_disparador, 'lecowd@gmail.com', $template['tem_titulo'], $template['tem_corpo']);

        // imprimi retorno recarrega a página
        session()->setFlashdata('msgType','info');
        session()->setFlashdata('msg', $retorno);
        return redirect()->back();

    }

    // testa se funciona o disparador geral daquela campanha
    // função realiza disparo sem usar um template
    // sugerido antes de iniciar uma campanha
    public function testarDisparo($meio,$id_disparador){

        $meio           = trim($meio);
        $id_disparador  = trim($id_disparador);
        $cad_email      = 'lecowd@gmail.com';
        $cad_whats      = '11969113261'; // whats carol
        $assunto        = '[ Teste Disparador ]';
        $mensagem       = 'id_disparador: '. $id_disparador;

        // se $meio 1 == testar email
        if($meio == 1):
            $retorno = $this->testarDisparoEmail($id_disparador,$cad_email,$assunto,$mensagem);
            $retorno_arr = json_decode($retorno, true);
            if($retorno_arr['status'] == false):
                session()->setFlashdata('msgType', 'danger');
                session()->setFlashdata('msg', $retorno_arr['message']);
                return redirect()->back()->withInput();
            else:
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', $retorno_arr['message']);
                return redirect()->to('/evupt/edita/'.$id_disparador);
            endif;
        endif;

        // se $meio 2 == testar whatsapp
        if($meio == 2):
            $retorno = $this->testarDisparoWhats($id_disparador,$cad_whats,$assunto,$mensagem);
            $retorno_arr = json_decode($retorno, true);
            if($retorno_arr['status'] == false):
                session()->setFlashdata('msgType', 'danger');
                session()->setFlashdata('msg', $retorno_arr['message']);
                return redirect()->back()->withInput();
            else:
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', $retorno_arr['message']);
                return redirect()->to('/evupt/edita/'.$id_disparador);
            endif;
        endif;
    }

    //
    // MOTOR Dispara whats . Realiza toda a organização antes do disparo
    private function testarDisparoWhats($id_disparador,$cad_whats,$assunto,$mensagem){

        // seleciona o motor que irá disparar
        $disparadorModel = new EvuptDisparadorModel();
        $disparador = $disparadorModel->where('id_disparador',$id_disparador)->first();

        // verifica se o status do bot está ativo
		$url = $disparador['dis_boturl'] . 'status-sessao';
        $result = $this->botStatusConexao($url, $disparador['dis_botauth'], $disparador['dis_bothash']);

        // se status do bot retorno == null, então não existe bot criado nem sessão iniciada. Crie uma seção antes.
        if($result == null || is_array($result['message']) ):
            $response = json_encode(['status' => false, 'message'  => 'Crie antes uma seção para ser autenticada.']);
            return $response;
        endif;
        
        // se status do bot retornou == true
        // remove bla bla bla mensagem e define null ou connected
        $resultStatus = explode(' ',$result['message']);
        $result['message'] = $resultStatus[sizeof($resultStatus) - 1];

        // se a mensagem retornou NULL, então pega qrCode criado para autenticar seção
        if($result['message'] == 'null'):
            $path = $disparador['dis_boturl'] . 'lecowd/' . $disparador['dis_botauth'] . '/qrcode.png';
            $response = json_encode(['status' => true, 'message'  => 'Seção criada. Leia o qrCode: <br><img src="'.$path.'">']);
        endif;
        
        // se a mensagem retornou inválido, então precisa criar um bot
        if($result['message'] == 'inválido'):
            $response = json_encode(['status' => false, 'message'  => 'Bot não encontrado. Crie antes uma seção para ser autenticada.']);
        endif;
        
        // se a mensagem retornou CONNECTED, então faz o disparo
        if($result['message'] == 'CONNECTED'):
            // $response = json_encode(['status' => true, 'message'  => 'Conectado']);
            $response = $this->botDisparaWhats($disparador['dis_boturl'],$disparador['dis_botauth'],$disparador['dis_bothash'],$cad_whats,$mensagem);
        endif;

        // retorna resultado
        return $response;
     
    }
    //
    // MOTOR Dispara email . Realiza toda a organização antes do disparo
    private function testarDisparoEmail($id_disparador,$cad_email,$assunto,$mensagem){
        
        // seleciona o disparador que alimenta o motor
        $disparadorModel = new EvuptDisparadorModel();
        $disparador = $disparadorModel->where('id_disparador',$id_disparador)->first();
        
        // inicia o serviço de email do sistema
        $email = \Config\Services::email();
        $config = [
            'protocol'  => 'smtp',
            'SMTPHost'  => $disparador["dis_smtp"],
            'SMTPUser'  => $disparador["dis_email"],
            'SMTPPass'  => $disparador["dis_senha"],
            'SMTPPort'  => $disparador["dis_porta"],
            'wordWrap'  => true,
            'mailType'  => 'html',
        ];
        
        $email->clear(true);
        $email->initialize($config);
        $email->setFrom($disparador["dis_email"], ' Não responda ');
        $email->setTo($cad_email);
        $email->setReplyTo($disparador["dis_reply"]);
        $email->setSubject($assunto);
        // cria template para o email
        // cria template para o email
        $message = '<html><head>';
        $message .= '<style>';
        $message .= ':root {';
        $message .= '--font: "Verdana, sans-serif";';
        $message .= '}';
        $message .= 'body {';
        $message .= 'font-family: var(--font, "Arial, sans-serif");';
        $message .= '}';
        $message .= '</style>';
        $message .= '</head><body>';
        $message .= '<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" style="background-color:rgb(244,244,244)">';
        $message .= '<tr>';
        $message .= '<td align="center" valign="top">';

        $message .= '<table width="600px" cellpadding="10" cellspacing="0" border=0 style="text-align:left; background-color:#FFFFFF">';
        $message .= '<tr>';
        $message .= '<td>';
        $message .= nl2br($mensagem);
        $message .= '</td>';
        $message .= '</tr>';
        $message .= '</table>';

        $message .= '<table width="600px" cellpadding="10" cellspacing="0" border=0 style="text-align:left; background-color:#FFFFFF">';
        $message .= '<tr>';
        $message .= '<td>';
        $message .= '<br>';
        $message .= '<hr>';
        $message .= '<br>';
        $message .= '<center><small>Você está recebendo este email por que solicitou a entrada em nossa lista em algum momento.<br> ' . anchor('evupt/inscricaoCancela/'.$id_disparador.':'.$cad_email,'Clique Aqui e Cancele') . ' sua inscrição caso não seja mais pertinente receber descontos e dicas de como ter uma vida mais tranquila e economizar.</small></center>';
        $message .= '</td>';
        $message .= '</tr>';
        $message .= '</table>';

        $message .= '</td>';
        $message .= '</tr>';
        $message .= '</table>';
        $message .= '<body></html>';
        // define template no email
        $email->setMessage($message);

        // envia mensagem e retorna resultado
        if (! $email->send()):
            $response = json_encode(['status' => false, 'message'  => 'Erro: ' . $email->printDebugger()]);
        else:
            $response = json_encode(['status' => true, 'message'  => 'Email enviado']);
        endif;

        return $response;
    }



    /**
     * DISPARADOR | TESTAR STATUS }
     * sugerido antes de iniciar uma campanha
     * 
     * é igual ao private function botStatusConexao, mas sem url
     * 
     * estamos testando se é necessário url ou então deixamos com a busca do login e senha
     * atraves da base de dados!!
     * 
     */
    public function testarStatus($id_disparador){

        // declaracao
        $disparadorModel = new EvuptDisparadorModel();

        // seleciona informações do disparador
        $id_disparador = trim($id_disparador);
        $disparador = $disparadorModel->where('id_disparador',$id_disparador)->first();

        // requere informacao
        $url = $disparador['dis_boturl'] . 'status-sessao';
        $result = $this->botStatusConexao($url,$disparador['dis_botauth'],$disparador['dis_bothash']);

        // retorna resultado
        if($result['status'] == true):
            session()->setFlashdata('msgType', 'success');
            session()->setFlashdata('msg', $result['message']);
            return redirect()->to('/evupt/edita/'.$id_disparador);
        else:
            if(is_array($result['message'])): $result['message'] = implode(' ',$result['message']); endif;
            session()->setFlashdata('msgType', 'danger');
            session()->setFlashdata('msg', $result['message']);
            return redirect()->back()->withInput();
        endif;
    }



    // [ BOT ] . realiza verificacao status bot
    private function botStatusConexao($url,$dis_botauth,$dis_bothash){

        $ch = curl_init( $url );
		$payload = json_encode( array( "id" => $dis_botauth, "token" => $dis_bothash) );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $payload );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$result = json_decode(curl_exec($ch),true);
		curl_close($ch);

        return $result;
    }

    // [ BOT ] . realiza disapro do whatsapp bot
    private function botDisparaWhats($url,$botAuth,$botHash,$cad_whats,$mensagem) {

        // aplica padrão de disparo ao número
        $whats  = str_replace([' ','(',')','-','.'],'', $cad_whats);        // remove caracteres
        $ddi    = '55';//'+55';                                             // define ddi
        $ddd    = substr($whats,0,2);                                       // pega dois primeiros numeros
        $numero = substr($whats,-8,strlen($whats));                         // pega ultimos 8 numeros
        if($ddd <= '33'):
            $numero = '9' . $numero;                                        // adiciona 9 a mais quando precisar
        endif;
        $whats = $ddi.$ddd.$numero;

        //dispara a mensagem
        $curl = curl_init();
        $postData = [
            "user"      => $whats,
            "message"   => $mensagem,
            "sender"    => $botAuth,
            "token"     => $botHash,
        ];
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . 'send-message',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postData),
            CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }

    /**
     * [ BOT ] . REMOVE SESSAO }
     * remove a sessao aberta no whatsapp
     * após remover criar com outro nome
     * 
     */
    public function botRemoveSessao($id_disparador) {

        // seleciona a sessao que irá ser removida
        $disparadorModel = new EvuptDisparadorModel();
        $disparador = $disparadorModel->where('id_disparador',$id_disparador)->first();
        $disparadorModel->resetQuery();

        // remove
		$url = $disparador['dis_boturl'] . "deletar-sessao";	
		$ch = curl_init( $url );
		$payload = json_encode( array( "id" => $disparador['dis_botauth'], "token" => $disparador['dis_bothash']) );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $payload );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$result = curl_exec($ch);
		curl_close($ch);
        $retorno_arr = json_decode($result, true);

        // recebeu retorno status deletou == false
        if($retorno_arr['status'] == false):

            // recarrega a página com mensagem
            session()->setFlashdata('msgType', 'danger');
            session()->setFlashdata('msg', $retorno_arr['message']);
            return redirect()->back()->withInput();

        // recebeu retorno status deletou == true
        else:

            // atualiza base de dados sem o nome do bot
            $disparadorModel->update($id_disparador,['dis_botauth'=>'','dis_bothash'=>'']);
            $disparadorModel->resetQuery();

            // redireciona a página
            session()->setFlashdata('msgType', 'success');
            session()->setFlashdata('msg', $retorno_arr['message']);
            return redirect()->to('/evupt/edita/'.$id_disparador);
        endif;
    }

    /**
     * [ BOT ] . CRIA NOVA SESSAO }
     * remove a sessao aberta no whatsapp
     * após remover criar com outro nome
     * 
     */
    public function botCriaSessao($id_disparador) {

        // seleciona a sessao que irá ser criada
        $disparadorModel = new EvuptDisparadorModel();
        $disparador = $disparadorModel->where('id_disparador',$id_disparador)->first();
        $disparadorModel->resetQuery();

        // se estiver o campo em branco, cria um bot com nome aleatorio
        if(!$disparador['dis_botauth']):

            // atualiza base de dados com o nome do bot
            $disparadorModel->update($id_disparador,['dis_botauth'=>sprintf('%07X', mt_rand(0, 0xFFFFFFF)),'dis_bothash'=>sprintf('%07X', mt_rand(0, 0xFFFFFFF))]);
            $disparadorModel->resetQuery();

            // seleciona a sessao que irá ser criada
            $disparador = $disparadorModel->where('id_disparador',$id_disparador)->first();
            $disparadorModel->resetQuery();
        endif;

        // cria
		$url = $disparador['dis_boturl'] . "criar-sessao";
		$ch = curl_init( $url );
		$payload = json_encode( array( "id" => $disparador['dis_botauth'], "token" => $disparador['dis_bothash']) );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $payload );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$result = curl_exec($ch);
		curl_close($ch);

        $retorno_arr = json_decode($result, true);

        // recebeu retorno status criou == false
        if($retorno_arr['status'] == false):

            // recarrega a página com mensagem
            session()->setFlashdata('msgType', 'danger');
            session()->setFlashdata('msg', $retorno_arr['message']);
            return redirect()->back()->withInput();

        // recebeu retorno status criou == true
        else:

            // redireciona a página
            session()->setFlashdata('msgType', 'success');
            session()->setFlashdata('msg', $retorno_arr['message']);
            return redirect()->to('/evupt/edita/'.$id_disparador);
        endif;
    }



    /**
     * DISPARADOR | EXCLUI }
     * exclui o dispararor soft delete
     * 
     * 
     * @param $id
     * @return string
     */
    public function exclui($id) {
        
        // sanitiza informacao recebida
        $id_disparador = trim($id);

        // Exclui disparador        
        $disparadorModel = new EvuptDisparadorModel();
        $confirma = $disparadorModel->delete($id_disparador);

        // excluir cliente retornou erro
        if(!$confirma):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir Disparador.');
            return redirect()->back();

        // excluiu cliente com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Disparador Excluído com sucesso.');
            return redirect()->to('/evupt');

        endif;

    }



    // -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    // CONTATOS
    // -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=



    /**
     * CONTATO | CADASTRA }
     * cadastra novos contatos para um disparador
     * 
     * 
     * @param $id
     * @return string
     */
    public function contatoCadastra($id) {
        
        // sanitiza informacao recebida
        $id_disparador = trim($id);

        // seleciona todos os disparadores
        $disparadorModel = new EvuptDisparadorModel();
        $disparadorModel->select('id_disparador,dis_nome');
        $disparadores = $disparadorModel->findAll();
        $disparadorModel->resetQuery();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          => 'EVUPT | Disparador | Contato Cadastra',
            'id_disparador'         => $id_disparador,
            'disparadores'          => $disparadores,

        ];
        return view('admin/evupt/evuptContato-cadastra', $dados);
    }



    /**
     * CONTATO | CADASTRAR }
     * realiza a ação de cadastrar
     * 
     * 
     * @param $id
     * @return string
     */
    public function contatoCadastrar() {
        
        // recebe informações do formulário disparador
        $formulario = $this->request->getPost();

        // se vem id_disparador 0 retorna . hack
        if($formulario['input_disparador'] == 0):
            session()->setFlashdata('msgType', 'danger');
            session()->setFlashdata('msg', 'selecione um disparador.');
            return redirect()->back()->withInput();
        endif;

        // cria regras de formulario
        $rules = [
            'input_disparador' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_nome' =>[
                'rules'     => 'permit_empty',
                'errors'    => [],
            ],
            'input_whats' =>[
                'rules'     => 'permit_empty',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_email' =>[
                'rules'     => 'permit_empty|valid_email',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                    'valid_email'  => 'É necessário preencher este campo corretamente.',
                ],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)){
            // recarrega a página
            return redirect()->back()->withInput();

        // Validação executou com sucesso
        }else{

            // organiza dados
            $dados = [
                'id_disparador'     => $formulario['input_disparador'],
                'con_nome'          => $formulario['input_nome'],
                'con_whats'         => $formulario['input_whats'],
                'con_email'         => $formulario['input_email'],
                'con_relatorio'     => '',
                'con_status'        => 1,
            ];

            // insere na base de dados
            $contatoModel = new EvuptContatoModel();

            // insere na base : apresentou erro
            if(!$contatoModel->save($dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro No Cadastrado do contato.');
                return redirect()->back()->withInput();

            //  insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Contato cadastrado com Sucesso.');
                return redirect()->to('/evupt/edita/'.$dados['id_disparador']);
            endif;
        }
        
    }



    /**
     * CONTATO | EDITAR }
     * realiza a ação de editar o contato passado
     * 
     * 
     * @param $id
     * @return string
     */
    public function contatoEdita($id) {

        // sanitiza id
        $id_contato = trim($id);

        // se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_disparador' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_nome' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_whats' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_email' =>[
                    'rules'     => 'permit_empty|valid_email',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                        'valid_email'  => 'É necessário preencher este campo corretamente.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                session()->setFlashdata('msgType','danger');
                session()->setFlashdata('msg','Não validou');
                return redirect()->back()->withInput();

            }else{

                // recebe os dados
                $formulario = $this->request->getPost();

                // organiza dados
                $dados = [
                    'id_disparador'     => $formulario['input_disparador'],
                    'con_nome'          => $formulario['input_nome'],
                    'con_whats'         => $formulario['input_whats'],
                    'con_email'         => $formulario['input_email'],
                    'con_status'        => $formulario['input_status'],
                ];

                // insere na base de dados
                $contatoModel = new EvuptContatoModel();

                // Atualiza na base : apresentou erro
                if(!$contatoModel->update($formulario['input_id'], $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'danger');
                    session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                    return redirect()->back()->withInput();

                //  Atualiza na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Template Atualizado com sucesso.');
                    return redirect()->to('/evupt/edita/'.$dados['id_disparador']);
                endif;
            }
        }
        
        // continua se não veio por post

        // seleciona dados do contato
        $contatoModel = new EvuptContatoModel();
        $contatoModel->where('id_contato',$id_contato);
        $contato = $contatoModel->first();
        $contatoModel->resetQuery();
        
        // seleciona todos os disparadores
        $disparadorModel = new EvuptDisparadorModel();
        $disparadorModel->select('id_disparador,dis_nome');
        $disparadores = $disparadorModel->findAll();
        $disparadorModel->resetQuery();

        // constroi pagina
        $dados = [
            'TituloPagina'          => 'EVUPT | Disparador | Contato Edita',
            'disparadores'          => $disparadores,
            'contato'               => $contato,
        ];
        return view('admin/evupt/evuptContato-edita', $dados);
    }



    /**
     * API CONTATO | ATIVA }
     * realiza a ação de cadastrar um novo contato através da api
     * 
     * enviar => url/id_disparador:email@dominio.com.br
     * 
     * @param $id_disarador:$email
     * @return string bool || string
     */
    public function inscricao($id) {

        // variaveis
        $mensagemErro = '';
        $saidaRequerida = trim($this->request->getGet('output')); // recebe tipo de retorno
        $id = explode(':',$id);
        $id_disparador = (int) $id[0];
        $con_email = $id[1];

        //previne se não vir os campos id e email
        if(count($id) < 2){

            if( $saidaRequerida == 1){
                return $this->response->setJSON( false );
                die;
            }else{
                $mensagemErro = 'Houve um erro no procedimento. Neste caso pedimos que retorne o email solicitando a remoção manual de seus dados, que será realizada o mais breve possível.';
            }

        }
        
        // seleciona contato
        $evuptContatoModel = new EvuptContatoModel();
        $contato = $evuptContatoModel->where('id_disparador',$id_disparador)->where('con_email',$con_email)->first();
        $evuptContatoModel->resetQuery();
        
        // previne se não encontrar o cadastro
        if($contato){
            
            if( $saidaRequerida == 1){
                return $this->response->setJSON( false );
                die;
            }else{
                $mensagemErro = 'Já existe contato na base de dados.';
            }

            $create = false;
            

        }else{

            //desativa status do id
            $create = $evuptContatoModel->insert([
                'id_disparador' => $id_disparador,
                'con_email'     => $con_email,
                'con_status'    =>'1'

            ]);
            
            if( $saidaRequerida == 1){

                // retorno da atualização modo bool
                return $this->response->setJSON( $create );
                die;

            }else{

                // retorno da criacao modo visual
                // continua e abre a página com mensagem de sucesso

            }

        }

        // cria página de retorno
        echo '<!doctype html>';
        echo '<html lang="en">';
        echo '<head>';
        echo '<meta charset="utf-8">';
        echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
        echo '<title>QualixLav Lavanderia</title>';
        echo '<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">';
        echo '</head>';
        echo '<body>';

        echo '<div class="container vh-1">';
        echo '<div class="row justify-content-center">';

        echo '<div class="px-4 py-5 my-5 text-center">';
        echo '<h1>Agradecemos seu feedback</h1>';

        if($create):
            echo '<p class="alert alert-success">Seu email foi removido de nossa lista.</p>';
        else:
            if($mensagemErro==''):
                echo '<p class="alert alert-danger">Não foi possível atualizar a base de dados</p>';
            else:
                echo '<p class="alert alert-danger">'. $mensagemErro . '</p>';
            endif;

        endif;

        echo "<p>Contem sempre com a gente.</p>";
        echo '<a href="https://www.qualixlav.com.br"><img src="https://qualixlav.com.br/images/banner-desktop-economizetempoeenergia.png" width="100%"></a>';  
        echo '</div>';
        echo '</div>';
        echo '</div>';
        echo '<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>';
        echo '</body>';
        echo '</html>';

    }



    /**
     * API CONTATO | CANCELA }
     * realiza a ação de cancelar a inscrição do contato através da api
     * 
     * enviar => url/id_disparador:email@dominio.com.br
     * 
     * @param $id_disarador:$email
     * @return string bool || string
     */
    public function inscricaoCancela($id) {

        // variaveis
        $mensagemErro = '';
        $saidaRequerida = trim($this->request->getGet('output')); // recebe tipo de retorno
        $id = explode(':',$id);
        $id_disparador = (int) $id[0];
        $con_email = $id[1];

        //previne se não vir os campos id e email
        if(count($id) < 2){

            if( $saidaRequerida == 1){
                return false;
            }else{
                $mensagemErro = 'Houve um erro no procedimento. Neste caso pedimos que retorne o email solicitando a remoção manual de seus dados, que será realizada o mais breve possível.';
            }

        }
        
        // seleciona contato
        $evuptContatoModel = new EvuptContatoModel();
        $contato = $evuptContatoModel->where('id_disparador',$id_disparador)->where('con_email',$con_email)->first();
        $evuptContatoModel->resetQuery();
        
        // previne se não encontrar o cadastro
        if(!$contato){
            
            if( $saidaRequerida == 1){
                return false;
            }else{
                $mensagemErro = 'Houve uma dificuldade em encontrar a lista ou seu email em nossos cadastros. Neste caso pedimos que retorne o email solicitando a remoção manual de seus dados que será realizada o mais breve possível.';
            }

            $update = false;
            

        }else{

            //desativa status do id
            $update = $evuptContatoModel->update($contato['id_contato'],['con_status'=>'0']);
            
            if( $saidaRequerida == 1){

                // retorno da atualização modo bool
                return $update;

            }else{

                // retorno da atualização modo visual
                // continua e abre a página com mensagem de sucesso

            }

        }



        // cria página de retorno
        echo '<!doctype html>';
        echo '<html lang="en">';
        echo '<head>';
        echo '<meta charset="utf-8">';
        echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
        echo '<title>QualixLav Lavanderia</title>';
        echo '<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">';
        echo '</head>';
        echo '<body>';

        echo '<div class="container vh-1">';
        echo '<div class="row justify-content-center">';

        echo '<div class="px-4 py-5 my-5 text-center">';
        echo '<h1>Agradecemos seu feedback</h1>';

        if($update):
            echo '<p class="alert alert-success">Seu email foi removido de nossa lista.</p>';
        else:
            if($mensagemErro==''):
                echo '<p class="alert alert-danger">Não foi possível atualizar a base de dados</p>';
            else:
                echo '<p class="alert alert-danger">'. $mensagemErro . '</p>';
            endif;

        endif;

        echo "<p>Contem sempre com a gente.</p>";
        echo '<a href="https://www.qualixlav.com.br"><img src="https://qualixlav.com.br/images/banner-desktop-economizetempoeenergia.png" width="100%"></a>';  
        echo '</div>';
        echo '</div>';
        echo '</div>';
        echo '<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>';
        echo '</body>';
        echo '</html>';

    }



    /**
     * CONTATO | EXCLUIR }
     * remove o contato
     * 
     * 
     * @param $id
     * @return string
     */
    public function contatoExclui($id) {
        
        // sanitiza informacao recebida
        $id_contato = trim($id);

        // seleciona disparador
        $contatoModel = new EvuptContatoModel();
        $contatoModel->select('id_disparador');
        $contatoModel->where('id_contato',$id_contato);
        $id_disparador = $contatoModel->first();
        $contatoModel->resetQuery();

        // Exclui contato
        $confirma = $contatoModel->delete($id_contato);

        // excluir cliente retornou erro
        if(!$confirma):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir Contato.');
            return redirect()->back();

        // excluiu cliente com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Contato Excluído com sucesso.');
            return redirect()->to('/evupt/edita/'.$id_disparador['id_disparador']);

        endif;
    }



    // -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    // TEMPLATES
    // -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=



    /**
     * TEMPLATE | CADASTRA }
     * cadastra novos templates de disparao para um disparador
     * 
     * 
     * @param $id
     * @return string
     */
    public function templateCadastra($id) : string {

        // sanitiza informacao recebida
        $id_disparador = trim($id);

        // seleciona todos os disparadores
        $disparadorModel = new EvuptDisparadorModel();
        $disparadorModel->select('id_disparador,dis_nome');
        $disparadores = $disparadorModel->findAll();
        $disparadorModel->resetQuery();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          => 'EVUPT | Disparador | Template Cadastra',
            'id_disparador'         => $id_disparador,
            'disparadores'          => $disparadores,

        ];
        return view('admin/evupt/evuptTemplate-cadastra', $dados);

    }



    /**
     * TEMPLATE | CADASTRAR }
     * Executa a função cadastrar
     * 
     * 
     * @param $id
     * @return string
     */
    public function templateCadastrar() {
        
        // recebe informações do formulário
        $formulario = $this->request->getPost();
        
        // se vem id_disparador 0 retorna . hack
        if($formulario['input_disparador'] == 0):
            session()->setFlashdata('msgType', 'danger');
            session()->setFlashdata('msg', 'selecione um disparador.');
            return redirect()->back()->withInput();
        endif;
        
        // cria regras de formulario
        $rules = [
            'input_disparador' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_prazo' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_titulo' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
            'input_corpo' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'É necessário preencher este campo.',
                ],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)){
            // recarrega a página
            return redirect()->back()->withInput();

        // Validação executou com sucesso
        }else{

            // organiza dados
            $dados = [
                'id_disparador'     => $formulario['input_disparador'],
                'tem_prazo'         => $formulario['input_prazo'],
                'tem_titulo'        => $formulario['input_titulo'],
                'tem_corpo'         => $formulario['input_corpo'],
                'tem_status'        => $formulario['input_status'],
            ];

            // insere na base de dados
            $templateModel = new EvuptTemplateModel();

            // insere na base : apresentou erro
            if(!$templateModel->save($dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro No Cadastrado do template.');
                return redirect()->back()->withInput();

            //  insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Template cadastrado com Sucesso.');
                return redirect()->to('/evupt/edita/'.$dados['id_disparador']);
            endif;
        }
        
    }



    /**
     * TEMPLATE | EDITAR }
     * realiza a ação de editar o template de envio
     * 
     * 
     * @param $id
     * @return string
     */
    public function templateEdita($id) {

        // sanitiza id
        $id_template = trim($id);

        // se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_disparador' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_prazo' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_titulo' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_corpo' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                session()->setFlashdata('msgType','danger');
                session()->setFlashdata('msg','Não validou');
                return redirect()->back()->withInput();

            }else{

                // recebe os dados
                $formulario = $this->request->getPost();

                // organiza dados
                $dados = [
                    'id_disparador'     => $formulario['input_disparador'],
                    'tem_prazo'         => $formulario['input_prazo'],
                    'tem_titulo'        => $formulario['input_titulo'],
                    'tem_corpo'         => $formulario['input_corpo'],
                    'tem_status'        => $formulario['input_status'],
                ];

                // insere na base de dados
                $templateModel = new EvuptTemplateModel();

                // Atualiza na base : apresentou erro
                if(!$templateModel->update($formulario['input_id'], $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'danger');
                    session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                    return redirect()->back()->withInput();

                //  Atualiza na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Template Atualizado com sucesso.');
                    return redirect()->to('/evupt/templateEdita/' . $id_template );
                    // return redirect()->to('/evupt/edita/'.$dados['id_disparador']);
                endif;
            }
        }
        
        // continua se não veio por post

        // seleciona dados do template
        $templateModel = new EvuptTemplateModel();
        $templateModel->where('id_template',$id_template);
        $template = $templateModel->first();
        $templateModel->resetQuery();
        
        // seleciona todos os disparadores
        $disparadorModel = new EvuptDisparadorModel();
        $disparadorModel->select('id_disparador,dis_nome');
        $disparadores = $disparadorModel->findAll();
        $disparadorModel->resetQuery();

        // constroi pagina
        $dados = [
            'TituloPagina'          => 'EVUPT | Disparador | Template Edita',
            'disparadores'          => $disparadores,
            'template'              => $template,
        ];
        return view('admin/evupt/evuptTemplate-edita', $dados);
    }



    /**
     * TEMPLATE | EXCLUIR }
     * remove o template
     * 
     * 
     * @param $id
     * @return string
     */
    public function templateExclui($id) {
        
        // sanitiza informacao recebida
        $id_template = trim($id);

        // seleciona disparador
        $templateModel = new EvuptTemplateModel();
        $templateModel->select('id_disparador');
        $templateModel->where('id_template',$id_template);
        $id_disparador = $templateModel->first();
        $templateModel->resetQuery();

        // Exclui template
        $confirma = $templateModel->delete($id_template);

        // excluir cliente retornou erro
        if(!$confirma):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir Template.');
            return redirect()->back();

        // excluiu cliente com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Template Excluído com sucesso.');
            return redirect()->to('/evupt/edita/'.$id_disparador['id_disparador']);

        endif;
    }





}