<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Libraries\Asaas;
use App\Models\FaturaModel;
use App\Models\FaturaFormapgtoModel;
use App\Models\FaturaFormapgtoBoletoModel;
use App\Models\ClienteModel;
use App\Models\ClientePedidoModel;
use App\Models\ContabilModel;
use App\Models\FaturamentoModel;
use DateTime;
use DateTimeZone;

class Fatura extends BaseController
{

    // status
    // case 0: $fatura['fat_status'] = 'Pago';
    // case 1: $fatura['fat_status'] = 'Aberto';
    // case 2: $fatura['fat_status'] = 'Cancelado';

    // periodos
    // case 1: anual
    // case 2: semestral
    // case 4: trimestral
    // case 8: mensal


    /**
     * INDEX } Retorna listagem de todos as faturaas
     * 
     * @param false 
     * @return string
     */
    public function index() : string {
        
        $faturaModel = new FaturaModel();

        // Fatura fechada
        $faturaModel->select('fatura.*,cliente.id_cliente,cliente.cli_nome');
        $faturaModel->join('cliente','cliente.id_cliente = fatura.id_cliente');
        $faturaModel->where('fat_status!=','1');
        $faturaModel->orderBy('id_fatura','DESC');
        $faturaModelFechada = $faturaModel->paginate(10);
        $faturaModelPager  = $faturaModel->pager;
        $faturaModel->resetQuery();
        
        // Fatura aberta
        $faturaModel->resetQuery();
        $faturaModel->select('fatura.*,cliente.id_cliente,cliente.cli_nome');
        $faturaModel->join('cliente','cliente.id_cliente = fatura.id_cliente');
        $faturaModel->orderBy('id_fatura','DESC');
        $faturaModel->where('fat_status=','1');
        $faturaModelAberta = $faturaModel->findAll();
        $faturaModel->resetQuery();
        
        // Forma de pagamento
        $faturaFormapgtoModel = new FaturaFormapgtoModel();
        $dadosFaturaFormapgto = $faturaFormapgtoModel->findAll();

        // NFe
        $contabilModel = new ContabilModel();
        $contabilModel->select('id_contabil_s,id_fatura,con_status');
        $dadosNfe = $contabilModel->findAll();
             
        // fatura paga hoje
        $faturaModel->resetQuery();
        $faturaModel->select('fatura.*,cliente.id_cliente,cliente.cli_nome');
        $faturaModel->join('cliente','cliente.id_cliente = fatura.id_cliente');
        $faturaModel->where('DATE(fat_pagamento)',date('Y-m-d'));
        $faturaModelPaga = $faturaModel->findAll();

        // Ajusta NFE às Faturas
        $dadosFaturaAberta = [];
        foreach($faturaModelAberta as $aberta):
            // encontra fatura.id_fatura na array $Nfe[][id_fatura]
            $found_column = array_column($dadosNfe, 'id_fatura');
            $found_key = array_search($aberta['id_fatura'], $found_column);
            if($found_key):
                $aberta['id_contabil_s']    = $dadosNfe[$found_key]['id_contabil_s'];
                $aberta['con_status']       = $dadosNfe[$found_key]['con_status'];
            else:
                $aberta['id_contabil_s']    = NULL;
                $aberta['con_status']       = NULL;
            endif;
            $dadosFaturaAberta[] = $aberta;
        endforeach;
        $dadosFaturaFechada = [];
        foreach($faturaModelFechada as $fechada):
            // encontra fatura.id_fatura na array $Nfe[][id_fatura]
            $found_column = array_column($dadosNfe, 'id_fatura');
            $found_key = array_search($fechada['id_fatura'], $found_column);
            if($found_key):
                $fechada['id_contabil_s']   = $dadosNfe[$found_key]['id_contabil_s'];
                $fechada['con_status']      = $dadosNfe[$found_key]['con_status'];
            else:
                $fechada['id_contabil_s']   = NULL;
                $fechada['con_status']      = NULL;
            endif;
            $dadosFaturaFechada[] = $fechada;
        endforeach;
        $dadosFaturaPaga = [];
        foreach($faturaModelPaga as $paga):
            // encontra fatura.id_fatura na array $Nfe[][id_fatura]
            $found_column = array_column($dadosNfe, 'id_fatura');
            $found_key = array_search($paga['id_fatura'], $found_column);
            if($found_key):
                $paga['id_contabil_s']   = $dadosNfe[$found_key]['id_contabil_s'];
                $paga['con_status']      = $dadosNfe[$found_key]['con_status'];
            else:
                $paga['id_contabil_s']   = NULL;
                $paga['con_status']      = NULL;
            endif;
            $dadosFaturaPaga[] = $paga;
        endforeach;

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          => 'Faturas | Página principal',
            'listagemFaturaAberta'  => $dadosFaturaAberta,
            'listagemFaturas'       => $dadosFaturaFechada,
            'listagemFaturaPaga'    => $dadosFaturaPaga,
            'pager'                 => $faturaModelPager,
            'dadosFaturaFormapgto'  => $dadosFaturaFormapgto,
        ];
        return view('admin/fatura/fatura-index', $dados);
    }



    /**
     * CADASTRA} Cadastra uma nova fatura
     * 
     * @param false
     * @return ? array e string
     */
    public function cadastra($id_cliente) {

        // trata uri_id
        if(!is_numeric($id_cliente)):
            $id_cliente = NULL;
        endif;

        // listar todos os clientes
        $clienteModel = new ClienteModel();
        $clienteModel->select('id_cliente,cli_nome');
        $dadosCliente = $clienteModel->findAll();
        $cliente = [];
        $cliente[' '] = 'Selecione o cliente';
        foreach($dadosCliente as $c):
            $cliente[$c['id_cliente']] = $c['cli_nome'];
        endforeach;

        // listar formas de pagamento
        $faturaFormapgtoModel = new FaturaFormapgtoModel();
        $faturaFormapgtoModel->select('id_faturaformapgto,fatfor_nome');
        $dadosFaturaFormapgto = $faturaFormapgtoModel->findAll();
        $formapgto = [];
        $formapgto[' '] = 'Selecione a forma de pgto';
        foreach($dadosFaturaFormapgto as $f):
            $formapgto[$f['id_faturaformapgto']] = $f['fatfor_nome'];
        endforeach;

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  => 'Faturas | Cadastre um novo fatura',
            'cliente'       => $cliente,
            'formapgto'     => $formapgto,
            'id_cliente'    => $id_cliente,
        ];

        // constroi pagina
        return view('admin/fatura/fatura-cadastra', $dados);
    }



    /**
     * CADASTRAR} EXECUTA O ATO DO CADASTRO DA FATURA
     * 
     * @param array
     * @return ? array e string
     */
    public function cadastrar() {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // se veio através de outro método
            return redirect()->to('/fatura');
        }

        // cria regras de formulario
        $rules = [
            'input_cliente' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Selecione um cliente.',
                ],
            ],
            'input_descricao' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Insira uma descrição.',
                ],
            ],
            'input_valor' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  => 'Insira um valor.',
                ],
            ],
            'input_data' => [
                'rules' => 'required|valid_date[Y-m-d H:i:s]',
                'errors'    => [
                    'required'      => 'Insira uma data.',
                    'valid_date'    => 'Insira uma data.',
                ],
            ],
            'input_vencimento' => [
                'rules' => 'required|valid_date[Y-m-d H:i:s]',
                'errors'    => [
                    'required'      => 'Insira uma data.',
                    'valid_date'    => 'Insira uma data.',
                ],
            ],
            'input_nome' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  => 'Insira uma forma de pagamento.',
                ],
            ],
            'input_status' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  => 'Insira o status.',
                ],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)){

            // recarrega a página
            return redirect()->back()->withInput();

        // Validação executou com sucesso
        }else{

            // agrupa os dados
            $formulario = $this->request->getPost();
            $dados = [
                'id_cliente'        => $formulario['input_cliente'],
                'fat_descricao'     => $formulario['input_descricao'],
                'fat_valor'         => $formulario['input_valor'],
                'fat_data'          => $this->sanitize_data($formulario['input_data']),
                'fat_vencimento'    => $this->sanitize_data($formulario['input_vencimento']),
                'fat_pagamento'     => $this->sanitize_data($formulario['input_pagamento']),
                'fatfor_nome'       => $formulario['input_nome'],
                'fat_status'        => $formulario['input_status'],
            ];

            // insere na base de dados
            $faturaModel = new FaturaModel();

            // se insere na base : apresentou erro
            if(!$faturaModel->save($dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro No Cadastrado do Fatura.');
                return redirect()->back()->withInput();

            //  senao insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Fatura Cadastrado com Sucesso.');
                return redirect()->to('/cliente/painel/'.$dados['id_cliente'].'#clienteFatura');
            endif;
        }
    
    }



    /**
     * EDITA} Mostra as informações do fatura para edição
     * 
     * @param int $id_fatura
     * @return ? array e string
     */
    public function edita(int $id_fatura) : string {

        // informacoes da fatura
        $faturaModel = new FaturaModel();
        $dadosFatura = $faturaModel->find($id_fatura);

        // formas de pagamento
        $faturaFormapgtoModel = new FaturaFormapgtoModel();
        $dadosFaturaFormapgto = $faturaFormapgtoModel->findAll();
        $Formapgto = [];
        foreach($dadosFaturaFormapgto as $forma):
            $Formapgto[$forma['id_faturaformapgto']] = $forma['fatfor_nome'];
        endforeach;

        // Informações do cliente
        $clienteModel = new ClienteModel();
        $clienteModel->select('id_cliente,cli_nome,cli_cpfcnpj');
        $clienteModel->where('id_cliente',$dadosFatura['id_cliente']);
        $dadosClienteModel = $clienteModel->first();

        // boleto bancário
        $faturaFormapgtoBoletoModel = new FaturaFormapgtoBoletoModel();
        $faturaFormapgtoBoletoModel->where('id_fatura',$id_fatura);
        $dadosBoleto = $faturaFormapgtoBoletoModel->findAll();

        // Resultado na página
        $dados = [
            'TituloPagina'      => 'Faturas | Editar fatura',
            'fatura'            => $dadosFatura,
            'formapgto'         => $Formapgto,
            'cliente'           => $dadosClienteModel,
            'boleto'            => $dadosBoleto,
        ];
        return view('admin/fatura/fatura-edita', $dados);
    }



    /**
     * EDITAR} DESENVOLVE A AÇÃO EDITAR FATURA
     * 
     * @param int $id_fatura
     * @return ? array e string
     */
    public function editar(int $id_fatura) {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // redireciona se outro metodo
            return redirect()->to('/fatura');
        }

        // cria regras de formulario
        $rules = [
            'input_cliente' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Selecione um cliente.',
                ],
            ],
            'input_descricao' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Insira uma descrição.',
                ],
            ],
            'input_valor' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  => 'Insira um valor.',
                ],
            ],
            'input_data' => [
                'rules' => 'required|valid_date[Y-m-d H:i:s]',
                'errors'    => [
                    'required'      => 'Insira uma data.',
                    'valid_date'    => 'Insira uma data.',
                ],
            ],
            'input_vencimento' => [
                'rules' => 'required|valid_date[Y-m-d H:i:s]',
                'errors'    => [
                    'required'      => 'Insira uma data.',
                    'valid_date'    => 'Insira uma data.',
                ],
            ],
            'input_nome' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  => 'Insira uma forma de pagamento.',
                ],
            ],
            'input_status' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  => 'Insira o status.',
                ],
            ],
        ];

        // se Validação apresentou erro
        if(!$this->validate($rules)){

            // redireciona para edita (routes)
            return redirect()->back()->withInput();

        // senao Validação executou com sucesso
        }else{

            // recebe os dados
            $formulario = $this->request->getPost();

            // encapsula dados
            $dados = [
                'fat_descricao'     => $formulario['input_descricao'],
                'fat_valor'         => $formulario['input_valor'],
                'fat_data'          => $this->sanitize_data($formulario['input_data']),
                'fat_vencimento'    => $this->sanitize_data($formulario['input_vencimento']),
                'fat_pagamento'     => $this->sanitize_data($formulario['input_pagamento']),
                'fatfor_nome'       => $formulario['input_nome'],
                'fat_status'        => $formulario['input_status'],
                'deleted_at'        => $this->sanitize_data($formulario['input_status']),
            ];

            // Atualiza na base de dados
            $faturaModel = new FaturaModel();

            // se Insere na base : apresentou erro
            if(!$faturaModel->update($formulario['id_fatura'], $dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                return redirect()->back()->withInput();

            // senao Insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Fatura Atualizado com sucesso.');
                return redirect()->to('/cliente/painel/'.$formulario['input_cliente'].'#clienteFatura');
            endif;
        }

    }



    /**
     * DELETA} Exclui fatura do sistema. Soft delet está ativo
     * 
     * @param int $id_fatura
     * @return object
     */
    public function exclui( int $id_fatura) : object {

        // Exclui fatura        
        $faturaModel = new FaturaModel();

        // excluir fatura retornou erro
        if(!$faturaModel->delete(['id' => $id_fatura])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir o fatura.');
            return redirect()->back();

        // excluiu fatura com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Fatura excluído com sucesso.');
            return redirect()->back();

        endif;
    }



    /**
     * LEMBRETE } Envia notificacao de fatura aberta, para o email do cliente
     * 
     * @param post array $dados  
     * @return ??
     */
    public function lembrete() {

        helper('funcoes');

        // recebe id das faturas
        $dados = $this->request->getPost();
        $relatorio = 'Lembrete encaminhado para: ';

        // se post sem informações, volta para faturas
        if(empty($dados['input_envia'])):
            session()->setFlashdata('msgType','warning');
            session()->setFlashdata('msg','Selecione uma fatura para lembrar.');
            return redirect()->back();
        endif;

        // organiza informações
        $faturaModel = new FaturaModel();
        $faturaModel->select('fatura.*,cliente.id_cliente,cliente.cli_nome,cliente.cli_email,cliente.cli_senha');
        $faturaModel->whereIn('id_fatura', $dados['input_envia']);
        $faturaModel->join('cliente','cliente.id_cliente = fatura.id_cliente');
        $dadosFaturaModel = $faturaModel->findAll();

        // incia serviço de email
        $email = \Config\Services::email();
        $config = [
            'protocol'  => 'mail',
            'SMTPHost'  => 'mail.nucleodenegociosweb.com.br',
            'SMTPUser'  => 'adm@nucleodenegociosweb.com.br',
            'SMTPPass'  => 'lucr4tivo!',
            'SMTPPort'  => '587',
            'wordWrap'  => true,
            'mailType'  => 'html',
        ];

        // enquanto houver lembrete, gera lembrete de cobrança
        foreach($dadosFaturaModel as $fatura):

            // inicia o serviço de email do sistema
            $email->clear(true);
            $email->initialize($config);
            $email->setFrom('adm@nucleodenegociosweb.com.br', 'Núcleo de Negócios WEB . Carol');
            $email->setTo($fatura['cli_email']);
            $email->setSubject('[Nova Fatura] Um novo ciclo foi gerado');
            $email->setAltMessage('Um novo ciclo de pagamento foi inciado e já é possível acessar sua fatura através do site www.nucleodenegociosweb.com.br/loginCliente ou solicite por whatsapp/e-mail. \n\n Equipe Núcleo de Negócios WEB');

            // Valores e descontos da Fatura
            $fatura['fat_valor'] = str_replace('.','',$fatura['fat_valor']);
            $fatura['fat_valor'] = str_replace(',','.',$fatura['fat_valor']);
            $fatura['fat_desconto'] = $fatura['fat_valor'] * 0.10;
            $fatura['fat_total'] = $fatura['fat_valor'] - $fatura['fat_desconto'];
            $fatura['fat_valor'] = number_format($fatura['fat_valor'],2,',','.');
            $fatura['fat_desconto'] = number_format($fatura['fat_desconto'],2,',','.');
            $fatura['fat_total'] = number_format($fatura['fat_total'],2,',','.');

            // senha codificada para url
            $fatura['cli_senha'] = urlencode(urilencode($fatura['cli_senha']));
            
            // Formas de pagamento da fatura
            $faturaFormapgto = new FaturaFormapgtoModel();
            $dadosFaturaFormapgto = $faturaFormapgto->where('id_faturaformapgto',$fatura['fatfor_nome'])->first();
            $fatura['faturaformapgto']['fatfor_nome'] = $dadosFaturaFormapgto['fatfor_nome'];
            
            // verifica existe boleto gerado
            if($dadosFaturaFormapgto['fatfor_nome'] == "Boleto Bancário"):
                $faturaFormapgtoBoletoModel = new FaturaFormapgtoBoletoModel();
                $faturaFormapgtoBoletoModel->where('id_fatura',$fatura['id_fatura']);
                $dadosBoletoModel = $faturaFormapgtoBoletoModel->first();

                if(!$dadosBoletoModel):
                    $fatura['faturaformapgto']['fatfor_detalhamento'] = '<span style="color:red;">Algo ocorreu ao gerar o link para o Boleto. Entre em contato conosco.</span>';
                else:
                    $fatura['faturaformapgto']['fatfor_detalhamento'] = '<a href="'.$dadosBoletoModel['forbol_link'].'" target="_blank" style="font-size:20px;"><b>Clique Aqui Para Acessar Seu Boleto</b></a> <br /><br />Linha para pagamento do boleto: <br /><small>'.$dadosBoletoModel['forbol_barcodenumber'].'</small>';
                endif;
            else:
                $fatura['faturaformapgto']['fatfor_detalhamento'] = $dadosFaturaFormapgto['fatfor_detalhamento'];
            endif;
            

            // PREVINE ENVIO DE EMAIL EM LOCALHOST
                // 1 = envia email
                // 2 = gera layout do email na tela, nao envia email
                // 3 = imprime na tela, não envia email nem layout
            if($_SERVER['CI_ENVIRONMENT'] == 'development'):
                $flag = 2;
                // $flag = 3;
            else:
                $flag = 1;
            endif;

            // se 1 : envia email
            if($flag == 1){
                // define template para o email
                $template = view('admin/emailer/create-invoice', $fatura);
                $email->setMessage($template);

                // gera relatorio
                $relatorio .= '<br/>' . $fatura['id_fatura'] . ' . ' . $fatura['cli_nome'];

                // envia mensagem
                if (! $email->send()):
                    // se apresentou erro, add ao relatorio.
                    $relatorio .= '<br />' . $email->printDebugger() . '<hr>';
                endif;
                
                sleep(3);

            // se 2 : retorna view na tela
            }elseif($flag == 2){
                return view('admin/emailer/create-invoice', $fatura);

            // se 3 : retorna variaveis na tela
            }else{

                // gera relatorio
                $relatorio .= '<br/>' . $fatura['id_fatura'] . ' . ' . $fatura['cli_nome'];

                // mostra variaveis
                echo '<hr>';
                echo '<p>var_dump fatura</p>';
                var_dump($fatura);
                echo '<hr>';
                echo '<p>var_dump retorno</p>';
                var_dump($relatorio);
                die;

            }
        endforeach;
    
        // conclui
        session()->setFlashdata('msgType','success');
        session()->setFlashdata('msg',$relatorio);
        return redirect()->to('/fatura');

    }



    /**
     * PAGAMENTO CONFIRMA} Encaminha email confirmação de pagamento ao responsável pela fatura
     * 
     * @param int $id_fatura
     * @return string ??
     */
    public function pagamentoConfirma($fid) {
        $fid = trim(strip_tags($fid));

        //pega informações id_fatura = $e
        $faturaModel = new FaturaModel();
        $faturaModel->select('fatura.*,cliente.cli_nome,cliente.cli_email,cliente.cli_senha,fatura_formapgto.fatfor_nome');
        $faturaModel->where('id_fatura',$fid);
        $faturaModel->join('cliente','cliente.id_cliente=fatura.id_cliente');
        $faturaModel->join('fatura_formapgto','fatura_formapgto.id_faturaformapgto=fatura.fatfor_nome');
        $data = $faturaModel->first();

        $data["fat_data"] = new DateTime($data["fat_data"]);
        $data["fat_data"] = $data["fat_data"]->format('d/m/Y');
        $data["fat_vencimento"] = new DateTime($data["fat_vencimento"]);
        $data["fat_vencimento"] = $data["fat_vencimento"]->format('d/m/Y');
        $data["fat_pagamento"] = new DateTime($data["fat_pagamento"]);
        $data["fat_pagamento"] = $data["fat_pagamento"]->format('d/m/Y');

        // incia serviço de email
        $email = \Config\Services::email();
        $config = [
            'protocol'  => 'mail',
            'SMTPHost'  => 'mail.nucleodenegociosweb.com.br',
            'SMTPUser'  => 'adm@nucleodenegociosweb.com.br',
            'SMTPPass'  => 'lucr4tivo!',
            'SMTPPort'  => '587',
            'wordWrap'  => true,
            'mailType'  => 'html',
        ];

        // inicia o serviço de email do sistema
        $email->clear(true);
        $email->initialize($config);
        $email->setFrom('adm@nucleodenegociosweb.com.br', 'Núcleo de Negócios WEB . Carol');
        $email->setTo(array($data['cli_email']));
        $email->setSubject('[Fatura Paga] Pagamento confirmado.');
        $email->setAltMessage('O pagamento da fatura foi identificado. É possível acessar através do site www.nucleodenegociosweb.com.br/cliente ou solicite por whatsapp/e-mail. \n\n Equipe Núcleo de Negócios WEB');

        // PREVINE ENVIO DE EMAIL EM LOCALHOST
        // 1 = envia email
        // 2 = gera layout do email na tela, nao envia email
        // 3 = imprime na tela, não envia email nem layout
        if($_SERVER['CI_ENVIRONMENT'] == 'development'):
            $flag = 2;
            // $flag = 3;
        else:
            $flag = 1;
        endif;

        // se 1 : envia email
        if($flag == 1){
            // define template para o email
            $template = view('admin/emailer/pagamento-confirma', $data);
            $email->setMessage($template);

            // envia mensagem
            if (! $email->send()):
                // se apresentou erro, retorna e informa
                session()->setFlashdata('msgType','danger');
                session()->setFlashdata('msg','Email não enviado.');
                return redirect()->back();
            endif;
            
            // conclui
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Mensagem de Confirmação Enviada ao Cliente.');
            return redirect()->to('cliente/painel/'.$data['id_cliente']);

        // se 2 : retorna view na tela
        }elseif($flag == 2){
            return view('admin/emailer/pagamento-confirma', $data);

        // se 3 : retorna variaveis na tela
        }else{

            // mostra variaveis
            echo '<hr>';
            echo '<p>var_dump fatura</p>';
            var_dump($data);
            echo '<hr>';
            die;

        }

   }



    // /**
    //  * APROVA PAGAMENTO} Botão aprovar pagamento, confirma na data
    //  * 
    //  * @param int $id_fatura
    //  * @return string ??
    //  */
    public function aprovarpagamento($id_fatura){

        //id fatura
        $uid = trim(strip_tags($id_fatura));

        //define dia do pagamento
        $hoje = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));

        //encapsula novas informacoes
        $update_data = array(
            'fat_pagamento' =>  $hoje->format('Y-m-d H:i:s'),
            'fat_status'    =>  0, //pago
        );

        //altera base de dados para pago na data
        $faturaModel = new FaturaModel();
        $sucesso = $faturaModel->update($uid,$update_data);
        
        //identifica o pedido
        $faturaModel->resetQuery();
        $faturaModel->where('id_fatura',$uid);
        $faturapaga = $faturaModel->first();
        $id_clientepedido = $faturapaga['id_pedido'];
    
        //se for parte de um pedido
        if($id_clientepedido!=NULL):

            //carrega dados do produto
            $clientePedidoModel = new ClientePedidoModel();
            $clientePedidoModel->where('id_clientepedido',$id_clientepedido);
            $clientepedido = $clientePedidoModel->first();

            //adiciona periodo na data de proximo pagamento do produto
            $novociclo = date_create($clientepedido['cliped_pagamentoproximo']);
            switch($clientepedido['cliped_pagamentoperiodo']):
            case 1: //anual
                date_modify($novociclo, "+1 year");
            break;
            case 2: //semestral
                date_modify($novociclo, "+6 month");
            break;
            case 4: //trimestral
                date_modify($novociclo, "+3 month");
            break;
            case 8: //mensal dinheiro
                date_modify($novociclo, "+1 month");
            break;
            endswitch;

            //ajuste para o ciclo de cobranca
            $novadatapagamento = date_format($novociclo, 'Y-m-d');

            //atualiza data próximo vencimento no clienteproduto
            $update_produto = array(
                'cliped_pagamentoproximo' => $novadatapagamento,
            );
            $clientePedidoModel->resetQuery();
            $clientePedidoModel->where('id_clientepedido', $id_clientepedido);
            $clientePedidoModel->set($update_produto);
            $sucessoproximovencimento = $clientePedidoModel->update();
        else:
            $sucessoproximovencimento = TRUE;
        endif;

        // lança valor automaticamente na base faturamento
        $faturamentoModel = new FaturamentoModel();
        $faturamentoModel->insert([
            'id_cliente'    => $faturapaga['id_cliente'],
            'fatcat_nome'   => 'Outros',
            'fatfor_nome'   => $faturapaga['fatfor_nome'],
            'fat_descricao' => $faturapaga['fat_descricao'],
            'fat_data'      => $faturapaga['fat_pagamento'],
            'fat_valor'     => $faturapaga['fat_valor'],
        ]);
        
        //retorna status
        if(($sucesso == TRUE)&&($sucessoproximovencimento == TRUE)):
            // conclui com sucesso
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Aprovado com sucesso e período do pedido renovado.');
            return redirect()->back();
        else:
            // conclui com erro
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Houve um erro na aprovação ou na atualização no período do pedido.');
            return redirect()->back();
        endif;
    }



    /**
     * SANITIZE} Verifica data se veio em branco
     * 
     * @param string $data
     * @return string
     */
    public function sanitize_data($data) {

        // se :parâmetros inválidos
        if( $data=="0000-00-00 00:00:00" || $data=="____-__-__ __:__:__" || $data=="" ):
            
            // erro validacao
            return NULL;

        // senão : parametros válidos
        else:

            // acerto validacao
            return $data;

        endif;

    }



    /**
     * BOLETO ASAAS} Cria um novo boleto assas
     * 
     * @param string $id_fatura
     * @return string
     */
    public function boletar(int $id_fatura){

        // id fatura
        $faturaModel = new FaturaModel();
        $faturaModel->where('id_fatura',$id_fatura);
        $dadosFatura = $faturaModel->first();

        // id cliente
        $clienteModel = new ClienteModel();
        $clienteModel->where('id_cliente',$dadosFatura['id_cliente']);
        $dadosCliente = $clienteModel->first();

        $dadosFatura['fat_valor'] = str_replace('.','',$dadosFatura['fat_valor']);
        $dadosFatura['fat_valor'] = str_replace(',','.',$dadosFatura['fat_valor']);

        $dadosFatura['fat_vencimento'] = new DateTime($dadosFatura['fat_vencimento']);
        $dadosFatura['fat_vencimento']->format('Y-m-d');

        // o boleto
        $boleto = [
            'customer'      => $dadosCliente['id_asaas'],
            "billingType"   => "BOLETO",
            "dueDate"       => $dadosFatura['fat_vencimento']->format('Y-m-d'),
            "value"         => $dadosFatura['fat_valor'],
            "description"   => $dadosFatura['fat_descricao'],
            "externalReference" => $id_fatura,
            "invoiceNumber"     => $id_fatura,
            "discount"  =>  [
                "type"              => "PERCENTAGE",
                "value"             => 10,
                "dueDateLimitDays"  => 0
            ],
            "fine"  => [
                "value" => 2
            ],
            "interest"  => [
                "value" => 1
            ],
            "postalService" => false
        ];
        
        // Gera boleto
        $asaas = new Asaas();
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, "https://private-anon-a073adec39-asaasv3.apiary-proxy.com/api/v3/payments");
        // curl_setopt($ch, CURLOPT_URL, "https://private-anon-6a62c7752e-asaasv3.apiary-proxy.com/api/v3/payments");
        curl_setopt($ch, CURLOPT_URL, "https://www.asaas.com/api/v3/payments");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($boleto));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        "Content-Type: application/json",
        "access_token: " . $asaas->chave(),
        ));
        $response = curl_exec($ch);
        curl_close($ch);
        $boleto = json_decode($response, true);

        // previne erro
        if(isset($boleto['errors'])):
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg',$boleto['errors'][0]['description']);
            return redirect()->back();
        endif;

        // salva retorno do boleto na base de dados
        $boletoGerado = [
            'id_fatura'                 => $id_fatura,
            'forbol_codigo'             => $boleto['id'],
            'forbol_duedate'            => $dadosFatura['fat_vencimento']->format('Y-m-d'),
            'forbol_checkouturl'        => $boleto['invoiceUrl'],
            'forbol_link'               => $boleto['bankSlipUrl'],
            'forbol_installmentlink'    => $boleto['bankSlipUrl'],
            'forbol_paynumber'          => $boleto['invoiceNumber'],
            'forbol_billetdetails'      => $response,
            'forbol_barcodenumber'      => '',
            'forbol_paymenttoken'       => $boleto['nossoNumero'],
        ];
        $faturaFormapgtoBoletoModel = new FaturaFormapgtoBoletoModel();  
        $atualiza = $faturaFormapgtoBoletoModel->insert($boletoGerado);

        // solicitar codigo de barra
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://private-anon-a073adec39-asaasv3.apiary-proxy.com/api/v3/payments/".$boleto['id']."/identificationField");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        "Content-Type: application/json",
        "access_token: " . $asaas->chave(),
        ));
        $response = curl_exec($ch);
        curl_close($ch);
        $barras = json_decode($response,true);

        // previne erro
        if(isset($barras['errors'])):
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','O boleto foi criado, mas:<br>' . $barras['errors'][0]['description']);
            return redirect()->back();
        endif;

        // salva cod de barras na base de dados
        $faturaFormapgtoBoletoModel->resetQuery();
        $faturaFormapgtoBoletoModel->set('forbol_barcodenumber', $barras['barCode']);
        $faturaFormapgtoBoletoModel->where('forbol_codigo', $boleto['id']);
        $atualiza = $faturaFormapgtoBoletoModel->update();

        // retorna
        session()->setFlashdata('msgType','success');
        session()->setFlashdata('msg','O boleto foi criado.');
        return redirect()->back();
    }



}