<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\FaturaFormapgtoModel;

class FaturaFormapgto extends BaseController
{



    /**
     * INDEX} Listagem com todas as categorias 
     * 
     * @param false
     * @return string 
     */
    public function index() : string {

        $faturaFormapgtoModel = new FaturaFormapgtoModel();
        $dadosFaturaFormapgto = $faturaFormapgtoModel->findAll();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Formas de Pamamento | Listagem',
            'listagem'          => $dadosFaturaFormapgto,
            
        ];

        return view('admin/fatura/faturaFormapgto-index', $dados);
    }



    /**
     * CADASTRA} Cadastra uma nova fatura
     * 
     * @param false
     * @return string
     */
    public function cadastra() : string {

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Formas de Pamamento | Cadastrar Forma de pagamento',
            
        ];

        return view('admin/fatura/faturaFormapgto-cadastra', $dados);
    }



    /**
     * CADASTRAR} EFETUA A ACAO DE CADASTRO
     * 
     * @param array
     * @return object
     */
    public function cadastrar() : object {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // se veio através de outro método
            return redirect()->to('/fatura');
        }

        // cria regras de formulario
        $rules = [
            'input_nome' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Selecione um cliente.',
                ],
            ],
            'input_detalhamento' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Insira uma descrição.',
                ],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)){

            // recarrega a página
            return redirect()->back()->withInput();

        // Validação executou com sucesso
        }else{

            // agrupa os dados
            $formulario = $this->request->getPost();
            $dados = [
                'fatfor_nome'           => $formulario['input_nome'],
                'fatfor_detalhamento'   => $formulario['input_detalhamento'],
            ];

            // insere na base de dados
            $faturaFormapgtoModel = new FaturaFormapgtoModel();

            // se insere na base : apresentou erro
            if(!$faturaFormapgtoModel->save($dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro ao cadastrar a forma de pagamento.');
                return redirect()->back()->withInput();

            //  senao insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Forma de pagamento cadastrada com Sucesso.');
                return redirect()->to('/fatura');
            endif;
        }
    
    }



    /**
     * EDITA} Mostra as informações da forma de pagamento para edição
     * 
     * @param int $id_faturaformapgto
     * @return ? string
     */
    public function edita(int $id_faturaformapgto) : string {

        // retorna os dados da forma de pagamento cadastrada
        $faturaFormapgtoModel = new FaturaFormapgtoModel();
        $dadosFaturaFormapgto = $faturaFormapgtoModel->find($id_faturaformapgto);

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Forma de pagamento | Editar forma de pagamento',
            'faturaFormapgto'            => $dadosFaturaFormapgto,
        ];

        return view('admin/fatura/faturaFormapgto-edita', $dados);
    }



    /**
     * EDITAR} DESENVOLVE A AÇÃO EDITAR FORMA DE PGTO
     * 
     * @param int $id_faturaformapgto
     * @return ? object
     */
    public function editar(int $id_faturaformapgto) : object {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // redireciona se outro metodo
            return redirect()->to('/fatura');
        }

        // cria regras de formulario
        $rules = [
            'input_nome' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Selecione um cliente.',
                ],
            ],
            'input_detalhamento' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Insira uma descrição.',
                ],
            ],
        ];

        // se Validação apresentou erro
        if(!$this->validate($rules)){

            // redireciona para edita (routes)
            return redirect()->back()->withInput();

        // senao Validação executou com sucesso
        }else{

            // recebe os dados
            $formulario = $this->request->getPost();

            // encapsula dados
            $dados = [
                'fatfor_nome'           => $formulario['input_nome'],
                'fatfor_detalhamento'   => $formulario['input_detalhamento'],
            ];

            // Atualiza na base de dados
            $faturaFormapgtoModel = new FaturaFormapgtoModel();
            $insere = $faturaFormapgtoModel->update($formulario['id_faturaformapgto'], $dados);

            // se Insere na base : apresentou erro
            if(!$insere):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                return redirect()->back()->withInput();

            // senao Insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Forma de pagamento atualizado com sucesso.');
                return redirect()->to('/faturaFormapgto');

            endif;
        }

    }



    /**
     * DELETA} Exclui um fatura do sistema. Soft delet está ativo
     * 
     * @param int $id_faturaformapgto
     * @return object
     */
    public function exclui( int $id_faturaformapgto) : object {

        // Exclui fatura        
        $faturaFormapgtoModel = new FaturaFormapgtoModel();

        // excluir fatura retornou erro
        if(!$faturaFormapgtoModel->delete(['id_faturaformapgto' => $id_faturaformapgto])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir a forma de pagamento.');
            return redirect()->back();

        // excluiu fatura com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Forma de pagamento excluído com sucesso.');
            return redirect()->back();

        endif;

    }
    

}