<?php

namespace App\Controllers;

use App\Models\FaturaFormapgtoModel;
use App\Models\FaturamentoCategoriaModel;
use App\Models\FaturamentoModel;
use DateTime;

class Faturamento extends BaseController {



	/**
     * INDEX } Retorna listagem de todo o faturamento
     * 
     * @param false 
     * @return string
     */
	public function index(){
        
		$condicao = $this->request->getGet('case');
        $condicaocaso = strlen($condicao); //conta o total de numeros

        //se escreverem algo alem de numero
        if(!intval($condicao)):
            $parada = new DateTime('now');
            $condicao = $parada->format('Y');
        endif;

        //se vier sem data
        if($condicaocaso==0):
            $parada = new DateTime('now');
            $condicao = $parada->format('mY');
        endif;

        //se vier apenas ano
        if($condicaocaso==4):
            $anohoje = substr($condicao,0,4);//quatro sucessivos
            $dataAtual['diahora'] = new DateTime($anohoje.'-01-01');
            //o que buscar na base de dados
			$faturamentoModel = new FaturamentoModel();
            $faturamentoModel->where('YEAR(fat_data)', $dataAtual['diahora']->format('Y'));
            $faturamentoModel->orderBy('fat_data', 'DESC');
            $listagem = $faturamentoModel->findAll();
        //se vier mes e ano
        elseif(($condicaocaso==0)||($condicaocaso==6)):
            $meshoje = substr($condicao,0,2);//dois primeiros
            $anohoje = substr($condicao,2,5);//quatro sucessivos
            $dataAtual['diahora'] = new DateTime($anohoje.'-'.$meshoje.'-01');
            //o que buscar na base de dados
            $faturamentoModel = new FaturamentoModel();
            $faturamentoModel->where('MONTH(fat_data)', $dataAtual['diahora']->format('m'));
            $faturamentoModel->where('YEAR(fat_data)', $dataAtual['diahora']->format('Y'));
            $faturamentoModel->orderBy('fat_data', 'DESC');
            $listagem = $faturamentoModel->findAll();
        endif;
        $dataAtual['string'] = strtotime(date_format($dataAtual['diahora'],'Y-m-d H:i:s'));
        $dataAtual['dia'] =  date_format($dataAtual['diahora'],'d');
        $dataAtual['mes'] =  date_format($dataAtual['diahora'],'m');
        $dataAtual['mesextenso'] =  date_format($dataAtual['diahora'],'M');
        $dataAtual['ano'] =  date_format($dataAtual['diahora'],'Y');
        
		//listar faturamentos
		if($listagem):
		foreach($listagem as $p):
			//data bonita
			$databonita = date_create($p['fat_data']);
			$databonita =  date_format($databonita,'d/m/Y');
			$inds[] = array(
				'id_faturamento'	=> $p['id_faturamento'],
				'id_cliente'		=> $p['id_cliente'],
				'fatcat_nome'		=> $p['fatcat_nome'],
				'fatfor_nome'		=> $p['fatfor_nome'],
				'fat_descricao'		=> $p['fat_descricao'],
				'fat_data'			=> $databonita,
				'fat_valor'			=> $p['fat_valor'],
			);
		endforeach;
		else:
		$inds = array();
		endif;

        //listar categorias de fatura
		$faturamentoCategoriaModel = new FaturamentoCategoriaModel();
		$listagemCategoria = $faturamentoCategoriaModel->findAll();
		if($listagemCategoria):
		foreach($listagemCategoria as $c):
			$indsC[] = array(
				'id_faturamentocategoria'	=> $c['id_faturamentocategoria'],
				'fatcat_nome'				=> $c['fatcat_nome'],
			);
			$faturacategoria[$c['fatcat_nome']] = $c['fatcat_nome'];
		endforeach;
		else:
		$indsC = array();
		$faturacategoria = array();
		endif;
		
		//listar formas de pagamento
		$faturaFormapgtoModel = new FaturaFormapgtoModel();
		$FaturaFormaPgto = $faturaFormapgtoModel->findAll();
		if($FaturaFormaPgto):
		foreach($FaturaFormaPgto as $f):
			$indsF[] = array(
				'id_faturaformapgto'	=> $f['id_faturaformapgto'],
				'fatfor_nome'			=> $f['fatfor_nome'],
			);
			$faturaformaspgto[$f['fatfor_nome']] = $f['fatfor_nome'];
		endforeach;
		else:
		$indsF = array();
		endif;

		// define informacoes da pagina
        $dados = [
            'TituloPagina'          => 'Faturas | Página principal',
            'dataAtual'				=> $dataAtual,
			'listagem'				=> $inds,
			'listagemCategoria'		=> $indsC,
			'faturacategoria'		=> $faturacategoria,
			'listagemFormaPgto'		=> $indsF,
			'faturaformaspgto'		=> $faturaformaspgto,
        ];

        return view('admin/faturamento/faturamento-index', $dados);
	}



 	//-----------------------------------------------------------------[ FATURAMENTO]
	//
	//
	/**
     * CADASTRA} Cadastra novo faturamento
     * 
     * @param array $dados
     * @return string
     */
	public function cadastra(){

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // se veio através de outro método
            return redirect()->back();
        }

		//regras para o formulario
		$rules = [
			'fat_data' => [
				'rules' => 'required',
				'errors' =>	[
					'required' => 'Campo necessário',
				],

			],
			'fat_descricao' => [
				'rules' => 'required',
				'errors' =>	[
					'required' => 'Campo necessário',
				],

			],
			'fatfor_nome' => [
				'rules' => 'required',
				'errors' =>	[
					'required' => 'Campo necessário',
				],

			],
			'fatcat_nome' => [
				'rules' => 'required',
				'errors' =>	[
					'required' => 'Campo necessário',
				],

			],
			'fat_valor' => [
				'rules' => 'required',
				'errors' =>	[
					'required' => 'Campo necessário',
				],

			],
		];

		// Validação apresentou erro
		if(!$this->validate($rules)):

			// recarrega a página
			session()->setFlashdata('msgType','danger');
			session()->setFlashdata('msg','Verifique os erros no formulário.');
			return redirect()->back()->withInput();

		// Validação executou com sucesso
		else:
			
			// agrupa os dados
			$formulario = $this->request->getPost();
			$formulario['fat_data'] = DateTime::createFromFormat('d/m/Y',$formulario['fat_data']);
			
			//encapsula
			$dados = array(
				'fatcat_nome'		=>	$formulario['fatcat_nome'],
				'fatfor_nome'		=>	$formulario['fatfor_nome'],
				'fat_descricao'		=>	$formulario['fat_descricao'],
				'fat_valor'			=>	$formulario['fat_valor'],
				'fat_data'			=>	$formulario['fat_data']->format('Y-m-d H:i:s'),
			);
			
			//salva
			$faturamentoModel = new FaturamentoModel();
			$sucesso = $faturamentoModel->insert($dados);
			if($sucesso == TRUE):
				session()->setFlashdata('msgType','success');
				session()->setFlashdata('msg','Cadastro Realizado Com sucesso');
				return redirect()->to('faturamento');
			else:
				session()->setFlashdata('msgType','success');
				session()->setFlashdata('msg','Erro no cadastro');
				return redirect()->back();
			endif;
		endif;
	}



	/**
     * EDITA} Mostra página para ser editada
     * 
     * @param array $dados
     * @return string
     */
	public function edita($uid){

		$uid = strip_tags(trim($uid));

		$faturamentoModel = new FaturamentoModel();
		$faturamentoModel->where('id_faturamento', $uid);
		$dadosFaturamento = $faturamentoModel->first();

		$faturamentoCategoriaModel = new FaturamentoCategoriaModel();
		$dadosFaturamentoCategoria = $faturamentoCategoriaModel->findAll();
		$dadosFatCat = [];
		foreach($dadosFaturamentoCategoria as $fc):
			$dadosFatCat[$fc['fatcat_nome']] = $fc['fatcat_nome'];
		endforeach;

		$faturaFormapgtoModel = new FaturaFormapgtoModel();
		$dadosFaturaFormapgto = $faturaFormapgtoModel->findAll();
		$dadosFatFor = [];
		foreach($dadosFaturaFormapgto as $ff):
			$dadosFatFor[$ff['fatfor_nome']] = $ff['fatfor_nome'];
		endforeach;

		$dados = [
			'TituloPagina'	=> 'Faturamento | Editar entrada',
			'listagem'		=> $dadosFaturamento,
			'categoria'		=> $dadosFatCat,
			'formapgto'		=> $dadosFatFor,
		];

		return view('admin/faturamento/faturamento-edita', $dados);
	}



 	/**
     * EDITAR} Promove ação de edição
     * 
     * @param array $dados
     * @return string
     */
	public function editar(){

		// verifica se veio informação por post
		if ($this->request->getMethod() !== 'post') {
			// se veio através de outro método
			return redirect()->to('/faturamento');
		}

		// regras de validacao
		$rules = [
			'fat_descricao' =>	[
				'rules' => 'required',
				'errors' => [
					'required' => 'Campo necessário',
				],
			],
			'fat_valor' =>	[
				'rules' => 'required',
				'errors' => [
					'required' => 'Campo necessário',
				],
			],
			'fat_data' =>	[
				'rules' => 'required',
				'errors' => [
					'required' => 'Campo necessário',
				],
			],
		];

		// valida formulario
		if(!$this->validate($rules)):

			// recarrega a página
			return redirect()->back()->withInput();

		else:

			$formulario = $this->request->getPost();
            
			$uid = strip_tags(trim($formulario['id_faturamento']));

			$formulario['fat_data'] = new DateTime($formulario['fat_data']);
			$formulario['fat_data'] = $formulario['fat_data']->format('Y-m-d H:i:s');

			$dados = array(
				'fatcat_nome'	=>	$formulario['fatcat_nome'],
				'fatfor_nome'	=>	$formulario['fatfor_nome'],
                'fat_descricao'	=>	$formulario['fat_descricao'],
				'fat_data'	    =>	$formulario['fat_data'],
				'fat_valor'		=>	$formulario['fat_valor'],
			);

			$faturamentoModel = new FaturamentoModel();
			$faturamentoModel->set($dados);
			$faturamentoModel->where('id_faturamento',$uid);
			$sucesso = $faturamentoModel->update();

			//  se insere na base : apresentou erro
			if(!$sucesso):

				// recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro No Cadastrado do Fatura.');
                return redirect()->back()->withInput();

			 //  senao insere na base : executou com sucesso
            else:

                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Fatura Cadastrado com Sucesso.');
                return redirect()->to('/faturamento');
			endif;
		endif;
	}



    /**
     * DELETA} Exclui faturamento. Soft delet está ativo
     * 
     * @param int $id_faturamento
     * @return object
     */
    public function exclui( int $id_faturamento) : object {

        // Exclui fatura        
        $faturamentoModel = new FaturamentoModel();

        // excluir fatura retornou erro
        if(!$faturamentoModel->delete(['id_faturamento' => $id_faturamento])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir o fatura.');
            return redirect()->back();

        // excluiu fatura com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Fatura excluído com sucesso.');
            return redirect()->back();

        endif;
    }


}
