<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\FaturamentoCategoriaModel;

class FaturamentoCategoria extends BaseController
{



    /**
     * INDEX} Listagem com todas as categorias 
     * 
     * @param false
     * @return string
     */
    public function index() : string {

        $faturamentoCategoriaModel = new FaturamentoCategoriaModel();
        $dadosFaturamentoCategoria = $faturamentoCategoriaModel->findAll();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Categoria de Faturamento | Listagem',
            'listagem'          => $dadosFaturamentoCategoria,
            
        ];

        return view('admin/faturamento/faturamentoCategoria-index', $dados);
    }



    /**
     * CADASTRA} Cadastra uma nova fatura
     * 
     * @param false
     * @return string
     */
    public function cadastra() : string {

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Categorias de Faturamento | Cadastre uma categoria de faturamento',
            
        ];

        return view('admin/faturamento/faturamentoCategoria-cadastra', $dados);
    }



    /**
     * CADASTRAR} EFETUA A ACAO DE CADASTRO
     * 
     * @param array
     * @return object
     */
    public function cadastrar() : object {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // se veio através de outro método
            return redirect()->to('/fatura');
        }

        // cria regras de formulario
        $rules = [
            'input_nome' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Informe uma categoria.',
                ],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)){

            // recarrega a página
            return redirect()->back()->withInput();

        // Validação executou com sucesso
        }else{

            // agrupa os dados
            $formulario = $this->request->getPost();
            $dados = [
                'fatcat_nome'           => $formulario['input_nome'],
            ];

            // insere na base de dados
            $faturamentoCategoriaModel = new FaturamentoCategoriaModel();
			$sucesso = $faturamentoCategoriaModel->insert($dados);
            // se insere na base : apresentou erro
            if(!$sucesso):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Erro ao cadastrar a categoria de faturamento.');
                return redirect()->back()->withInput();

            //  senao insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Categoria de faturamento cadastrada com Sucesso.');
                return redirect()->to('/faturamentoCategoria');
            endif;
        }
    
    }



    /**
     * EDITA} Mostra as informações da categoria de faturamento para edição
     * 
     * @param int $id_faturamentocategoria
     * @return ? string
     */
    public function edita(int $id_faturamentocategoria) : string {

        // retorna os dados da categoria de faturamento cadastrada
        $faturamentoCategoriaModel = new FaturamentoCategoriaModel();
        $dadosFaturamentoCategoria = $faturamentoCategoriaModel->find($id_faturamentocategoria);

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Categoria de faturamento | Editar categoria de faturamento',
            'faturamentoCategoria'            => $dadosFaturamentoCategoria,
        ];

        return view('admin/faturamento/faturamentoCategoria-edita', $dados);
    }



    /**
     * EDITAR} DESENVOLVE A AÇÃO EDITAR FORMA DE PGTO
     * 
     * @param int $id_faturamentocategoria
     * @return ? object
     */
    public function editar(int $id_faturamentocategoria) : object {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // redireciona se outro metodo
            return redirect()->to('/fatura');
        }

        // cria regras de formulario
        $rules = [
            'input_nome' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Selecione um cliente.',
                ],
            ],
        ];

        // se Validação apresentou erro
        if(!$this->validate($rules)){

            // redireciona para edita (routes)
            return redirect()->back()->withInput();

        // senao Validação executou com sucesso
        }else{

            // recebe os dados
            $formulario = $this->request->getPost();

            // encapsula dados
            $dados = [
                'fatcat_nome'           => $formulario['input_nome'],
            ];

            // Atualiza na base de dados
            $faturamentoCategoriaModel = new FaturamentoCategoriaModel();
            $insere = $faturamentoCategoriaModel->update($formulario['id_faturamentocategoria'], $dados);

            // se Insere na base : apresentou erro
            if(!$insere):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                return redirect()->back()->withInput();

            // senao Insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Categoria de faturamento atualizado com sucesso.');
                return redirect()->to('/faturamentoCategoria');

            endif;
        }

    }



    /**
     * DELETA} Exclui um fatura do sistema. Soft delet está ativo
     * 
     * @param int $id_faturamentocategoria
     * @return object
     */
    public function exclui( int $id_faturamentocategoria) : object {

        // Exclui fatura        
        $faturamentoCategoriaModel = new FaturamentoCategoriaModel();

        // excluir fatura retornou erro
        if(!$faturamentoCategoriaModel->delete(['id_faturamentocategoria' => $id_faturamentocategoria])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir a categoria de faturamento.');
            return redirect()->back();

        // excluiu fatura com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Categoria de faturamento excluído com sucesso.');
            return redirect()->back();

        endif;

    }
    

}