<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UsuarioModel;

class Login extends BaseController
{



    /**
     * INDEX } Retorna a página de login
     * 
     * @param NULL
     * @return string
     */
    public function index() {

        // se ja possui session
        $existe = session()->get('isLoggedIn');
        if($existe == true):
            return redirect()->to('/');
        endif;
        
        return view('admin/login/login');
    }



    /**
     * SIGN IN } Função que realiza a autenticação do login e senha
     * 
     * @param array $email, $senha
     * @return object 
     */
    public function signin() : object   {

        // Recebe dados do formulário
        $usu_email = $this->request->getPost('inputEmail');
        $usu_password = $this->request->getPost('inputPassword');

        // Verifica na base os dados
        $usuarioModel = new UsuarioModel();
        $dadosUsuario = $usuarioModel->getByEmail($usu_email);

        // se retornou da base os dados com sucesso
        if(count($dadosUsuario) > 0):
            $hashUsuario = $dadosUsuario['usu_senha'];

            // verifica se a senha é a mesma da base
            if(password_verify($usu_password, $hashUsuario)):
                session()->set('isLoggedIn', true);
                session()->set('usu_nome', $dadosUsuario['usu_nome']);
                return redirect()->to('/');
                
            // se a senha for diferente a salva na base
            else:
                session()->setFlashdata('msg', 'Usuario ou senha incorretos (#2)');
                return redirect()->to('/login');
            endif;

        // se retornou erro da base nos dados
        else:
            session()->setFlashdata('msg', 'Usuario ou senha incorretos. (#1)');
            return redirect()->to('/login');
        endif;
    }



    /**
     * SIGN OUT } Função que encerra session de autenticação
     * 
     * @param array $email, $senha
     * @return object 
     */
    public function signout() : object{
        session()->destroy();
        return redirect()->to('/login');
    }




}