<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClienteModel;

class LoginCliente extends BaseController
{



    /**
     * INDEX } Retorna a página de login
     * 
     * @param NULL
     * @return string
     */
    public function index() {

        // se ja possui session
        $existe = session()->get('isClienteLoggedIn');
        if($existe == true):
            return redirect()->to('/painelCliente');
        endif;
        
        return view('cliente/login/login');
    }



    /**
     * SIGN IN } Função que realiza a autenticação do login e senha
     * 
     * @param array $email, $senha
     * @return object 
     */
    public function signin() : object   {

        // Recebe dados do formulário
        $cli_email = $this->request->getPost('inputEmail');
        $cli_password = $this->request->getPost('inputPassword');

        // Verifica na base os dados
        $clienteModel = new ClienteModel();
        $clienteModel->where('cli_email',$cli_email);
        $dadosCliente = $clienteModel->first();

        // se retornou da base os dados com sucesso
        if($dadosCliente):
            $hashCliente = $dadosCliente['cli_senha'];

            // verifica se a senha é a mesma da base
            if(password_verify($cli_password, $hashCliente)):
                session()->set('isClienteLoggedIn', true);
                session()->set('id_cliente', $dadosCliente['id_cliente']);
                return redirect()->to('/painelCliente');
                
            // se a senha for diferente a salva na base
            else:
                session()->setFlashdata('msg', 'Usuario ou senha incorretos (#2)');
                return redirect()->to('/loginCliente');
            endif;

        // se retornou erro da base nos dados
        else:
            session()->setFlashdata('msg', 'Usuario ou senha incorretos. (#1)');
            return redirect()->to('/loginCliente');
        endif;
    }



    /**
     * SIGN OUT } Função que encerra session de autenticação
     * 
     * @param array $email, $senha
     * @return object 
     */
    public function signout() : object{
        session()->destroy();
        return redirect()->to('/loginCliente');
    }



    /**
     * RECUPERAR } Recuperar senha esquecida
     * 
     * @param string $email
     * @return object 
     */
    public function recuperar() {

        // se a solicitação veio através de post
        if($this->request->getMethod() === 'post'):

            $cli_email = filter_var($this->request->getPost('inputEmail'), FILTER_SANITIZE_EMAIL);
            
            // verifica se existe o email solicitante
            $clienteModel = new ClienteModel();
            $clienteModel->select('id_cliente,cli_nome,cli_senha');
            $clienteModel->where('cli_email=',$cli_email);
            $dadosCliente = $clienteModel->first();
            
            if($dadosCliente):

                // PREVINE ENVIO DE EMAIL EM LOCALHOST
                // 1 = envia email
                // 2 = gera layout do email na tela, nao envia email
                // 3 = imprime na tela, não envia email nem layout
                if($_SERVER['CI_ENVIRONMENT'] == 'development'):
                    $flag = 2;
                    // $flag = 3;
                else:
                    $flag = 1;
                endif;

                // se 1 : envia email
                if($flag == 1){

                    // incia serviço de email
                    $email = \Config\Services::email();
                    $config = [
                        'protocol'  => 'smtp',
                        'SMTPHost'  => 'mail.nucleodenegociosweb.com.br',
                        'SMTPUser'  => 'adm@nucleodenegociosweb.com.br',
                        'SMTPPass'  => 'lucr4tivo!',
                        'SMTPPort'  => '587',
                        'wordWrap'  => true,
                        'mailType'  => 'html',
                    ];

                    // inicia o serviço de email do sistema
                    $email->clear(true);
                    $email->initialize($config);
                    $email->setFrom('adm@nucleodenegociosweb.com.br', 'Núcleo de Negócios WEB . Carol');
                    $email->setTo(array($cli_email));
                    $email->setSubject('[Recuperação de Senha] Pedido de recuperação de senha.');
                    $email->setAltMessage('Uma nova senha foi solicitada, para concluir o procedimento, acesse o endereço abaixo:\n\nhttps://www.nucleodenengociosweb.com.br/crm/loginCliente/recuperacao/' . $dadosCliente['id_cliente'] . '/' . $dadosCliente['cli_senha'] .  '\n\nSe estiver com dificuldade, entre em contato conosco através do site www.nucleodenegociosweb.com.br/cliente ou solicite por whatsapp/e-mail. \n\n Equipe Núcleo de Negócios WEB');
                    // define template para o email
                    $template = view('cliente/emailer/novaSenha', $dadosCliente);
                    $email->setMessage($template);

                    // envia
                    $email->send();

                // se 2 : retorna view na tela
                }elseif($flag == 2){
                    return view('cliente/emailer/novaSenha', $dadosCliente);

                // se 3 : retorna variaveis na tela
                }else{

                    // mostra variaveis
                    echo '<hr>';
                    echo '<p>var_dump fatura</p>';
                    var_dump($dadosCliente);
                    echo '<hr>';
                    die;
                }
            endif;

            // retorna
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','<b>Solicitação completa</b>. Verifique o link de autorização no email informado. <small> Certifique-se de olhar também na caixa de span, caso não encontre na caixa de entrada.</small>');
            return redirect()->back();

        endif;
        
        // se abriu a página sem post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Login | Página de recuperação de senha',

        ];
        return view('cliente/login/login-recuperar', $dados);

    }



    /**
     * LOGIN ATRAVÉS DA RECUPERACAO } Autentica o cliente usando id e hash da senha e solicita alteração de senha
     * 
     * @param string $id_cliente
     * @param string $cli_senha
     * @return ??
     */
    public function recuperacao(int $id_recuperacao, string $hash) {

        // carrega helper que interpreta senha na url
        helper('funcoes');
        
        // se a solicitação veio através de post
        if($this->request->getMethod() === 'post'):

            $rules = [
                'input_hash'    =>[
                    'rules' => 'required',
                    'errors'    => [
                        'required'  =>  'Hash Necessária. Ela pode ser encontrada em seu email, caso o campo estiver vazio.',
                    ]
                ],
                'input_pass'    =>[
                    'rules' => 'required|min_length[6]',
                    'errors'    => [
                        'required'  =>  'Campo obrigatório.',
                        'required'  =>  'Senha deve possuir um mínimo de 6 caracteres.',
                    ]
                ],
                'input_pass_confirm'    =>[
                    'rules' => 'required|matches[input_pass]',
                    'errors'    => [
                        'required'  =>  'Campo obrigatório.',
                        'matches'  =>  'A confirmação de senha deve ser igual a senha.',
                    ]
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                return redirect()->back()->with('errors', $this->validator->getErrors());

            // Validação executou com sucesso
            }else{

                // recebe dados
                $id_cliente = trim($this->request->getPost('id_cliente'));
                $input_hash = trim($this->request->getPost('input_hash'));
                $novaSenha = trim($this->request->getPost('input_pass'));
                $novaSenha = password_hash($novaSenha,PASSWORD_DEFAULT);
                $cli_senha = $this->request->getPost('cli_senha');

                // verifica se os dados batem
                $clienteModel = new ClienteModel();
                $clienteModel->select('id_cliente,cli_senha');
                $clienteModel->where('id_cliente',$id_cliente);
                $cliente = $clienteModel->first();
                $clienteModel->resetQuery();

                // confirma se todas as ids iguais
                if(($input_hash != $cliente['id_cliente'])||($id_cliente != $cliente['id_cliente'])):
                    session()->setFlashdata('msgType','danger');
                    session()->setFlashdata('msg','#11');
                    return redirect()->to('/loginCliente');
                endif;
                // confirma se senha é igual à hash
                if(urildecode($cli_senha) != $cliente['cli_senha']):
                    session()->setFlashdata('msgType','warning');
                    session()->setFlashdata('msg','#22');
                    return redirect()->to('/loginCliente');
                endif;

                $clienteModel = new ClienteModel();
                $clienteModel->where('id_cliente', $id_cliente);
                $clienteModel->set('cli_senha',$novaSenha);
                $clienteModel->update();

                session()->setFlashdata('msgType','success');
                session()->setFlashdata('msg','Tente acessar novamente utilizando a nova senha.');
                return redirect()->to('/loginCliente');
            }


        endif;

        // se a solicitação vio através de get

        // recupera dados
        $id_recuperacao = trim($id_recuperacao);
        $hash           = urildecode(trim($hash));

        // autentica
        $clienteModel = new ClienteModel();
        $clienteModel->select('id_cliente,cli_senha');
        $clienteModel->where('id_cliente',$id_recuperacao);
        $clienteModel->where('cli_senha',$hash);
        $dadosCliente = $clienteModel->first();

        // redireciona se não existir
        if(!$dadosCliente):
            session()->setFlashdata('msgType', ' warning');
            session()->setFlashdata('msg', ' Informe login e senha do cliente');
            return redirect()->to('/loginCliente');
        endif;

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Login | Página de recuperação de senha',
            'id_cliente'    => $dadosCliente['id_cliente'],
            'hash'          => urilencode($dadosCliente['cli_senha']),
        ];
        return view('cliente/login/login-recuperacao', $dados);

    }



    /**
     * LOGIN ATRAVÉS DA FATURA} Autentica o cliente usando id e hash da senha
     * 
     * @param string $id_cliente : nada : $cli_senha
     * @return ?? 
     */
    public function fatura($e){

        helper('funcoes');

        $e = trim(strip_tags($e)); // utilizar urlencode para tratar / na senha através do get
        $e = explode(':',$e);

        $clienteModel = new ClienteModel();
        $clienteModel->select('id_cliente');
        $clienteModel->where('id_cliente',$e[0]);
        $clienteModel->where('cli_senha',urldecode(urildecode($e[2])));
        $dadosCliente = $clienteModel->first();

        if($dadosCliente):
            session()->set('isClienteLoggedIn', true);
            session()->set('id_cliente', $dadosCliente['id_cliente']);
            return redirect()->to('/painelCliente');
        else:
            session()->setFlashdata('msgType', ' warning');
            session()->setFlashdata('msg', ' Informe login e senha do cliente');
            return redirect()->to('/login/cliente');
        endif;

    }


}