<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\MidiaModel;

class Midia extends BaseController
{



    /**
     * INDEX} Relaciona mídias da plataforma
     * 
     * @param null
     * @return string
     */
    public function index() : string {
        //$lojaId = filter_input(INPUT_GET, 'loja, FILTER_SANITIZE_NUMBER_INT);
        // $dados = filter_array(INPUT_POST, FILTER_DEFAULT)

        $fileUploadModel = new MidiaModel();
        $files = $fileUploadModel->orderBy('created_at', 'asc')->findAll();
        // constroi pagina
        $dados = [
            'TituloPagina'  => 'Midias',
            'files'         => $files,
        ];

        return view('admin/midia/midia-index', $dados);
    }



    /**
     * UPLOAD} Salva imagens na base e upload
     * 
     * @param array $form
     * @return string
     */
    public function upload() {
        
        $rules = [
            'fileuploads'   => [
                'rules' => [
                    'uploaded[fileuploads]',
                    'mime_in[fileuploads,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[fileuploads,20488]',
                ],
                'errors'    =>  [
                    'uploaded'  => 'necessário selecionar um arquivo.',
                    'mime_in'   => 'Formato inválido.',
                    'max_size'  => 'Tamanho maximo de 2MB',
                ],
            ],
            'mid_descricao'   => [
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Campo obrigatório',
                ],
            ],
        ];

        // Validação apresentou erro
        if(!$this->validate($rules)):

            // recarrega a página
            $errors = $this->validator->getErrors();
            session()->setFlashdata([
                'msgType'   => 'danger',
                'msg'       => 'Verifique os campos necessários.',
                'errors'     => $errors
            ]);
            return redirect()->back()->withInput();

        // Validação validou com sucesso
        else:
            
            $filesUploaded = 0;

            // recebe arquivos e dadods
            $files = $this->request->getFileMultiple('fileuploads');
            $dados = $this->request->getPost();
            $dados['mid_vencimento'] = ($dados['mid_vencimento'] == "" || $dados['mid_vencimento'] == '____-__-__ __:__:__' )? NULL : $dados['mid_vencimento'];

            // enquanto houver arquivos
            foreach ($files as $file) {

                // salva na base
                if ($file->isValid() && ! $file->hasMoved()){

                    $newName = $file->getRandomName();
                    $file->move(ROOTPATH . '/public/uploads/', $newName);
                    $data = [
                        'id_autor'          => session()->usu_nome,
                        'mid_nome'          => $file->getClientName(),
                        'mid_file'          => $newName,
                        'mid_descricao'     => $dados['mid_descricao'],
                        'mid_vencimento'    => $dados['mid_vencimento'],
                    ];
                    $fileUploadModel = new MidiaModel();
                    $sucesso = $fileUploadModel->save($data);
                    if($sucesso):
                        $filesUploaded++;
                    endif;
                }
            }
        endif;

        // se upload success
        session()->setFlashdata('msgType', 'success');
        session()->setFlashdata('msg', $filesUploaded . ' Arquivo(s) salvos com sucesso.');
        return redirect()->back();
    }



    /**
     * REMOVE} Exclui da base e remove arquvio
     * 
     * @param array $form
     * @return string
     */
    public function remove($id){

        // vem id
        $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

        // seleciona caminho
        $midiaModel = new MidiaModel();
        $file = $midiaModel->find($id);
        
        $caminho = ROOTPATH . '/public/uploads/';

        // unlink
        $removeu = unlink($caminho . $file['mid_file']);

        if($removeu):
            $midiaModel->resetQuery();
            $sucesso = $midiaModel->delete($id);
            
            // se não teve sucesso
            if(!$sucesso):

                // retorna
                session()->setFlashdata([
                    'msgTpe'    => 'danger',
                    'msg'       => 'Não foi possível remover a imagem.',
                ]);
                return redirect()->back();
            endif;

            // retorna resultado
            session()->setFlashdata([
                'msgTpe'    => 'success',
                'msg'       => $file['mid_nome'] . 'Removido com sucesso.',
            ]);
            return redirect()->back();

        endif;
        //retorna
        var_dump($id);

    }



}
