<?php

namespace App\Controllers;
use App\Controllers\BaseController;
use App\Libraries\Zdg;
use App\Models\ClienteModel;
use App\Models\OrganizacaoModel;
use App\Models\OrcamentoModel;

class Orcamento extends BaseController
{



    /**
     * INDEX } Retorna listagem de todos os orçamentos
     * 
     * @param NULL
     * @return string
     */
    public function index() : string {

        // reotrna todos os orçamentos cadastrados
        $orcamentoModel = new OrcamentoModel();
        
        // retorna todos os clientes cadastrados
        $clienteModel = new ClienteModel();
        
        // retorna todas as organizacoes cadastradas
        $organizacaoModel = new OrganizacaoModel();
        
        // cria condicao do menu
        if($this->request->getGet('status') == 'aberto'):
            $orcamentoModel->where('orc_status','aberto');
        elseif($this->request->getGet('status') == 'aprovado'):
            $orcamentoModel->where('orc_status','aprovado');
        elseif($this->request->getGet('status') == 'recusado'):
            $orcamentoModel->where('orc_status','recusado');
        else:
            $orcamentoModel->where('orc_status','aberto');
        endif;

        // define informacoes da pagina
        $dados = [
            'TituloPagina'      => 'Orçamentos',
            'listagemOrcamento' => $orcamentoModel->paginate(10),
            'pager'             => $orcamentoModel->pager,
            'clientes'          => $clienteModel->findAll(),
            'organizacoes'          => $organizacaoModel->findAll(),
        ];

        return view('admin/orcamento/orcamento-index', $dados);
    }



    /**
     * CADASTRA} Cadastra um novo orçamentos
     * 
     * @param NULL
     * @return array
     */
    public function cadastra() {
        
        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_nome' =>[
                    'rules'     => 'permit_empty',
                ],
                'input_email' => [
                    'rules' => 'permit_empty|valid_email',
                    'errors'    => [
                        'valid_email' => 'Insira um e-mail válido.',
                    ],
                ],
                'input_whats' => [
                    'rules' => 'permit_empty|min_length[8]',
                    'errors'    => [
                        'min_length' => 'Precisa ter pelo menos 8 caracteres.',
                    ],
                ],
                'input_titulo' => [
                    'rules' => 'required|min_length[4]',
                    'errors'    => [
                        'required' => 'Precisa ter.',
                        'min_length' => 'Precisa ter pelo menos 4 caracteres.',
                    ],
                ],
                'input_descricao' => [
                    'rules' => 'required|min_length[6]',
                    'errors'    => [
                        'required'  => 'Insira um conteúdo.',
                        'min_length' => 'O conteúdo precisa ter pelo menos 6 caracteres.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();
                $dados = [
                    'id_cliente'            => ($formulario['input_id_cliente']=='NULL')? null : $formulario['input_id_cliente'],
                    'orc_nome'              => ($formulario['input_nome']=='')? null : $formulario['input_nome'],
                    'orc_email'             => ($formulario['input_email']=='')? null : $formulario['input_email'],
                    'orc_whats'             => ($formulario['input_whats']=='')? null : $formulario['input_whats'],
                    'orc_titulo'            => $formulario['input_titulo'],
                    'orc_descricao'         => $formulario['input_descricao'],
                    'orc_status'            => 'aberto',
                ];
                
                // insere na base de dados
                $orcamentoModel = new OrcamentoModel();

                // insere na base : apresentou erro
                if(!$orcamentoModel->save($dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'danger');
                    session()->setFlashdata('msg', 'Erro no cadastro do Orçamento.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Orçamento Cadastrado com Sucesso.');
                    return redirect()->to('/orcamento');
                endif;
            }
        }

        // continua se não veio por post

        // redireciona a página
        session()->setFlashdata('msgType', 'danger');
        session()->setFlashdata('msg', 'Não entendi o orçamento.');
        return redirect()->to('/painel')->withInput();

    }



    /**
     * EDITA} Mostra as informações de um orçamentos e edita
     * 
     * @param int $id_orcamento
     * @return string
     */
    public function edita(int $id_orcamento) {

        // se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_nome' =>[
                    'rules'     => 'permit_empty',
                ],
                'input_email' => [
                    'rules' => 'permit_empty|valid_email',
                    'errors'    => [
                        'valid_email' => 'Insira um e-mail válido.',
                    ],
                ],
                'input_whats' => [
                    'rules' => 'permit_empty|min_length[8]',
                    'errors'    => [
                        'min_length' => 'Precisa ter pelo menos 8 caracteres.',
                    ],
                ],
                'input_titulo' => [
                    'rules' => 'required|min_length[4]',
                    'errors'    => [
                        'required' => 'Precisa ter.',
                        'min_length' => 'Precisa ter pelo menos 4 caracteres.',
                    ],
                ],
                'input_descricao' => [
                    'rules' => 'required|min_length[6]',
                    'errors'    => [
                        'required'  => 'Insira um conteúdo.',
                        'min_length' => 'O conteúdo precisa ter pelo menos 6 caracteres.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                session()->setFlashdata('msgType','danger');
                session()->setFlashdata('msg','Não validou');
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // recebe os dados
                $formulario = $this->request->getPost();
                
                
                // encapsula dados com senha
                $dados = [
                    'id_cliente'            => ($formulario['input_id_cliente']=='NULL')? null : $formulario['input_id_cliente'],
                    'orc_nome'              => ($formulario['input_nome']=='')? null : $formulario['input_nome'],
                    'orc_email'             => ($formulario['input_email']=='')? null : $formulario['input_email'],
                    'orc_whats'             => ($formulario['input_whats']=='')? null : $formulario['input_whats'],
                    'orc_titulo'            => $formulario['input_titulo'],
                    'orc_descricao'         => $formulario['input_descricao'],
                    'orc_status'            => $formulario['input_status'],
                ];

                // Atualiza na base de dados
                $orcamentoModel = new OrcamentoModel();

                // Atualiza na base : apresentou erro
                if(!$orcamentoModel->update($formulario['id_orcamento'], $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                    return redirect()->back()->withInput();

                //  Atualiza na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Cliente Atualizado com sucesso.');
                    return redirect()->to('/orcamento/edita/'.$formulario['id_orcamento']);
                endif;
            }
        }
        
        // continua se não veio por post

        // retorna todos os clientes cadastrados
        $orcamentoModel = new OrcamentoModel();

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  => 'Orçamento | Edite os dados',
            'orcamento'       => $orcamentoModel->find($id_orcamento),
        ];

        return view('admin/orcamento/orcamento-edita', $dados);
    }



    /**
     * EXCLUI} Remove as informações de um orçamentos da base de dados
     * 
     * @param int $id_orcamento
     * @return string
     */
    public function exclui(int $id_orcamento) {

        // Exclui usuário        
        $orcamentoModel = new OrcamentoModel();
        $confirma = $orcamentoModel->delete($id_orcamento);

        // excluir cliente retornou erro
        if(!$confirma):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir Orçamento.');
            return redirect()->back();

        // excluiu cliente com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Orçamento Excluído com sucesso.');
            return redirect()->back();

        endif;
    }



    /**
     *  LEMBRETE WHATSAPP} Envia notificação para o whatsapp do cliente
     * 
     * @param $id_orcamento
     * @return 
     */
    public function lembreteWhats($id_orcamento) {

        $id_orcamento           = trim($id_orcamento);
        $info = [
            'destinatario'  => null,
            'para'          => null,
            'mensagem'      => null,
        ];

        // seleciona orçamento
        $orcamentoModel = new OrcamentoModel();
        $orcamentoModel->where('id_orcamento',$id_orcamento);
        $orcamento = $orcamentoModel->First();
        
        // seleciona dados do cliente quando vier id no formulário
        if($orcamento['id_cliente'] != null):
            $clienteModel = new ClienteModel();
            $clienteModel->where('id_cliente', $orcamento['id_cliente']);
            $cliente = $clienteModel->first();
            $info['para'] = str_replace([' ','-','.','(',')'],'',$cliente['cli_telefone']);
            $info['destinatario'] = explode(' ',$cliente['cli_nome']);
            $info['destinatario'] = $info['destinatario'][0];
        else:
            $info['para'] = str_replace([' ','-','.','(',')'],'',$orcamento['orc_whats']);
            $info['destinatario'] = explode(' ',$orcamento['orc_nome']);
            $info['destinatario'] = $info['destinatario'][0];
        endif;
        $info['mensagem'] = $orcamento['orc_descricao'];

        // seleciona bot da organizacao
        $organizacaoModel = new OrganizacaoModel();
        $organizacaoModel->select('id_organizacao, org_botUrl, org_botAuth, org_botHash');
        $organizacao = $organizacaoModel->first();
        
        // chama disparo
        $zdg = new Zdg($organizacao['org_botUrl'],$organizacao['org_botAuth'],$organizacao['org_botHash']);
        
        // se dev envia para a Dalla
        if($_SERVER['CI_ENVIRONMENT'] == 'development'):
            $zdg->numero('11969113261');
        elseif($_SERVER['CI_ENVIRONMENT'] == 'production'):
            $zdg->numero($info['para']);
        endif;
            

        $zdg->mensagem('*Carol:*
Oi '. $info['destinatario'].',

Espero que esteja tudo bem.');
        $zdg->sendMessage();
        sleep(1);
        $zdg->mensagem('*Carol:*
Gostaria de lhe apresentar uma proposta.');
        $zdg->sendMessage();
        sleep(3);
        $zdg->mensagem('*Carol:*
'.$info['mensagem']);
        $retorno = $zdg->sendMessage();
        
        // retorna
        if($retorno['status'] == true):
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg',$retorno['message']);
        else:
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Tente novamente. #2 '. $retorno['message']);
        endif;
        return redirect()->back();
        

    }



}