<?php

namespace App\Controllers;

use App\Libraries\Zdg;
use App\Controllers\BaseController;
use App\Models\OrganizacaoModel;

class Organizacao extends BaseController
{



    /**
     * INDEX } Retorna listagem de todas as organizações
     * 
     * @param false
     * @return string
     */
    public function index() : string {
        
        // retorna todas as organizacoes cadastradas
        $organizacaoModel = new OrganizacaoModel();
        $organizacaoModel->select('id_organizacao, org_nome, org_botUrl, org_botAuth, org_botHash');
        $organizacao = $organizacaoModel->first();
        $organizacaoModel->resetQuery();

        // verifica se está trabalhando o bot
        if($this->request->getGet('bot')):
            $botQuery = trim($this->request->getGet('bot'));
        else:
            $botQuery = null;
        endif;
        // controle do bot whatsapp
        $zdgRetorno = null;

        // BOT > STATUS
        if($botQuery === 'status'):
            $botZdg = new Zdg($organizacao['org_botUrl'],$organizacao['org_botAuth'],$organizacao['org_botHash']);
            $zdgRetorno = $botZdg->botStatus();
            var_dump($zdgRetorno);
        endif;

        // BOT > CRIAR
        if($botQuery === 'cria'): 
            // atualiza base de dados com auth e hash automaticos
            $dados = [
                'org_botAuth'   => sprintf('%07X', mt_rand(0, 0xFFFFFFF)),'org_botHash'   => sprintf('%07X', mt_rand(0, 0xFFFFFFF))
            ];
            $organizacaoModel->update($organizacao['id_organizacao'],$dados);
            $organizacaoModel->resetQuery();
            // BOT > se não existir, cria o bot
            $botZdg = new Zdg($organizacao['org_botUrl']);
            $botZdg->botAuth($dados['org_botAuth']);
            $botZdg->botHash($dados['org_botHash']);
            // retorno
            $zdgRetorno = $botZdg->botCria();
            var_dump($zdgRetorno);
        endif;

        // BOT > REMOVER
        if($botQuery === 'remove'):
            $botZdg = new Zdg($organizacao['org_botUrl'],$organizacao['org_botAuth'],$organizacao['org_botHash']);
            $zdgRetorno = $botZdg->botRemove();
        endif;

        // BOT > qrCode
        if($botQuery === 'qrCode'):
            $botZdg = new Zdg($organizacao['org_botUrl'],$organizacao['org_botAuth'],$organizacao['org_botHash']);
            $zdgRetorno = $botZdg->qrCode();
            var_dump($zdgRetorno);
        endif;

        // BOT > ENVIA MENSAGEM TESTE
        if($botQuery === 'sendMessage'):
            $botZdg = new Zdg($organizacao['org_botUrl'],$organizacao['org_botAuth'],$organizacao['org_botHash']);
            $botZdg->numero('47 99634-4386');
            $botZdg->mensagem('Olá fulano de tal');
            $zdgRetorno = $botZdg->sendMessage();
            var_dump($zdgRetorno);
        endif;

        // define informacoes da pagina
        $dados = [
            'TituloPagina'          =>  'Organizações | Página principal',
            'listagemOrganizacoes'  => $organizacaoModel->findAll(), // tras todas
            'botzdg'                => $zdgRetorno,
            'organizacao'           => $organizacao, // tras id 1
        ];

        return view('admin/organizacao/organizacao-index', $dados);
    }



    /**
     * CADASTRA} Cadastra um novo organização
     * 
     * @param false
     * @return ? array e string
     */
    public function cadastra() {
        
        var_dump($this->request->getMethod());
        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            die;
            // cria regras de formulario
            $rules = [
                'input_responsavel' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_responsavel_cpf' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_nome' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_nome_fantasia' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_cnpj' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_insc_municipal' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_endereco' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_endereco_numero' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_endereco_compl' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_bairro' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_municipio' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_estado_uf' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_pais' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_cep' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_email' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_botUrl' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_botAuth' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_botHash' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){
        die;
                // recarrega a página
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();
                $dados = [
                    'org_responsavel'       => $formulario['input_responsavel'],
                    'org_responsavel_cpf'   => $formulario['input_responsavel_cpf'],
                    'org_nome'              => $formulario['input_nome'],
                    'org_nome_fantasia'     => $formulario['input_nome_fantasia'],
                    'org_cnpj'              => $formulario['input_cnpj'],
                    'org_insc_municipal'    => $formulario['input_insc_municipal'],
                    'org_endereco'          => $formulario['input_endereco'],
                    'org_endereco_numero'   => $formulario['input_endereco_numero'],
                    'org_endereco_compl'    => $formulario['input_endereco_compl'],
                    'org_bairro'            => $formulario['input_bairro'],
                    'org_municipio'         => $formulario['input_municipio'],
                    'org_estado_uf'         => $formulario['input_estado_uf'],
                    'org_pais'              => $formulario['input_pais'],
                    'org_cep'               => $formulario['input_cep'],
                    'org_email'             => $formulario['input_email'],
                    'org_botUrl'            => $formulario['input_botUrl'],
                    'org_botAuth'           => $formulario['input_botAuth'],
                    'org_botHash'           => $formulario['input_botHash'],
                ];

                // insere na base de dados
                $organizacaoModel = new OrganizacaoModel();

                // insere na base : apresentou erro
                if(!$organizacaoModel->save($dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Erro No Cadastrado do Organizacao.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Organizacao Cadastrado com Sucesso.');
                    return redirect()->to('/organizacao');
                endif;
            }
        }

        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Organizacoes | Cadastre um novo organizacao',
        ];

        // constroi pagina
        return view('admin/organizacao/organizacao-cadastra', $dados);
    }



    /**
     * EDITA} Mostra as informações de um organizacao e edita
     * 
     * @param int $id_organizacao
     * @return ? array e string
     */
    public function edita(int $id_organizacao) {

        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_responsavel' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_responsavel_cpf' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_nome' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_nome_fantasia' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_cnpj' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_insc_municipal' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_endereco' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_endereco_numero' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_endereco_compl' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_bairro' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_municipio' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_estado_uf' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_pais' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_cep' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_email' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_botUrl' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_botAuth' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                'input_botHash' =>[
                    'rules'     => 'permit_empty',
                    'errors'    => [
                        'required'  => 'É necessário preencher este campo.',
                    ],
                ],
                
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // recebe os dados
                $formulario = $this->request->getPost();
                
                // encapsula dados
                $dados = [
                    'org_responsavel'       => $formulario['input_responsavel'],
                    'org_responsavel_cpf'   => $formulario['input_responsavel_cpf'],
                    'org_nome'              => $formulario['input_nome'],
                    'org_nome_fantasia'     => $formulario['input_nome_fantasia'],
                    'org_cnpj'              => $formulario['input_cnpj'],
                    'org_insc_municipal'    => $formulario['input_insc_municipal'],
                    'org_endereco'          => $formulario['input_endereco'],
                    'org_endereco_numero'   => $formulario['input_endereco_numero'],
                    'org_endereco_compl'    => $formulario['input_endereco_compl'],
                    'org_bairro'            => $formulario['input_bairro'],
                    'org_municipio'         => $formulario['input_municipio'],
                    'org_estado_uf'         => $formulario['input_estado_uf'],
                    'org_pais'              => $formulario['input_pais'],
                    'org_cep'               => $formulario['input_cep'],
                    'org_email'             => $formulario['input_email'],
                    'org_email_disparo'     => $formulario['input_email_disparo'],
                    'org_email_senha'       => $formulario['input_email_senha'],
                    'org_email_protocol'    => $formulario['input_email_protocol'],
                    'org_email_smtp'        => $formulario['input_email_smtp'],
                    'org_email_port'        => $formulario['input_email_port'],
                    'org_botUrl'            => $formulario['input_botUrl'],
                    'org_botAuth'           => $formulario['input_botAuth'],
                    'org_botHash'           => $formulario['input_botHash'],
                ];

                // Atualiza na base de dados
                $organizacaoModel = new OrganizacaoModel();

                // insere na base : apresentou erro
                if(!$organizacaoModel->update($formulario['id_organizacao'], $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Organizacao Atualizada com sucesso.');
                    return redirect()->to('/organizacao/edita/'.$formulario['id_organizacao']);
                endif;
            }
        }
        
        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Organização | Edite seus dados',
        ];

        //var_dump($request);

        // retorna todos os organizacoes cadastrados
        $organizacaoModel = new OrganizacaoModel();
        $dados['organizacao'] = $organizacaoModel->find($id_organizacao);

        return view('admin/organizacao/organizacao-edita', $dados);
    }



    /**
     * DELETA} Exclui um organizacao do sistema. Soft delet está ativo
     * 
     * @param int $id_organizacao
     * @return object
     */
    public function exclui( int $id_organizacao) : object {

        // Exclui organizacao        
        $organizacaoModel = new OrganizacaoModel();

        // excluir organizacao retornou erro
        if(!$organizacaoModel->delete(['id' => $id_organizacao])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir Organizacao.');
            return redirect()->back();

        // excluiu organizacao com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Organizacao Excluído com sucesso.');
            return redirect()->back();

        endif;

    }



}