<?php

namespace App\Controllers;

use App\Models\ClienteModel;
use App\Models\ClientePedidoModel;
use App\Models\EvuptContatoModel;
use App\Models\FaturaFormapgtoModel;
use App\Models\FaturaModel;
use App\Models\OrcamentoModel;
use App\Models\RetornoModel;
use DateTime;
use DateTimeZone;

class Painel extends BaseController
{



    /**
     * INDEX} Exclui um usuário do sistema. Soft delet está ativo
     * 
     * @param NULL
     * @return string
     */
    public function index() : string{

        helper('funcoes');

        // declaracoes
        $clienteModel = new ClienteModel();
        $faturaModel = new FaturaModel();
        $clientePedidoModel = new ClientePedidoModel();

        //seleciona todos os clientes com faturas abertas
        $clienteModel->join('fatura','fatura.id_cliente=cliente.id_cliente');
		$clienteModel->where('fat_status=','1');
        $result = $clienteModel->findAll();
        $clienteModel->resetQuery();

        // seleciona todos os orcamentos em aberto
        $orcamentoModel = new OrcamentoModel();
        $orcamentoModel->where('orc_status','aberto');
        $resultOrcamentos = $orcamentoModel->findAll('10');

        // seleciona todos os clientes
        $clienteModel->select('id_cliente,cli_nome');
        $resultCliente = $clienteModel->findAll();
        $clienteModel->resetQuery();

        // clientes total
        $totalCliente = $clienteModel->countAllResults();
        $clienteModel->resetQuery();

        // faturas total
        $faturaModel->where('fat_status','1');
        $totalFatura = $faturaModel->countAllResults();

        // faturas vencidas total
        $diadehoje = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
        $faturaModel->resetQuery();
        $faturaModel->where('fat_status','1');
        $faturaModel->where('DATE(fat_vencimento)<',$diadehoje->format('Y-m-d'));
        $totalFaturaVencida = $faturaModel->countAllResults();

        // faturas vencendo total
        $faturaModel->resetQuery();
        $faturaModel->where('fat_status','1');
        $faturaModel->where('DATE(fat_vencimento)=',$diadehoje->format('Y-m-d'));
        $totalFaturaVencendo = $faturaModel->countAllResults();

        // contratos total
        $clientePedidoModel->resetQuery();
        $clientePedidoModel->where('cliped_status=','1');
        $totalContratos = $clientePedidoModel->countAllResults();
        
        // Contratos vencendo no mês total
        $trintadias = new DateTime('NOW', new DateTimeZone('America/Sao_Paulo'));
        //$trintadias = $trintadias->modify('30 days');
        $trintadias = $trintadias->modify('last day of this month');
        $trintadias = $trintadias->format('Y-m-d');
        
        // proximos vencimentos e que estão ativos 1
        $clientePedidoModel = new ClientePedidoModel();
        $clientePedidoModel->where('cliped_status','1');
        $clientePedidoModel->join('produto','produto.id_produto = cliente_pedido.id_produto');
        $listagemCobranca = $clientePedidoModel->findAll();

        $resultCobrancas = array();
        $totalCobrancas = 0;
        foreach($listagemCobranca as $r):

            // encapsula apenas as que atendentem a condicao de trintadias
            if($r['cliped_pagamentoproximo'] <= $trintadias):

                //ajusta data da proxima cobranca formato brasil
                $r['cliped_pagamentoproximo'] = dataBrasil($r['cliped_pagamentoproximo'],'data');
        
                //ajusta nome do ciclo
                switch($r['cliped_pagamentoperiodo']):
                    case '1':
                        $r['cliped_pagamentoperiodo'] = 'Anual';
                    break;
                    case '2':
                        $r['cliped_pagamentoperiodo'] = 'Semestral';
                    break;
                    case '4':
                        $r['cliped_pagamentoperiodo'] = 'Trimestral';
                    break;
                    case '8':
                        $r['cliped_pagamentoperiodo'] = 'Mensal';
                    break;
                    default :
                        $r['cliped_pagamentoperiodo'] = $r['cliped_pagamentoperiodo'];
                endswitch;
                
                //encapsula variaveis
                $resultCobrancas[$r['id_clientepedido']] = $r;

                // produz somatoria de provisionamento
                $estacobranca = NULL;
                //valor na base está salvo com vírgula nos decimais
                $estacobranca = str_replace('.','',$r['cliped_valor']);
                $estacobranca = str_replace(',','.',$estacobranca);
                $totalCobrancas = $totalCobrancas + $estacobranca;
            endif;
        endforeach;
        $totalCobrancas = number_format($totalCobrancas,2,",",".");

        //
        // Retorno
        $retornoModel = new RetornoModel();
        $retornoModel->limit(10); //ultimos 10 acessos
        $retornoModel->orderBy("id_retorno", "DESC");
        $retorno = $retornoModel->find();

        // declara variaveis
        $relatorio = array();
        $i = 0;

        // enquanto houver registros
        foreach($retorno as $r):
            // decodifica json
            $row = json_decode($r['conteudo'],TRUE);

            // ajusta data
            $row['time'] = new DateTime($row['time']);

            // se relatório vier do evupt, pesquina informações na base dele
            if( $row['more'] == 'from_evupt' ):
                // verifica o nome do id
                $evuptContatoModel = new EvuptContatoModel();
                $evuptContatoModel->where('id_contato',$row['userid']);
                $fulano = $evuptContatoModel->withDeleted()->first();

                // preenche o relatorio de retornos
                $relatorio[$i]['id_retorno'] = $row['userid'];
                $relatorio[$i]['conteudo'] = ' <small>' . $row['time']->format('d/m à\s H:i');
                $relatorio[$i]['conteudo'] .= ' <a href="'. base_url() .'/evupt/templateEdita/'.$row['campaign'].'" title="Template '.$row['campaign'].'" class="text-secondary">por eVupt</a>';
                $relatorio[$i]['conteudo'] .= '  <br> ';
                $relatorio[$i]['conteudo'] .= $fulano['con_email'];
                $relatorio[$i]['conteudo'] .= '</small>';
                $relatorio[$i]['conteudo'] .= '<br>';
                $i++;
            endif;

            // se relatório vier do sistema, pesquisa nos clientes
            if( $row['more'] == 'from_caixapreta' ):
                // verifica o nome do id
                $clienteModel->resetQuery();
                $clienteModel->select('cliente.cli_nome');
                $clienteModel->where('id_cliente',$row['userid']);
                $fulano = $clienteModel->withDeleted()->first();

                // preenche o relatorio de retornos
                $relatorio[$i]['id_retorno'] = $row['userid'];
                $relatorio[$i]['conteudo'] = ' <small>' . $row['time']->format('d/m à\s H:i') . '</small> ';
                // $relatorio[$i]['conteudo'] .= $fulano['cli_nome'];
                $relatorio[$i]['conteudo'] .= '<a href="'. base_url() .'/fatura/templateedit?uid='.$row['userid'].'&tipo='.$row['campaign'].'">';
                $relatorio[$i]['conteudo'] .= ' ' . $row['campaign'];
                $relatorio[$i]['conteudo'] .= '</a>';
                $relatorio[$i]['conteudo'] .= '<br>';
                $i++;
            endif;
        endforeach;

        // organiza informações da página
        $dados = [
            'TituloPagina'              => 'Página Principal',
		    'listagem'                  => $result,
		    'listagemCliente'           => $resultCliente,
		    'listagemCobranca'          => $resultCobrancas,
            'listagemOrcamento'         => $resultOrcamentos,
		    'totalCobrancas'            => $totalCobrancas,
		    'totalCliente'              => $totalCliente,
		    'totalFatura'               => $totalFatura,
		    'totalFaturaVencida'        => $totalFaturaVencida,
		    'totalFaturaVencendo'       => $totalFaturaVencendo,
		    'totalContratos'            => $totalContratos,
		    'retorno'                   => $relatorio,
        ];
        return view('admin/painel', $dados);
    }


    /**
     * BUSCA RÁPIDA} Sistema de busca rápida para o painel
     * 
     * @param NULL
     * @return string
     */
    function fetch(){

        $output = '';
        $query = '';
        if($this->request->getPost('query')){
            $query = $this->request->getPost('query');
        }
        $clienteModel = new ClienteModel();
        $clienteModel->join("cliente_pedido", 'cliente_pedido.id_cliente = cliente.id_cliente');
        $clienteModel->select('cliente.id_cliente,cliente.cli_nome,cliente.cli_email,cliente_pedido.*');
        if($query != ''){
            $clienteModel->like('cli_nome', $query);
            $clienteModel->orLike('cli_email', $query);
            $clienteModel->orLike('cliped_dominio', $query);
        }
        $clienteModel->orderBy('cliente.id_cliente', 'DESC');
        $data = $clienteModel->findAll();

        $output .= '
            <div class="table-responsive">
             <table class="table table-bordered table-striped">
              <tr>
               <th>Nome</th>
               <th>email</th>
               <th>dominio</th>
              </tr>
        ';
        if($clienteModel->countAllResults() > 0){
            foreach($data as $row){
            $output .= '
              <tr>
               <td>'.anchor('cliente/painel/'.$row['id_cliente'],$row['cli_nome']).'</td>
               <td>'.$row['cli_email'].'</td>
               <td>'.$row['cliped_dominio'].'</td>
              </tr>
            ';
            }
        }else{
            $output .= '
              <tr>
               <td colspan="3">No Data Found</td>
              </tr>';
        }
        $output .= '</table>';
        echo $output;
    }





}
