<?php
namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClienteDetalheModel;
use App\Models\ClienteModel;
use App\Models\ClientePedidoModel;
use App\Models\ContabilModel;
use App\Models\FaturaFormapgtoBoletoModel;
use App\Models\FaturaModel;

class PainelCliente extends BaseController {



    /**
     * INDEX } Retorna o painel do cliente
     * 
     * @param NULL
     * @return string
     */
    public function index() {

        helper('funcoes');
        
        // se ja possui session
        $idcliente = session()->id_cliente;
        $clienteModel = new ClienteModel();
        $clienteModel->select('cli_nome, cli_avatar');
        $clienteModel->where('id_cliente',$idcliente);
        $cliente = $clienteModel->first();

        //seleciona todas as faturas do cliente
        $faturaModel = new FaturaModel();
        $faturaModel->orderBy('id_fatura','desc');
        $faturaModel->where('id_cliente',$idcliente);
        $listagem = $faturaModel->findAll();
        
        //seleciona todos os boletos da fatura
        $i = 0;
        $faturaFormapgtoBoleto = new FaturaFormapgtoBoletoModel();
        $contabilModel = new ContabilModel();
        foreach($listagem as $r):
            // seleciona todos os boletos da fatura
            $faturaFormapgtoBoleto->resetQuery();
            $faturaFormapgtoBoleto->where('id_fatura',$r['id_fatura']);
            $listagemBoletos = $faturaFormapgtoBoleto->findAll();
            $listagem[$i]['boleto'] = $listagemBoletos;

            // seleciona todas as notas fiscais NFs-e
            $contabilModel->resetQuery();
            $contabilModel->where('id_fatura',$r['id_fatura']);
            $dadosContabil = $contabilModel->findAll();
            $listagem[$i]['nfse'] = $dadosContabil;

            $i++;
        endforeach;

        //seleciona todos os produtos do cliente
        $clientePedidoModel = new ClientePedidoModel();
        $clientePedidoModel->join('produto','produto.id_produto = cliente_pedido.id_produto');
        $clientePedidoModel->where('id_cliente',$idcliente);
        $produtos = $clientePedidoModel->findAll();

        //seleciona todos os detalhes do cliente
        $clienteDetalheModel = new ClienteDetalheModel();
        $clienteDetalheModel->where('id_cliente',$idcliente);
        $clienteDetalheModel->where('clidet_publico','1');
        $detalhe = $clienteDetalheModel->findAll();
        
        // resultado na pagina
        $dados = [
            'TituloPagina'      => 'Painel | Página principal',
            'cliente'           => $cliente,
            'listagem'          => $listagem,
            'produtos'          => $produtos,
            'detalhe'           => $detalhe,
        ];
        return view('cliente/painel',$dados);
		
		
	}


    // funcao ajax informacoes empresa cliente
    public function capturar(){
        if(isset($_POST['dados'])):
            echo 'dados ticket medio';
        endif;
        
        
        if(isset($_POST['elements'])):
            echo 'elementos consultoria';
        endif;

        var_dump($_POST);
        
    }

	
}
