<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ProdutoModel;

class Produto extends BaseController
{



    /**
     * INDEX } Retorna listagem de todos os produtos
     * 
     * @param false
     * @return string
     */
    public function index() : string {
        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Produtos | Página principal',

        ];

        // retorna todos os produtos cadastrados
        $produtoModel = new ProdutoModel();
        $dados['listagemProdutos'] = $produtoModel->findAll();

        return view('admin/produto/produto-index', $dados);
    }



    /**
     * CADASTRA} Cadastra um novo produto
     * 
     * @param false
     * @return ? array e string
     */
    public function cadastra() {
        
        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_name' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira um nome de produto.',
                    ],
                ],
                'input_valor_mensal' => [
                    'rules' => 'required',
                    'errors'    => [
                        'required'  => 'Insira um valor mensal.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();
                $dados = [
                    'pro_nome'          => $formulario['input_name'],
                    'pro_valor'         => $formulario['input_valor'],
                    'pro_valormensal'  => $formulario['input_valor_mensal'],
                ];

                // insere na base de dados
                $produtoModel = new ProdutoModel();

                // insere na base : apresentou erro
                if(!$produtoModel->save($dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Erro No Cadastrado do Produto.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Produto Cadastrado com Sucesso.');
                    return redirect()->to('/produto');
                endif;
            }
        }

        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Produtos | Cadastre um novo produto',
        ];

        // constroi pagina
        return view('admin/produto/produto-cadastra', $dados);
    }



    /**
     * EDITA} Mostra as informações do produto para edição
     * 
     * @param int $id_produto
     * @return ? array e string
     */
    public function edita(int $id_produto) : string {

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Produtos | Editar produto',
        ];

        // retorna todos os produtos cadastrados
        $produtoModel = new ProdutoModel();
        $dados['produto'] = $produtoModel->find($id_produto);

        return view('admin/produto/produto-edita', $dados);
    }



    /**
     * EDITAR} DESENVOLVE A AÇÃO EDITAR PRODUTO
     * 
     * @param int $id_produto
     * @return ? array e string
     */
    public function editar(int $id_produto) {

        // verifica se veio informação por post
        if ($this->request->getMethod() !== 'post') {
            // redireciona se outro metodo
            return redirect()->to('/produto');
        }

        // cria regras de formulario
        $rules = [
            'input_name' =>[
                'rules'     => 'required',
                'errors'    => [
                    'required'  => 'Insira um nome de produto.',
                ],
            ],
            'input_valormensal' => [
                'rules' => 'required',
                'errors'    => [
                    'required'  =>  'Insira um valor mensal.',
                ],
            ],
        ];
        
        // se Validação apresentou erro
        if(!$this->validate($rules)){

            // redireciona para edita (routes)
            return redirect()->back()->withInput();

        // senao Validação executou com sucesso
        }else{

            // recebe os dados
            $formulario = $this->request->getPost();

            // encapsula dados
            $dados = [
                'pro_nome'          => $formulario['input_name'],
                'pro_valor'         => $formulario['input_valor'],
                'pro_valormensal'   => $formulario['input_valormensal'],
            ];

            // Atualiza na base de dados
            $produtoModel = new ProdutoModel();

            // se Insere na base : apresentou erro
            if(!$produtoModel->update($formulario['id_produto'], $dados)):
                // recarrega a página
                session()->setFlashdata('msgType', 'error');
                session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                return redirect()->back()->withInput();

            // senao Insere na base : executou com sucesso
            else:
                // redireciona a página
                session()->setFlashdata('msgType', 'success');
                session()->setFlashdata('msg', 'Produto Atualizado com sucesso.');
                return redirect()->to('/produto');
            endif;
        }

    }



    /**
     * DELETA} Exclui um produto do sistema. Soft delet está ativo
     * 
     * @param int $id_produto
     * @return object
     */
    public function exclui( int $id_produto) : object {

        // Exclui produto        
        $produtoModel = new ProdutoModel();

        // excluir produto retornou erro
        if(!$produtoModel->delete(['id' => $id_produto])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir o produto.');
            return redirect()->back();

        // excluiu produto com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Produto excluído com sucesso.');
            return redirect()->back();

        endif;

    }



}