<?php

namespace App\Controllers;

use App\Models\ClientePedidoModel;
use App\Models\FaturamentoModel;
use App\Models\FaturaModel;
use App\Models\RetornoModel;
use DateTime;
use DateTimeZone;

class Retorno extends BaseController
{


    /**
     * PIXEL }
	 * constroi a secao que recebe informações de pixels
     * quando alguém acessa os emails enviados pelo sistema
     * 
     * @param post $data
     * @return none
     */
	public function pixel(){

        // Create an image, 1x1 pixel in size
        $im=imagecreate(1,1);

        // Set the background colour
        $white=imagecolorallocate($im,255,255,255);

        // Allocate the background colour
        imagesetpixel($im,1,1,$white);

        // Set the image type
        header("content-type:image/jpg");

        // Create a JPEG file from the image
        imagejpeg($im);

        // Free memory associated with the image
        imagedestroy($im);

        //gera data de acesso
        $data = new DateTime('NOW', new DateTimeZone('America/Sao_Paulo'));

        //trata quando houver informacao
        if (isset($_GET['userid'])&&(is_numeric($_GET['userid']))):

            // // TRACK CODE
            // userid    : int id
            // campaign  : int id
            // more      : string from_base-de-dados
            // time      : horário que o pixel foi acionado
            // // RETORNO
            // {"userid":"1135","campaign":"1","more":"from_evupt","time":"2024-10-22 08:11:53"} campanha disparada
            // {"userid":"256","campaign":"4","more":"from_cliente","time":"2024-10-22 08:11:53"} informação de cliente

            //organiza
            $insere = array(
                'userid'    => $_GET['userid'],
                'campaign'  => str_replace(' ', '', $_GET['campaign']),
                'more'      => $_GET['more'],
                'time'      => $data->format('Y-m-d H:i:s'),
            );

            //cria estrutura json
            $insere = json_encode($insere);

            //salva na base de dados
            $retornoModel = new RetornoModel();
            $retornoModel->insert(['conteudo' => $insere]);

        else:
            echo 'ops';
        endif;
    }



    /**
     * WEBHOOK ASAAS BOLETO } 
     * Recebe informações sobre atualização financeira externa
     * 
     * @param post $dados
     * @return none
     */
    public function asaasBoleto() {

        // recebe json
        $json = file_get_contents('php://input');
        $jsonDecode = json_decode($json, true);

        // verifica se é pagamento
        if((!empty($jsonDecode))&&($jsonDecode['event']=='PAYMENT_RECEIVED')){

            // seleciona a fatura a ser paga
            $faturaModel = new FaturaModel();
            $faturaModel->where('id_fatura',$jsonDecode['payment']['externalReference']);
            $fatura = $faturaModel->first();
            $faturaModel->resetQuery();

            // se existe fatura e for igual a 1 | aberto
            if($fatura && $fatura['fat_status']==1):
            
                // variaveis
                $hoje = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
                $valorRecebido = $jsonDecode['payment']['value'];
                $valorRecebido = number_format($valorRecebido,2,",",".");
                
                // atualiza fatura
                $dados = [
                    'fat_pagamento'     => $hoje->format('Y-m-d H:i:s'),
                    'fat_status'        => '0', // 0 = pago | 1 = aberto | 2 = cancelado
                    'fat_valor'         => $valorRecebido, // valor recebido desconta taxas e bônus pgto na data
                ];
                $faturaModel->where('id_fatura',$jsonDecode['payment']['externalReference']);
                $faturaModel->set($dados);
                $retorno2 = $faturaModel->update();

                // se existir pedido relacionado a fatura paga
                $clientePedidoModel = new ClientePedidoModel();
                $clientePedidoModel->where('id_clientepedido',$fatura['id_pedido']);
                $clientePedido = $clientePedidoModel->first();

                // atualiza pedido para o próximo ciclo
                if($clientePedido):
        
                    //adiciona periodo na data de proximo pagamento do produto
                    $novociclo = date_create($clientePedido['cliped_pagamentoproximo']);
                    switch($clientePedido['cliped_pagamentoperiodo']):
                    case 1: //anual
                        date_modify($novociclo, "+1 year");
                    break;
                    case 2: //semestral
                        date_modify($novociclo, "+6 month");
                    break;
                    case 4: //trimestral
                        date_modify($novociclo, "+3 month");
                    break;
                    case 8: //mensal dinheiro
                        date_modify($novociclo, "+1 month");
                    break;
                    endswitch;

                    //ajuste para o ciclo de cobranca
                    $novadatapagamento = date_format($novociclo, 'Y-m-d');
        
                    //atualiza data próximo vencimento no clienteproduto
                    $update_produto = array(
                        'cliped_pagamentoproximo' => $novadatapagamento,
                    );
                    $clientePedidoModel->resetQuery();
                    $clientePedidoModel->where('id_clientepedido', $clientePedido['id_clientepedido']);
                    $clientePedidoModel->set($update_produto);
                    $sucessoproximovencimento = $clientePedidoModel->update();

                    // inicia o serviço de email do sistema
                    $email = \Config\Services::email();
                    $config = [
                        'protocol'  => 'mail',
                        'SMTPHost'  => 'mail.nucleodenegociosweb.com.br',
                        'SMTPUser'  => 'adm@nucleodenegociosweb.com.br',
                        'SMTPPass'  => 'lucr4tivo!',
                        'SMTPPort'  => '587',
                        'wordWrap'  => true,
                        'mailType'  => 'html',
                    ];
                    $email->clear(true);
                    $email->initialize($config);
                    $email->setFrom('adm@nucleodenegociosweb.com.br', 'Núcleo de Negócios WEB . Carol');
                    $email->setTo('lecowd@gmail.com');
                    $email->setSubject('Debug} retorno pagamento asaas fatura #'. $jsonDecode['payment']['externalReference']);
                    // avisa por email com o debug
                    $message = '<html><head></head><body>';
                    $message .= '<table width=100% cellpadding=10 border=0 style="text-align:center;">';
                    $message .= '<tr>';
                    $message .= '<td colspan=2><h3>DEBUG</h3><td>';
                    $message .= '</tr>';
                    $message .= '<tr>';
                    $message .= '<td>';
                        $message .= 'Informação recebida: <br>';
                        foreach ($jsonDecode as $key=>$value):
                            $message .= $key . ' @ ' . $value;
                            $message .= '<br>';
                        endforeach;
                        $message .= '<hr>Dados atualizados: <br>';
                        foreach ($dados as $key=>$value):
                            $message .= $key . ' @ ' . $value;
                            $message .= '<br>';
                        endforeach;
                        $message .= '<hr>Produto: Update no id: ' . 
                        $clientePedido['id_clientepedido'];
                        $message .= '<br>';
                        foreach ($update_produto as $key=>$value):
                            $message .= $key . ' @ ' . $value;
                            $message .= '<br>';
                        endforeach;
                    $message .= '</td>';
                    $message .= '</tr>';
                    $message .= '<tr>';
                    $message .= '<td><center><a href="www.nucleodenegociosweb.com.br/crm/" title="acesse">www.nucleodenegociosweb.com.br/crm/</a></small></center><small><td>';
                    $message .= '</tr>';
                    $message .= '</table>';
                    $message .= '<body></html>';
                    // define template para o email
                    $email->setMessage($message);
                    // envia mensagem
                    $email->send();
                endif;

                // lança valor automaticamente na base faturamento
                $faturamentoModel = new FaturamentoModel();
                $faturamentoModel->insert([
                    'id_cliente'    => $fatura['id_cliente'],
                    'fatcat_nome'   => 'Outros',
                    'fatfor_nome'   => $fatura['fatfor_nome'],
                    'fat_descricao' => $fatura['fat_descricao'],
                    'fat_data'      => $dados['fat_pagamento'],
                    'fat_valor'     => $dados['fat_valor'],
                ]);
            endif;
        }

        // retorno necessário para asaas
        $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
        $code = 200;
        header($protocol . ' ' . $code . ' ' . 'OK');
        http_response_code($code);
        echo '200';
    }




}
