<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UsuarioModel;
// use Config\Services;

class Usuario extends BaseController
{



    /**
     * INDEX } Retorna listagem de todos os usuários
     * 
     * @param false
     * @return string
     */
    public function index() : string {
        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Usuários | Página principal',

        ];

        // retorna todos os usuarios cadastrados
        $usuarioModel = new UsuarioModel();
        $dados['listagemUsuarios'] = $usuarioModel->findAll();

        return view('admin/usuario/usuario-index', $dados);
    }



    /**
     * CADASTRA} Cadastra um novo usuario
     * 
     * @param false
     * @return ? array e string
     */
    public function cadastra() {
        
        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_name' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira um nome de usuário.',
                    ],
                ],
                'input_email' => [
                    'rules' => 'required|valid_email',
                    'errors'    => [
                        'required'  =>  'Insira um e-mail de usuário.',
                        'valid_email' => 'Insira um e-mail válido.',
                    ],
                ],
                'input_pass' => [
                    'rules' => 'required|min_length[6]',
                    'errors'    => [
                        'required'  => 'Insira uma senha.',
                        'min_length' => 'A senha precisa ter pelo menos 6 caracteres.',
                    ],
                ],
                'input_pass_confirm' => [
                    'rules' => 'required|matches[input_pass]',
                    'errors'    => [
                        'required'  => 'Insira novamente a senha.',
                        'matches'   => 'As senhas precisam ser iguais para confirmar.',
                    ],
                ],
            ];

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // agrupa os dados
                $formulario = $this->request->getPost();
                $formulario['input_pass'] = password_hash($formulario['input_pass'],PASSWORD_DEFAULT);
                $dados = [
                    'usu_nome'    => $formulario['input_name'],
                    'usu_cargo'   => '01',
                    'usu_email'   => $formulario['input_email'],
                    'usu_telefone'=> $formulario['input_phone'],
                    'usu_senha'   => $formulario['input_pass'],
                    'usu_ativo'   => '1',
                ];

                // insere na base de dados
                $usuarioModel = new UsuarioModel();

                // insere na base : apresentou erro
                if(!$usuarioModel->save($dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Erro No Cadastrado do Usuario.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Usuario Cadastrado com Sucesso.');
                    return redirect()->to('/usuario');
                endif;
            }
        }

        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Usuários | Cadastre um novo usuario',
        ];

        // constroi pagina
        return view('admin/usuario/usuario-cadastra', $dados);
    }



    /**
     * EDITA} Mostra as informações de um usuário e edita
     * 
     * @param int $id_usuario
     * @return ? array e string
     */
    public function edita(int $id_usuario) {

        // verifica se veio informação por post
        if ($this->request->getMethod() === 'post') {

            // cria regras de formulario
            $rules = [
                'input_name' =>[
                    'rules'     => 'required',
                    'errors'    => [
                        'required'  => 'Insira um nome de usuário.',
                    ],
                ],
                'input_email' => [
                    'rules' => 'required|valid_email',
                    'errors'    => [
                        'required'  =>  'Insira um e-mail de usuário.',
                        'valid_email' => 'Insira um e-mail válido.',
                    ],
                ],
            ];
            // adiciona regas de formulario para senha
            $rules_pass = [
                'input_pass' => [
                    'rules' => 'required|min_length[6]',
                    'errors'    => [
                        'required'  => 'Insira uma senha.',
                        'min_length' => 'A senha precisa ter pelo menos 6 caracteres.',
                    ],
                ],
                'input_pass_confirm' => [
                    'rules' => 'required|matches[input_pass]',
                    'errors'    => [
                        'required'  => 'Insira novamente a senha.',
                        'matches'   => 'As senhas precisam ser iguais para confirmar.',
                    ],
                ],
            ];

            //se vier senha, adiciona para validate
            if($this->request->getPost('input_pass') != ''):
                $rules = array_merge($rules, $rules_pass);
            endif;

            // Validação apresentou erro
            if(!$this->validate($rules)){

                // recarrega a página
                return redirect()->back()->withInput();

            // Validação executou com sucesso
            }else{

                // recebe os dados
                $formulario = $this->request->getPost();
                //se vier com ou sem senha
                if($formulario['input_pass'] != ''):
                    $formulario['input_pass'] = password_hash($formulario['input_pass'],PASSWORD_DEFAULT);    
                    // encapsula dados com senha
                    $dados = [
                        'usu_nome'    => $formulario['input_name'],
                        'usu_cargo'   => '01',
                        'usu_email'   => $formulario['input_email'],
                        'usu_telefone'=> $formulario['input_phone'],
                        'usu_senha'   => $formulario['input_pass'],
                        'usu_ativo'   => '1',
                    ];
                else:
                    // encapsula dados sem senha
                    $dados = [
                        'usu_nome'    => $formulario['input_name'],
                        'usu_cargo'   => '01',
                        'usu_email'   => $formulario['input_email'],
                        'usu_telefone'=> $formulario['input_phone'],
                        'usu_ativo'   => '1',
                    ];
                endif;

                // Atualiza na base de dados
                $usuarioModel = new UsuarioModel();

                // insere na base : apresentou erro
                if(!$usuarioModel->update($formulario['id_usuario'], $dados)):
                    // recarrega a página
                    session()->setFlashdata('msgType', 'error');
                    session()->setFlashdata('msg', 'Esta atualização apresentou erro.');
                    return redirect()->back()->withInput();

                //  insere na base : executou com sucesso
                else:
                    // redireciona a página
                    session()->setFlashdata('msgType', 'success');
                    session()->setFlashdata('msg', 'Usuario Atualizado com sucesso.');
                    return redirect()->to('/usuario/edita/'.$formulario['id_usuario']);
                endif;
            }
        }
        
        // continua se não veio por post

        // define informacoes da pagina
        $dados = [
            'TituloPagina'  =>  'Usuários | Edite seus dados',
        ];

        //var_dump($request);

        // retorna todos os usuarios cadastrados
        $usuarioModel = new UsuarioModel();
        $dados['usuario'] = $usuarioModel->find($id_usuario);

        return view('admin/usuario/usuario-edita', $dados);
    }



    /**
     * DELETA} Exclui um usuário do sistema. Soft delet está ativo
     * 
     * @param int $id_usuario
     * @return object
     */
    public function exclui( int $id_usuario) : object {

        // Exclui usuário        
        $usuarioModel = new UsuarioModel();

        // excluir usuário retornou erro
        if(!$usuarioModel->delete(['id' => $id_usuario])):

            // define informacoes da pagina
            session()->setFlashdata('msgType','danger');
            session()->setFlashdata('msg','Erro ao excluir Usuário.');
            return redirect()->back();

        // excluiu usuario com sucesso
        else:

            // define informacoes da pagina
            session()->setFlashdata('msgType','success');
            session()->setFlashdata('msg','Usuário Excluído com sucesso.');
            return redirect()->back();

        endif;

    }



}