<?php
namespace App\Libraries;

/**
 * INICIE COM
 * $zdg = new Zdg($urlBot,$botAuth,$botHash);
 * // // ou é possível definir
 * // // $zdg->botAuth('');
 * // // $zdg->botHash('');
 * // $zdg->numero('(47)9 9243-4350');
 * // $zdg->mensagem('olá fulano de tal');
 * $zdg->sendMessage();
 * $zdg->botStatus();
 * $zdg->botRemove();
 * $zdg->botCria();
 * $zdg->qrCode();
 * retur array ['status'=>true||false,'message'=>'string'];
 */
class Zdg {


    /**
     * VARIÁVEIS DECLARADAS
     */
    public $numero;
    public $mensagem;
    public $botAuth;
    public $botHash;
    private $botUrl;

    /**
     * CONSTRUTOR
     * 
     */
    function __construct($botUrl, $botAuth = null, $botHash = null) {
        $this->botUrl   = $botUrl;
        $this->botAuth  = $botAuth;
        $this->botHash  = $botHash;
    }
    
    /**
     * SETA AUTH
     */
    public function botAuth($botAuth){
        $this->botAuth = $botAuth;
    }
    
    /**
     * SETA HASH
     */
    public function botHash($botHash){
        $this->botHash = $botHash;
    }
    
    /**
     * SETA MENSAGEM
     */
    public function mensagem($mensagem){
        $this->mensagem = $mensagem;
    }
    
    /**
     * SETA NUMERO + PADRONIZA PARA DISPARO
     * 
     * aplica padrão de disparo ao número
     * remove caracteres
     * '+55'; define ddi
     * pega dois primeiros numeros
     * pega ultimos 8 numeros
     * adiciona 9 a mais quando precisar
     */
    public function numero($numero){
        $whats  = str_replace([' ','(',')','-','.'],'', $numero);
        $ddi    = '55';
        $ddd    = substr($whats,0,2); 
        $numero = substr($whats,-8,strlen($whats)); 
        if($ddd <= '33'):
            $numero = '9' . $numero;
        endif;
        $whats = $ddi.$ddd.$numero;
        $this->numero   = $whats;
    }


    /**
     * FUNÇÃO DE ENVIO DE MENSAGEM
     */
    public function sendMessage() {

        // se faltou alguma informação antes de enviar, breca
        if($this->numero == null ||$this->mensagem == null || $this->botAuth == null || $this->botHash == null):
            return ['status'=>false,'message'=>'Faltou informação para o disparo'];
        endif;

        $curl = curl_init();
        $postData = [
            "user"      => $this->numero,
            "message"   => $this->mensagem,
            "sender"    => $this->botAuth,
            "token"     => $this->botHash,
        ];

        curl_setopt_array($curl, array(
            CURLOPT_URL => rtrim($this->botUrl,'/').'/send-message',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postData),
            CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        return json_decode($response, true);
    }


    /**
     * FUNÇÃO DE STATUS DO BOT
     */
    public function botStatus(){

        // se faltou alguma informação antes de enviar, breca
        if($this->botUrl == null || $this->botAuth == null || $this->botHash == null):
            return ['status'=>false,'message'=>'Faltou informação para o disparo'];
        endif;

        $ch = curl_init( rtrim($this->botUrl,'/') . '/status-sessao' );
        $postData = [
            "id"        => $this->botAuth,
            "token"     => $this->botHash,
        ];        
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode($postData) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$response = json_decode(curl_exec($ch),true);
		curl_close($ch);
        
        return $response;
    }


    /**
     * [ BOT ] . REMOVE SESSAO }
     * remove a sessao aberta no whatsapp
     * após remover criar com outro nome
     * 
     */
    public function botRemove() {

        // se faltou alguma informação antes de enviar, breca
        if($this->botUrl == null || $this->botAuth == null || $this->botHash == null):
            return ['status'=>false,'message'=>'Faltou informação para deletar o bot'];
        endif;

		$ch = curl_init( rtrim($this->botUrl,'/') . '/deletar-sessao' );
        $postData = [
            "id"        => $this->botAuth,
            "token"     => $this->botHash,
        ];
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode($postData) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$response = json_decode(curl_exec($ch),true);
		curl_close($ch);
        
        return $response;
    }


    /**
     * [ BOT ] . CRIA NOVA SESSAO }
     * remove a sessao aberta no whatsapp
     * após remover criar com outro nome
     * 
     */
    public function botCria() {

        // se faltou alguma informação antes de enviar, breca
        if($this->botUrl == null || $this->botAuth == null || $this->botHash == null):
            return ['status'=>false,'message'=>'Faltou informação para criar o bot'];
        endif;
        
		$ch = curl_init( rtrim($this->botUrl,'/') . '/criar-sessao' );
        $postData = [
            "id"        => $this->botAuth,
            "token"     => $this->botHash,
        ];
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode($postData) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$response = json_decode(curl_exec($ch),true);
		curl_close($ch);

        return $response;
    }


    /**
     * [ BOT ] . qrCODE
     * 
     * 
     */
    public function qrCode() {

        // se faltou alguma informação antes de enviar, breca
        if($this->botUrl == null || $this->botAuth == null || $this->botHash == null):
            return ['status'=>false,'message'=>'Faltou informação para criar o bot'];
        endif;

		$path = trim($this->botUrl,'/') . '/lecowd/' . $this->botAuth . '/qrcode.png';
		$imagedata = @file_get_contents($path);
		if($imagedata === false){
			// echo 'QrCode OK';
			// echo "<hr>";
            return ['status'=>true,'message'=>'qrCode ok'];
		}
		else if($imagedata != false){
			$base64 = base64_encode($imagedata);
			// echo '<img src="data:image/png;base64,'.$base64.'">';
			// echo "<hr>";
            return ['status'=>true,'message'=>'<img src="data:image/png;base64,'.$base64.'">'];
		}

    }




}