<?php

namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'usuario';
    protected $primaryKey       = 'id_usuario';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = [
                                    'usu_nome',
                                    'usu_email',
                                    'usu_senha',
                                    'usu_telefone',
                                    'usu_ativo',
                                  ];
    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    


    /**
     * Retorna primeiro registro do email pesquisado
     * 
     * @param string $usu_email
     * @return array
     */
    public function getByEmail(string $usu_email) : array {

        // acessa com first() que retorna NULL caso não exista
        $rq = $this->where('usu_email',$usu_email)->first();
        return !is_null($rq) ? $rq : [];
    }

    
}
