<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<?php
		// avatar
		$avatar = ($cliente['cli_avatar']!='')? base_url('public/'.$cliente['cli_avatar']) : 'https://via.placeholder.com/500x300.png?text=Novo+Cliente';
		?>
		<img src="<?=$avatar?>" class="img-fluid w-100 rounded mt-3" alt="Avatar">
		<h5 class="p-2"><?=$cliente['cli_nome']?></h5>
	</div>
	<div class="col-md-8 shadow rounded-bottom p-5">
		<!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/cliente','Clientes')?></li>
				<li class="breadcrumb-item"><?=anchor('/cliente/painel/'.$cliente['id_cliente'],'Painel do cliente')?></li>
				<li class="breadcrumb-item active" aria-current="page"><?=$cliente['cli_nome']?></li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editar dados de <b><?=$cliente['cli_nome']?></b></h2>
		<?php
		$validation = \Config\Services::validation();
		echo form_open_multipart('cliente/edita/'.$cliente['id_cliente'], 'class="row"');
		echo '<div class="col-md-6">';
			// input avatar
			echo form_label('<br>','input_avatar');
			echo form_upload('input_avatar','', 'class="form-control"');

			// <!-- name Error -->
			if($validation->getError('input_avatar')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_avatar'); ?>
				</div><?php 
			}
			// input name
			echo form_label('<br>','input_name');
			echo form_input('input_name', ($cliente['cli_nome'])? $cliente['cli_nome'] : '','class="form-control" placeholder="Seu nome"');
			// <!-- name Error -->
			if($validation->getError('input_name')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_name'); ?>
				</div><?php 
			}
			// input email
			echo form_label(' ','input_email');
			echo form_input('input_email', ($cliente['cli_email'])? $cliente['cli_email'] : '','class="form-control" placeholder="Seu email"');
			// <!-- email Error -->
			if($validation->getError('input_email')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_email'); ?>
				</div><?php 
			}
			// input email extra
			echo form_label(' ','input_email_extra');
			echo form_input('input_email_extra', ($cliente['cli_email_extra'])? $cliente['cli_email_extra'] : '','class="form-control" placeholder="Emails adicionais, separados por \',\'"');
			// <!-- email Error -->
			if($validation->getError('input_email_extra')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_email_extra'); ?>
				</div><?php 
			}
			echo '<p class="small ps-2 text-secondary">e-mails separados por vírgula , </p>';
			// input phone
			echo form_label(' ','input_phone');
			echo form_input('input_phone', ($cliente['cli_telefone'])? $cliente['cli_telefone'] : '','class="form-control" placeholder="Seu telefone"');
			// <!-- name Error -->
			if($validation->getError('input_phone')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_phone'); ?>
				</div><?php 
			}
			// input cpfcnpj
			echo form_label(' ','input_cpfcnpj');
			echo form_input('input_cpfcnpj', ($cliente['cli_cpfcnpj'])? $cliente['cli_cpfcnpj'] : '','class="form-control" placeholder="Seu CNPJ ou CPF"');
			// <!-- name Error -->
			if($validation->getError('input_cpfcnpj')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_cpfcnpj'); ?>
				</div><?php 
			}
			// input insc_estadual
			echo form_label(' ','input_insc_estadual');
			echo form_input('input_insc_estadual', ($cliente['cli_insc_estadual'])? $cliente['cli_insc_estadual'] : '','class="form-control" placeholder="Inscrição Estadual"');
			// <!-- name Error -->
			if($validation->getError('input_insc_estadual')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_insc_estadual'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-6">';
			echo '<div class="row">';
			echo '<div class="col-md-6">';
			// input endereço
			echo form_label(' ','input_endereco');
			echo form_input('input_endereco', ($cliente['cli_endereco'])? $cliente['cli_endereco'] : '','class="form-control" placeholder="Informe o endereço"');
			// <!-- name Error -->
			if($validation->getError('input_endereco')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_endereco'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-3">';
			// input endereço numero
			echo form_label(' ','input_endereco_numero');
			echo form_input('input_endereco_numero', ($cliente['cli_endereco_numero'])? $cliente['cli_endereco_numero'] : '','class="form-control" placeholder="Número"');
			// <!-- name Error -->
			if($validation->getError('input_endereco_numero')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_endereco_numero'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-3">';
			// input endereço complemento
			echo form_label(' ','input_endereco_compl');
			echo form_input('input_endereco_compl', ($cliente['cli_endereco_compl'])? $cliente['cli_endereco_compl'] : '','class="form-control" placeholder="Complemento"');
			// <!-- name Error -->
			if($validation->getError('input_endereco_compl')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_endereco_compl'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';
			// input bairro
			echo form_label(' ','input_bairro');
			echo form_input('input_bairro', ($cliente['cli_bairro'])? $cliente['cli_bairro'] : '','class="form-control" placeholder="Informe o Bairro"');
			// <!-- name Error -->
			if($validation->getError('input_bairro')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_bairro'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';
			// input municipio
			echo form_label(' ','input_municipio');
			echo form_input('input_municipio', ($cliente['cli_municipio'])? $cliente['cli_municipio'] : '','class="form-control" placeholder="Informe Município"');
			// <!-- name Error -->
			if($validation->getError('input_municipio')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_municipio'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="w-100"></div>';
			echo '<div class="col-md-7">';
			// input estado
			echo form_label(' ','input_estado_uf');
			echo form_input('input_estado_uf', ($cliente['cli_estado_uf'])? $cliente['cli_estado_uf'] : '','class="form-control" placeholder="Informe o Estado (UF)"');
			// <!-- name Error -->
			if($validation->getError('input_estado_uf')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_estado_uf'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-3">';
			// input pais
			echo form_label(' ','input_pais');
			echo form_input('input_pais', ($cliente['cli_pais'])? $cliente['cli_pais'] : '','class="form-control" placeholder="País"');
			// <!-- name Error -->
			if($validation->getError('input_pais')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pais'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';
			// input cep
			echo form_label(' ','input_cep');
			echo form_input('input_cep', ($cliente['cli_cep'])? $cliente['cli_cep'] : '','class="form-control" placeholder="Informe o CEP"');
			// <!-- name Error -->
			if($validation->getError('input_cep')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_cep'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '</div>';
			echo '<div class="col-12 small mt-4 p-2">*Apenas informe uma senha quando para altera-la</div>';
			echo '<div class="row">';
			echo '<div class="col-md-6">';
			// input pass
			echo form_input('input_pass', '','class="form-control" placeholder="Informe a senha"');
			// <!-- erro Error -->
			if($validation->getError('input_pass')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pass'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';			
			// input confirmar pass
			echo form_input('input_pass_confirm', '','class="form-control" placeholder="Repita a mesma senha acima, para Confirmar"');
			// <!-- erro Error -->
			if($validation->getError('input_pass_confirm')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pass_confirm'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '</div>';
			echo '<div class="col-md-6 mt-4">';
			$opt = [
				'0'	=> 'Inativo',
				'1'	=> 'Ativo'
			];
			// input status
			echo form_label(' ','input_ativo');
			echo form_dropdown('input_ativo',$opt,$cliente['cli_ativo'],'class="form-select"');
			// <!-- name Error -->
			if($validation->getError('input_ativo')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_ativo'); ?>
				</div><?php 
			}
			echo '</div>';
		echo '</div>';
			// confirmar envio
		echo '<div class="col-md-12 d-grid mt-3">';
			echo form_hidden('id_cliente',$cliente['id_cliente']);
			echo form_hidden('cli_avatar_atual',$cliente['cli_avatar']);
			echo csrf_field();
			echo form_submit('enviar','Atualizar Cadastro','class="btn btn-primary"');
			echo '<p class="mt-3 small">* Campos necessários</p>';
		echo '</div>';
		echo form_close();
		echo '<br>Criado: ' . $cliente['created_at'];
		echo '<br>Editado: ' . $cliente['updated_at'];
		echo '<br>Excluido: '. $cliente['deleted_at'];
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>