<?= $this->extend('admin/template/template') ?>




<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h3 class="mt-5">Clientes</h3>
		<p>
			<a class="btn btn-light w-100 mb-2" href="<?=base_url('/cliente')?>">Ativos</a><br>
			<a class="btn btn-light w-100 mb-2" href="<?=base_url('cliente?status=0')?>">Inativos</a><br>
			<a class="btn btn-light w-100 mb-2" href="<?=base_url('cliente?status=2')?>">Excluídos</a>
		</p>
	</div>
	<div class="col-md-8 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Clientes</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h3>Listagem <?php
		// verifica referencia
		if(isset($_GET['status'])):
			$tipoDe = $_GET['status'];
		else:
			$tipoDe = null;
		endif;
		// filtra o tipo de cliente listado
        if($tipoDe == '0'):
            echo 'Inativos'; // inativo
        elseif($tipoDe == '2'):
            echo 'Excluídos'; // excluído
        else:
            echo 'Ativos'; // ativo
        endif;
		?></h3>
		<hr>
		<?=anchor('/cliente/cadastra','Novo Cliente', 'class="btn btn-outline-success mt-3 mb-3"'); ?>
		<div class="table-responsive">
			<table class="table">
				<thead class="table-light">
					<tr>
						<th>ID</th>
						<th>Nome</th>
						<th>E-Mail</th>
						<th>Ação</th>
					</tr>
				</thead>
				<tbody>
				<?php
				if($listagemClientes):
				foreach($listagemClientes as $cliente):
					echo '<tr>';
					echo '<td>' . $cliente['id_cliente'] . '</td>';
					echo '<td>' . anchor('cliente/painel/'.$cliente['id_cliente'],$cliente['cli_nome']) . '</td>';
					echo '<td>' . $cliente['cli_email'] . '</td>';
					echo '<td class="small">';
					echo anchor('cliente/edita/'.$cliente['id_cliente'], '<span class="material-symbols-outlined">edit_note</span>') . ' | ';
					echo anchor('cliente/exclui/'.$cliente['id_cliente'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
					echo '</td>';
					echo '</tr>';
				endforeach;
				endif;
				?>
				</tbody>
			</table>
		</div>
		<?php
		// paginação
		echo $pager->links('default','default_full');
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>




<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>