<?= $this->extend('admin/template/template') ?>



<?= $this->section('css') ?>
<style type="text/css">
    input::placeholder {
        color:#c2c6c9!important;
    }
</style>
<?= $this->endSection() ?>



<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
        <h5 class="mt-5"><?=$cliente['cli_nome']?></h5>
        <?php
		// avatar
		$avatar = ($cliente['cli_avatar']!='')? base_url('public/'.$cliente['cli_avatar']) : 'https://via.placeholder.com/500x300.png?text=Novo+Cliente';
		?>
		<img src="<?=$avatar?>" class="img-fluid w-100 rounded mt-3" alt="Avatar">
        <p><?=anchor('cliente/avatarexcluir/'.$cliente['id_cliente'],'Excluir Avatar', 'class="btn btn-link btn-confirma-excluir"')?></p>
        <p><?=anchor('cliente/edita/'.$cliente['id_cliente'],'Editar Cliente', 'class="btn btn-link"')?></p>
        
	</div>
    <!-- Dados do cliente -->
	<div class="col-md-8 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/cliente','Clientes')?></li>
				<li class="breadcrumb-item active" aria-current="page">Painel do cliente</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
        <a id='clientePainel'></a>
		<h2>Painel de <b><?php $cli_nome = explode(' ',$cliente['cli_nome']); echo $cli_nome[0]; ?></b></h2>
        <hr>
        <div class="row">
            <?php
            echo '<div class="col-md-6 text-break">';
                // nome
                echo $cliente['cli_nome'] . ' ';
                // emails
                echo '&lt;' . $cliente['cli_email'] . '&gt;<br>';
                // emails extra
                echo $cliente['cli_email_extra'] . '<br>';
                // telefone
                echo $cliente['cli_telefone'] . '<br>';
                // notificar por whatsapp
                echo anchor('cliente/lembreteWhats/'.$cliente['id_cliente'],'Notificar no Whatsapp','class="btn-confirma-excluir"') . '<br><br>';
                // painel do cliente | usa <a> encode não funciona com ci4
                echo '<a href="' . base_url() . '/loginCliente/fatura/' . $cliente['id_cliente'] . ':aois:' . urlencode(urilencode($cliente['cli_senha'])) . ' "target="_blank">Painel do Cliente</a><br>';
                echo '<br><br>';
                // id asaas
                echo '<div class="text-secondary">ID ASAAS: ';
                if(empty($cliente['id_asaas'])):
                    echo anchor('cliente/ativar/'.$cliente['id_cliente'],'Ativar Cliente','class="btn btn-link btn-confirma-excluir"');
                else:
                    echo $cliente['id_asaas'];
                endif;
                echo '</div>';
            echo '</div>';
            echo '<div class="col-md-6">';
                // cpf / cnpj
                echo 'CPF/CNPJ: ' . $cliente['cli_cpfcnpj'] . '<br>';
                if($cliente['cli_insc_estadual']):
                    echo 'IE: ' . $cliente['cli_insc_estadual'] . '<br>';
                endif;
                // endereço
                echo 'Endereço: ' . $cliente['cli_endereco'] . ', ';
                echo 'n°. ' . $cliente['cli_endereco_numero'] . ' ';
                echo $cliente['cli_endereco_compl'] . '<br>';
                echo '' . $cliente['cli_bairro'] . ' - ';
                echo '' . $cliente['cli_municipio'] . ' / ';
                echo '' . $cliente['cli_estado_uf'] . ' | ';
                echo '' . $cliente['cli_pais'] . '<br>';
                echo '' . $cliente['cli_cep'] . '<br>';
                echo '<div class="small pt-3">';
                // status cliente
                switch($cliente['cli_ativo']):
                    case '1' : $cliente['cli_ativo'] = 'Ativo';
                        break;

                    case '0' : $cliente['cli_ativo'] = 'Inativo';
                        break;

                    default : $cliente['cli_ativo'] = $cliente['cli_ativo'];
                endswitch;
                echo 'Status: ' . $cliente['cli_ativo'] . '<br>';
                $created_at = new DateTime($cliente['created_at'], new DateTimeZone('America/Sao_Paulo'));
                echo 'Criação: ' . $created_at->format('d/m/Y à\s H:m:i') . '<br>';
                $updated_at = new DateTime($cliente['updated_at'], new DateTimeZone('America/Sao_Paulo'));
                echo 'Atualizado: ' . $updated_at->format('d/m/Y à\s H:m:i') . '<br>';
                if($cliente['deleted_at']):
                    $deleted_at = new DateTime($cliente['deleted_at'], new DateTimeZone('America/Sao_Paulo'));
                    echo 'Excluido: '. $deleted_at . '<br>';
                endif;
                echo '</div>';
            echo '</div>';
            ?>
        </div>

        <!-- Faturas -->
        <a id="clienteFatura"></a>
        <h2 class="mt-5">Faturas abertas (<?=count($faturaAberta);?>)</h2>
        <?= anchor('fatura/cadastra/'.$cliente['id_cliente'],'Nova Fatura','class="btn btn-sm btn-outline-success"'); ?>
        <?php if($faturaAberta): ?>
        <div class="table-responsive mt-4">
            <table class="table">
                <thead class="table-light">
                    <tr>
                        <th>Id</th>
                        <th>Status</th>
                        <th>Descição</th>
                        <th>Vencimento</th>
                        <th>Valor</th>
                        <th>Contabil</th>
                        <th>Ação</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach($faturaAberta as $fa):
                        $fa['fat_vencimento'] = new DateTime($fa['fat_vencimento']);
                        echo '<tr>';
                        echo '<td>' . anchor('/fatura/edita/'.$fa['id_fatura'],$fa['id_fatura']) . '</td>';
                        // input status
                        switch($fa['fat_status']):
                            case 'Pago': echo '<td><span class="badge text-bg-light">Pago</span> </td>';
                            break;
                            case 'Aberto': echo '<td><span class="badge text-bg-success">Aberto</span> </td>';
                            break;
                            case 'Cancelado': echo '<td><span class="badge text-bg-secondary">Cancelado</span> </td>';
                            break;
                            default: echo '<td>'.$fa['fat_status'] . '</td>';
                        endswitch;
                        echo '<td>'.$fa['fat_descricao'] . '</td>';
                        echo '<td>'.$fa['fat_vencimento']->format('d/m/Y') . '</td>';
                        echo '<td nowrap>R$ '.$fa['fat_valor'] . '</td>';
                        echo '<td>';
                        if( $fa['fat_status'] != "Cancelado" ):
                            if($fa['id_contabil_s']):
                                echo anchor('contabil/nfse/'.$fa['id_fatura'].'/1', 'Consulta').'<br>';
                            else:
                                echo anchor('contabil/nfse/'.$fa['id_fatura'].'/1', 'Gerar', 'class="btn-confirma-excluir"');
                            endif;
                        else:
                            echo '<td class="text-secondary small">'.$fa['fat_status'].'</td>';
                        endif;
                        echo '</td>';
                        echo '<td nowrap>';
                        echo anchor('fatura/edita/'.$fa['id_fatura'], '<span class="material-symbols-outlined">edit_note</span>') . ' | ';
                        echo anchor('fatura/exclui/'.$fa['id_fatura'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
                        echo '</td>';
                        echo '</tr>';
                    endforeach;
                    ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>

        <!-- TABS DE CONTEUDO -->
        <nav>
        <div class="nav nav-tabs mt-5" id="nav-tab" role="tablist">
            <button class="nav-link active" id="nav-home-tab" data-bs-toggle="tab" data-bs-target="#nav-home" type="button" role="tab" aria-controls="nav-home" aria-selected="true">Detalhes <small>( <?=count($clienteDetalhe)?> )</small></button>
            <button class="nav-link" id="nav-contact-tab" data-bs-toggle="tab" data-bs-target="#nav-contact" type="button" role="tab" aria-controls="nav-contact" aria-selected="false">Orçamentos <small>( <?=count($listagemOrcamento)?> )</small></button>
            <button class="nav-link" id="nav-profile-tab" data-bs-toggle="tab" data-bs-target="#nav-profile" type="button" role="tab" aria-controls="nav-profile" aria-selected="false">Pedidos <small>( <?=count($clientePedido)?> )</small></button>
            <button class="nav-link" id="nav-historico-tab" data-bs-toggle="tab" data-bs-target="#nav-historico" type="button" role="tab" aria-controls="nav-historico" aria-selected="false">Histórico de Faturas <small>( <?=count($faturaFechada)?> )</small></button>
            <button class="nav-link" id="nav-zpro-tab" data-bs-toggle="tab" data-bs-target="#nav-zpro" type="button" role="tab" aria-controls="nav-zpro" aria-selected="false">Z-pró <small><?=( $zpro['status'] == 'active' )? '( Ativo )' : '( Inativo )' ?></small></button>
        </div>
        </nav>
        <div class="tab-content" id="nav-tabContent">

            <!-- Detalhes -->
            <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab" tabindex="0">
                <a id="clienteDetalhe"></a>
                <?php
                echo anchor('clienteDetalhe/cadastra/'.$cliente['id_cliente'],'Novo Detalhe', 'class="btn btn-outline-success mb-3 mt-3"');
                if($clienteDetalhe):
                    $clidet_publico = [];
                    // se detalhes privado
                    foreach($clienteDetalhe as $detalhe):
                        if($detalhe['clidet_publico']==1):
                            $clidet_publico[] = [
                                'id_clientedetalhe'   => $detalhe['id_clientedetalhe'],
                                'clidet_atributo'   => $detalhe['clidet_atributo'],
                                'clidet_descricao'  => $detalhe['clidet_descricao'],
                            ];
                        else:
                            echo '<hr>';
                            echo '<div class="d-flex small">';
                            echo '<div class="me-auto">' . $detalhe['clidet_atributo'] . '</div>';
                            echo '<div>';
                            echo anchor('clienteDetalhe/edita/'.$detalhe['id_clientedetalhe'],'Editar');
                            echo '<div class="vr ms-3 me-3"></div>';
                            echo anchor('clienteDetalhe/exclui/'.$detalhe['id_clientedetalhe'],'Excluir','class="btn-confirma-excluir"');
                            echo '<div class="vr ms-3 me-3"></div>';
                            echo ' <span class="badge text-bg-info small">Privado</span>';
                            echo '</div>';
                            echo '</div>';
                            echo '<br>';
                            echo $detalhe['clidet_descricao'];
                        endif;
                    endforeach;
                    // se detalhes publico
                    foreach($clidet_publico as $publico):
                        echo '<hr>';
                        echo '<div class="d-flex small">';
                        echo '<div class="me-auto clidet_atributo">' . $publico['clidet_atributo'] . '</div>';
                        echo '<div class="clidet_acao">';
                        echo anchor('clienteDetalhe/edita/'.$publico['id_clientedetalhe'],'Editar');
                        echo '<div class="vr ms-3 me-3"></div>';
                        echo anchor('clienteDetalhe/exclui/'.$publico['id_clientedetalhe'],'Excluir','class="btn-confirma-excluir"');
                        echo '<div class="vr ms-3 me-3"></div>';
                        echo ' <span class="badge text-bg-primary small">Público</span>';
                        echo '</div>';
                        echo '</div>';
                        echo '<br>';
                        echo $publico['clidet_descricao'];
                    endforeach;
                else:
                    echo '<hr>';
                    echo '<p class="text-secondary">Sem detalhes</p>';
                endif;
                ?>
            </div>
            
            <!-- Orçamentos -->
            <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab" tabindex="0">
                <?php
                echo anchor('/painel','Novo Orçamento', 'class="btn btn-outline-success mb-3 mt-3"');
                // listage orcamentos em aberto
                if($listagemOrcamento):
                    foreach($listagemOrcamento as $o):
                        echo '<div class="d-flex justify-content-between border-bottom pt-3 pb-2">';
                            echo '<div class="pb-2">';
                            echo '<small>';
                            echo $o['id_orcamento'] . ' | ';
                            echo '</small>';
                            echo anchor('orcamento/edita/' . $o['id_orcamento'], $o['orc_titulo']);
                            echo '</div>';
                            echo '<div class="pb-2">';
                            echo ucfirst($o['orc_status']);
                            echo '</div>';
                            echo '<div class="pb-2">';
                            echo 'enviar mensagem';
                            echo '</div>';
                        echo '</div>';
                    endforeach;
                else:
                    echo '<p class="mb-3 small">Nenhum orçamento em aberto. ' . anchor('orcamento','ver todos') . '</p>';
                endif;
                ?>
            </div>

            <!-- Produtos -->
            <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab" tabindex="0">
                <a id="clientePedido"></a>
                <?php
                echo anchor('clientePedido/cadastra/'.$cliente['id_cliente'],'Novo Pedido','class="btn btn-outline-success mb-3 mt-3"');
                echo '<br>';
                if($clientePedido):
                    $i = 0;
                    foreach($clientePedido as $pedido):
                        switch($pedido['cliped_status']):
                            case 0 : $pedido['cliped_status'] = '<span class="badge rounded-pill text-bg-secondary">Inativo</span>';
                                break;
                            case 1 : $pedido['cliped_status'] = '<span class="badge rounded-pill text-bg-success">Ativo</span>';
                                break;
                            default: $pedido['cliped_status'];
                        endswitch;
                        echo '<hr>';
                        echo '<div class="d-flex small">';
                        echo '<div class="me-auto"><a class="btn btn-link" data-bs-toggle="collapse" href="#collapseInfoPedido'.$i.'" role="button" aria-expanded="false" aria-controls="collapseInfoPedido'.$i.'">' . $pedido['pro_nome']  . ' . ' . $pedido['cliped_dominio'] . '</a></div>';
                        echo '<div>';
                        echo anchor('clientePedido/edita/'.$pedido['id_clientepedido'],'Editar');
                        echo '<div class="vr ms-3 me-3"></div>';
                        echo anchor('clientePedido/exclui/'.$pedido['id_clientepedido'],'Excluir','class="btn-confirma-excluir"');
                        echo '<div class="vr ms-3 me-3"></div>';
                        echo $pedido['cliped_status'];
                        echo '</div>';
                        echo '</div>';
                        echo '<div class="collapse" id="collapseInfoPedido'.$i.'">';
                        echo 'Domínio: ' . $pedido['cliped_dominio'] . ' | ';
                        echo 'Valor: ' . $pedido['cliped_valor'] . '<br>';
                        echo 'Login: ' . $pedido['cliped_login'] . ' | ';
                        echo 'Senha: ' . $pedido['cliped_senha'] . '<br>';
                        echo 'Início: ' . $pedido['cliped_datainicio'] . ' | ';
                        echo 'Próximo vencimento: ' . $pedido['cliped_pagamentoproximo'] . '<br>'; 
                        $pedido['created_at'] = new DateTime($pedido['created_at'], new DateTimeZone('America/Sao_Paulo'));
                        $pedido['updated_at'] = new DateTime($pedido['updated_at'], new DateTimeZone('America/Sao_Paulo'));
                        if(isset($pedido['deleted_at'])):
                            $pedido['deleted_at'] = new DateTime($pedido['deleted_at'], new DateTimeZone('America/Sao_Paulo'));
                            $pedido['deleted_at'] = $pedido['deleted_at']->format('d/m/Y');
                        else:
                            $pedido['deleted_at'] = '-';
                        endif;
                        echo '<p class="small mt-3">';
                        echo 'Inicio em: ' . $pedido['created_at']->format('d/m/Y') . ' | ';
                        echo 'Última atualização: ' . $pedido['updated_at']->format('d/m/Y') . ' | ';
                        echo 'Data de exclusão: ' . $pedido['deleted_at'];
                        echo '</p>'; 
                        echo '<p class="small mt-3"><b>Informações sobre o produto: </b>';
                        echo $pedido['pro_nome'] . ' | ';
                        echo 'Setup: ' . $pedido['pro_valor'] . ' | ';
                        echo 'Mensalidade: ' . $pedido['pro_valormensal'];
                        echo '</p>';
                        echo anchor('cliente/bemvindo/'.$pedido['id_clientepedido'], 'Enviar Bem-vindo', 'class="btn btn-sm btn-outline-secondary"');                            
                        echo '</div>';
                        $i++;
                    endforeach;
                else:
                    echo '<hr>';
                    echo '<p class="text-secondary">Sem detalhes</p>';
                endif;
                ?>
            </div>

            <!-- Histórico de faturas -->
            <div class="tab-pane fade" id="nav-historico" role="tabpanel" aria-labelledby="nav-historico-tab" tabindex="0">
                <div class="table-responsive">
                <table class="table">
                    <thead class="table-light">
                        <tr>
                            <th>Id</th>
                            <th>Status</th>
                            <th>Descição</th>
                            <th>Pagamento</th>
                            <th>Valor</th>
                            <th>Contabil</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if($faturaFechada):
                        foreach($faturaFechada as $f):
                            if($f['fat_pagamento'] != null):
                                $f['fat_pagamento'] = new DateTime($f['fat_pagamento']);
                                $f['fat_pagamento'] = $f['fat_pagamento']->format('d/m/Y');
                            endif;
                            echo '<tr>';
                            echo '<td>' . anchor('/fatura/edita/'.$f['id_fatura'],$f['id_fatura']) . '</td>';
                            // input status
                            switch($f['fat_status']):
                                case 'Pago': echo '<td><span class="badge text-bg-light">Pago</span> </td>';
                                break;
                                case 'Aberto': echo '<td><span class="badge text-bg-success ">Aberto</span> </td>';
                                break;
                                case 'Cancelado': echo '<td><span class="badge text-bg-secondary">Cancelado</span> </td>';
                                break;
                                default: echo '<td>'.$f['fat_status'] . '</td>';
                            endswitch;
                            echo '<td>' . $f['fat_descricao'] . '</td>';
                            echo '<td>' . $f['fat_pagamento'] . '</td>';
                            echo '<td nowrap>R$ '.$f['fat_valor'] . '</td>';
                            if( $f['fat_status'] != "Cancelado" ){
                                if($f['id_contabil_s']):
                                    echo '<td>'.anchor('contabil/nfse/'.$f['id_fatura'].'/1', $f['con_status'], 'class="btn-confirma-excluir text-success"').'<br>';
                                else:
                                    echo '<td>'.anchor('contabil/nfse/'.$f['id_fatura'].'/1', 'Gerar', 'class="btn-confirma-excluir text-primary"').'</td>';
                                endif;
                            }else{
                                echo '<td class="text-secondary small">'.$f['fat_status'].'</td>';
                            }
                            echo '<td nowrap>';
                            echo anchor('fatura/edita/'.$f['id_fatura'], '<span class="material-symbols-outlined">edit_note</span>') . ' | ';
                            echo anchor('fatura/exclui/'.$f['id_fatura'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
                            echo '</td>';
                            echo '</tr>';
                        endforeach;
                        else:
                            echo '<td colspan="5">nada encontrado</td>';
                        endif;
                        ?>
                    </tbody>
                </table>
                </div>
            </div>

            <!-- zPró -->
            <div class="tab-pane fade" id="nav-zpro" role="tabpanel" aria-labelledby="nav-zpro-tab" tabindex="0">
                <?php
                $validation = service('validation');
                echo form_open('cliente/ativarZpro/' . $cliente['id_cliente'], 'class="row justify-content-center"');
                
                echo '<div class="col-md-6 p-5 mt-5 shadow rounded">';
              
                echo form_label('Url z-pró api: ','clizpr_url', ['class'=>'mt-3']);
                echo form_input('clizpr_apiUrl', $zpro['clizpr_apiUrl'],'class="form-control" placeholder="https://zproAPI.seusiteaqui.com.br"');
                if($validation->getError('clizpr_apiUrl')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('clizpr_apiUrl');
                    echo '</div>';
                }

                echo form_label('clizpr_token: ','clizpr_token', ['class'=>'mt-3']);
                echo form_input('clizpr_token', $zpro['clizpr_token'],'class="form-control" placeholder="G$QdQ=m=J?r0yttyyty#mC;uhdfGA1Ls&M0B!+14&BdqCB~YIl1&I!s36rR5$}3t"');
                if($validation->getError('clizpr_token')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('clizpr_token');
                    echo '</div>';
                }

                echo '<p class="mt-3 small">' . anchor( 'https://zpro.passaportezdg.com.br/super-admin-multi-tenant/api', 'Ver documentação Z-Pró', 'target="_blank" follow="nofollow" ') .'</p>';

                echo '<hr>';
                
                echo form_label('Habilitar Teste: ','trial', ['class'=>'mt-3']);
                $opTrial = [
                    'enabled'  => 'Sim',
                    'disabled' => 'Não',
                ];
                echo form_dropdown('trial', $opTrial, $zpro['trial'],'class="form-select"');
                if($validation->getError('trial')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('trial');
                    echo '</div>';
                }

                echo form_label('Dias de teste: ','trialPeriod', ['class'=>'mt-3']);
                echo form_input('trialPeriod', $zpro['trialPeriod'],'class="form-control" placeholder="3"');
                if($validation->getError('trialPeriod')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('trialPeriod');
                    echo '</div>';
                }

                echo '</div>';
                echo '<div class="col-md-6 p-5 mt-5 shadow rounded">';

                echo form_label('Id Tenant: ','id_tenant', ['class'=>'mt-3']);
                echo form_input('id_tenant', $zpro['id_tenant'],'class="form-control" placeholder="Empresa Exemplo"');
                if($validation->getError('id_tenant')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('id_tenant');
                    echo '</div>';
                }
                echo '<p class="text-secondary small">Atenção: Adicione a ID da tenant se ela já existir no Z-Pró, senão deixe em branco.</p>';

                echo form_label('Status: ','status', ['class'=>'mt-3']);
                $opStatus = [
                    'active'    => 'Ativo',
                    'inactive'  => 'Suspenso',
                ];
                echo form_dropdown('status', $opStatus, $zpro['status'],'class="form-select"');
                if($validation->getError('status')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('status');
                    echo '</div>';
                }

                echo form_label('Nome da Empresa: ','name', ['class'=>'mt-3']);
                echo form_input('name', $zpro['name'],'class="form-control" placeholder="Empresa Exemplo"');
                if($validation->getError('name')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('name');
                    echo '</div>';
                }

                echo form_label('Total de usuários: ','maxUsers', ['class'=>'mt-3']);
                echo form_input('maxUsers', $zpro['maxUsers'],'class="form-control" placeholder="3"');
                if($validation->getError('maxUsers')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('maxUsers');
                    echo '</div>';
                }

                echo form_label('Total de Conexões: ','maxConnections', ['class'=>'mt-3']);
                echo form_input('maxConnections', $zpro['maxConnections'],'class="form-control" placeholder="3"');
                if($validation->getError('maxConnections')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('maxConnections');
                    echo '</div>';
                }

                // echo form_label('Aceite os termos: ','acceptTerms', ['class'=>'mt-3']);
                // $opTermos = [
                //     'false' => 'Não Aceito',
                //     'true'  => 'Aceito',
                // ];
                // echo form_dropdown('status', $opStatus, $zpro['status'],'class="form-select"');
                // if($validation->getError('acceptTerms')) {
                //     echo '<div class="alert alert-danger mt-2">';
                //     echo $validation->getError('acceptTerms');
                //     echo '</div>';
                // }

                echo form_label('Email: ','email', ['class'=>'mt-3']);
                echo form_input('email', $zpro['email'],'class="form-control" placeholder="user@example.com"');
                if($validation->getError('email')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('email');
                    echo '</div>';
                }

                echo form_label('Senha: ','password', ['class'=>'mt-3']);
                echo form_input('password', $zpro['password'],'class="form-control" placeholder="securePassword123!"');
                if($validation->getError('password')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('password');
                    echo '</div>';
                }

                echo form_label('Nome do Cliente: ','userName', ['class'=>'mt-3']);
                echo form_input('userName', $zpro['userName'],'class="form-control" placeholder="Pedro Bastos"');
                if($validation->getError('userName')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('userName');
                    echo '</div>';
                }

                echo form_label('Identificação do sistema: ','identity', ['class'=>'mt-3']);
                echo form_input('identity', $zpro['identity'],'class="form-control" placeholder="07122255533"');
                if($validation->getError('identity')) {
                    echo '<div class="alert alert-danger mt-2">';
                    echo $validation->getError('identity');
                    echo '</div>';
                }

                // echo form_label('Perfil: ','profile', ['class'=>'mt-3']);
                // $opProfile = [
                //     'admin' => 'Administrador',
                //     'user'  => 'Usuário',
                // ];
                // echo form_dropdown('profile', $opProfile, $zpro['profile'],'class="form-select"');
                // if($validation->getError('profile')) {
                //     echo '<div class="alert alert-danger mt-2">';
                //     echo $validation->getError('profile');
                //     echo '</div>';
                // }

                echo '</div>';

                echo '<div class="col-md-10 text-center">';
                    echo csrf_field();
                    echo form_hidden('id_cliente', $cliente['id_cliente']);
                    echo form_submit('enviar','Atualizar Servidor','class="btn btn-primary mt-4"');

                    echo anchor('cliente/alteraStatus/'.$cliente['id_cliente'], 'Alternar Status Da Tenant', 'class="btn btn-sm btn-warning mt-4"');
                echo '</div>';
                ?>
            </div>

        </div><!-- fim tab-content -->
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>


<?= $this->section('js') ?>
<script>

// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});


// ativa aba de acordo com id
$(document).ready(function () {
    const hash = window.location.hash; // Captura a parte da URL após #
    if (hash) {
        const targetTab = hash.replace('#', ''); // Remove o #
        const tabToActivate = $(`#nav-tab button[data-bs-target="#${targetTab}"]`);

        if (tabToActivate.length) {
            tabToActivate.tab('show'); // Ativa a aba correspondente
        }
    }

    // Atualiza a URL ao trocar de aba
    $('#nav-tab button').on('shown.bs.tab', function (e) {
        const target = $(e.target).data('bs-target'); // Obtém o ID da aba
        history.replaceState(null, null, target); // Atualiza a URL
    });
});
</script>
<?= $this->endSection() ?>