<?= $this->extend('admin/template/template') ?>


<?= $this->section('css') ?>
<link rel="stylesheet" type="text/css" href="<?=base_url('public/assets/css')?>/jquery.datetimepicker.min.css" >
<?= $this->endSection() ?>


<?= $this->section('js') ?>
<script src="<?=base_url('public/assets/js')?>/jquery.datetimepicker.full.min.js"></script>
<script>
jQuery('#datetimepicker1').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker2').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
</script>
<?= $this->endSection() ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-6 shadow rounded-bottom p-5">
		<?php

		//se vier com cliente no url (id)
		if(!isset($cliente[0])):
		?>
			<!-- > Breadcrumb -->
			<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><?=anchor('/cliente/painel/'.$cliente['id_cliente'],'Voltar')?></li>
				</ol>
			</nav>
			<!-- # end breadcrumb -->
			<h2>Novo Pedido de <?=$cliente['cli_nome']?></h2>
			<?php
			$validation = \Config\Services::validation();
			echo form_open('clientePedido/cadastra/'.$cliente['id_cliente'], 'class="row justify-content-center"');
			echo form_hidden('id_cliente',$cliente['id_cliente']);

		// se vier sem o cliente no url (new)
		else:
			echo '<h2>Novo Pedido</h2>';
			$validation = \Config\Services::validation();
			echo form_open('clientePedido/cadastra/new', 'class="row justify-content-center"');
			echo '<div class="col-md-10 mb-3">';
			// input ids
			echo form_label('Selecione o Cliente*', 'input_cliente');
			$opts = [];
			foreach($cliente as $c):
				$opts[$c['id_cliente']]	=	$c['cli_nome'];
			endforeach;
			echo form_dropdown('input_cliente', $opts, set_value('input_cliente'),'class="form-select"');
			// <!-- descricao Error -->
			if($validation->getError('input_cliente')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_cliente'); ?>
				</div><?php 
			}
			echo '</div>';
			echo form_hidden('id_cliente','new');
		endif;

		echo '<div class="col-md-6 mb-3">';
			// select produto
			echo form_label('Produto: ','input_produto');
			$produtoList = [];
			$produtoList = ['' => 'Selecione'];
			foreach($produto as $p):
				$produtoList[$p['id_produto']] = $p['pro_nome'] ;
			endforeach;
			echo form_label('<br>','input_produto');
			echo form_dropdown('input_produto', $produtoList, set_value('input_produto'), 'class="form-select"');
			// <!-- produto Error -->
			if($validation->getError('input_produto')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_produto'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="w-100"></div>';
		echo '<div class="col-md-5 mb-3">';
			// input domínio
			echo form_label('Domínio: ','input_dominio');
			echo form_input('input_dominio', set_value('input_dominio'),'class="form-control" placeholder="Domínio*"');
			// <!-- dominio Error -->
			if($validation->getError('input_dominio')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_dominio'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-4 mb-3">';
			// input login
			echo form_label('Login: ','input_login');
			echo form_input('input_login', set_value('input_login'),'class="form-control" placeholder="Login*"');
			// <!-- login Error -->
			if($validation->getError('input_login')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_login'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input senha
			echo form_label('Senha:','input_senha');
			echo form_input('input_senha', set_value('input_senha'),'class="form-control" placeholder="Senha*"');
			// <!-- senha Error -->
			if($validation->getError('input_senha')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_senha'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input valor
			echo form_label('Valor: ','input_valor');
			echo form_input('input_valor', set_value('input_valor'),'class="form-control" placeholder="Valor*"');
			// <!-- senha Error -->
			if($validation->getError('input_valor')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_valor'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input datainicio
			echo form_label('Data Início: ','input_datainicio');
			echo form_input('input_datainicio', set_value('input_datainicio'),'class="form-control" placeholder="Data Inicio*" id="datetimepicker1"');
			// <!-- datainicio Error -->
			if($validation->getError('input_datainicio')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_datainicio'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input pagamentoproximo
			echo form_label('Pagamento Próximo: ','input_pagamentoproximo');
			echo form_input('input_pagamentoproximo', set_value('input_pagamentoproximo'),'class="form-control" placeholder="Próximo pagamento*" id="datetimepicker2"');
			// <!-- pagamento proximo Error -->
			if($validation->getError('input_pagamentoproximo')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pagamentoproximo'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input pagamentoperiodo
			$pgtoPeriodo = [
				'8'    =>  'Mensal',
				'4'    =>  'Trimestral',
				'2'    =>  'Semestral',
				'1'    =>  'Anual',
			];
			echo form_label('Período: ','input_pagamentoperiodo');
			echo form_dropdown('input_pagamentoperiodo', $pgtoPeriodo, set_value('cliped_pagamentoperiodo'), 'class="form-select"');
			// <!-- pagamento periodo Error -->
			if($validation->getError('input_pagamentoperiodo')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pagamentoperiodo'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-4 mb-3">';
			// select status
			$statsOpt = [
				'1'	=> 'Ativo',
				'0'	=> 'Inativo',
			];
			echo form_label('Status:','input_status');
			echo form_dropdown('input_status',$statsOpt, set_value('input_status'), 'class="form-select"' );
			// <!-- status Error -->
			if($validation->getError('input_status')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_status'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-12 mt-3">';
			// confirmar envio
			echo csrf_field();
			echo form_submit('enviar','Cadastrar Pedido','class="btn btn-primary w-100 mt-3"');
			echo '<p class="mt-2 small">* Campos necessários</p>';
		echo '</div>';

		echo form_close();
		?>
	</div>

</div>
</div>
</section>
<?= $this->endSection() ?>