<?= $this->extend('admin/template/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" type="text/css" href="<?=base_url('public/assets/css')?>/jquery.datetimepicker.min.css" >
<?= $this->endSection() ?>



<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">

	<div class="col-md-6 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/cliente/painel/'.$cliente['id_cliente'],'Voltar')?></li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editar Pedido de <?=$cliente['cli_nome']?></h2>
		<?php
		
		$validation = \Config\Services::validation();

		echo form_open('clientePedido/edita/'.$clientePedido['id_clientepedido'], 'class="row justify-content-center"');
		echo '<div class="col-md-6 mb-3">';
			// select produto
			$produtoList = [];
			foreach($produto as $p):
				$produtoList[$p['id_produto']] = $p['pro_nome'] ;
			endforeach;
			echo form_label('Produto contratado:','input_produto');
			echo form_dropdown('input_produto', $produtoList, $clientePedido['id_produto'], 'class="form-select" disabled');
			// <!-- produto Error -->
			if($validation->getError('input_produto')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_produto'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="w-100"></div>';
		echo '<div class="col-md-5 mb-3">';
			// input domínio
			echo form_label('Domínio: ','input_dominio');
			echo form_input('input_dominio', ($clientePedido['cliped_dominio'])? $clientePedido['cliped_dominio'] : '','class="form-control" placeholder="Domínio*"');
			// <!-- dominio Error -->
			if($validation->getError('input_dominio')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_dominio'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-4 mb-3">';
			// input login
			echo form_label('Login: ','input_login');
			echo form_input('input_login', ($clientePedido['cliped_login'])? $clientePedido['cliped_login'] : '','class="form-control" placeholder="Login*"');
			// <!-- login Error -->
			if($validation->getError('input_login')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_login'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input senha
			echo form_label('Senha: ','input_senha');
			echo form_input('input_senha', ($clientePedido['cliped_senha'])? $clientePedido['cliped_senha'] : '','class="form-control" placeholder="Senha*"');
			// <!-- senha Error -->
			if($validation->getError('input_senha')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_senha'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-6 mb-3">';
			// input valor
			echo form_label('Valor: ','input_valor');
			echo form_input('input_valor', ($clientePedido['cliped_valor'])? $clientePedido['cliped_valor'] : '','class="form-control" placeholder="Valor*"');
			// <!-- senha Error -->
			if($validation->getError('input_valor')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_valor'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="w-100"></div>';
		echo '<div class="col-md-4 mb-3">';
			// input datainicio
			echo form_label('Data de assinatura:','input_datainicio');
			echo form_input('input_datainicio', ($clientePedido['cliped_datainicio'])? $clientePedido['cliped_datainicio'] : '','class="form-control" placeholder="Data Inicio*" id="datetimepicker1"');
			// <!-- datainicio Error -->
			if($validation->getError('input_datainicio')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_datainicio'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-4 mb-3">';
			// input pagamentoproximo
			echo form_label('Próximo pagamento','input_pagamentoproximo');
			echo form_input('input_pagamentoproximo', ($clientePedido['cliped_pagamentoproximo'])? $clientePedido['cliped_pagamentoproximo'] : '','class="form-control" placeholder="Próximo pagamento*" id="datetimepicker2"');
			// <!-- pagamento proximo Error -->
			if($validation->getError('input_pagamentoproximo')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pagamentoproximo'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input Deleted
			echo form_label('Exclusão:','input_deleted');
			echo form_input('input_deleted', ($clientePedido['deleted_at'])? $clientePedido['deleted_at'] : '','class="form-control" placeholder="Deleted" id="datetimepicker3"');
			// <!-- deleted Error -->
			if($validation->getError('input_deleted')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_deleted'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-3 mb-3">';
			// input pagamentoperiodo
			$pgtoPeriodo = [
				'8'    =>  'Mensal',
				'4'    =>  'Trimestral',
				'2'    =>  'Semestral',
				'1'    =>  'Anual',
			];
			echo form_label('Periodicidade: ','input_pagamentoperiodo');
			echo form_dropdown('input_pagamentoperiodo', $pgtoPeriodo, $clientePedido['cliped_pagamentoperiodo'], 'class="form-select"');
			// <!-- pagamento periodo Error -->
			if($validation->getError('input_pagamentoperiodo')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pagamentoperiodo'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-4 mb-3">';
			// select status
			$statsOpt = [
				'0'	=> 'Inativo',
				'1'	=> 'Ativo',
			];
			echo form_label('Status do Produto: ','input_status');
			echo form_dropdown('input_status',$statsOpt, $clientePedido['cliped_status'], 'class="form-select"' );
			// <!-- status Error -->
			if($validation->getError('input_status')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_status'); ?>
				</div><?php 
			}
		echo '</div>';
		echo '<div class="col-md-12 mt-3">';
			// confirmar envio
			echo csrf_field();
			echo form_hidden('id_cliente',$cliente['id_cliente']);
			echo form_hidden('input_produto',$clientePedido['id_produto']);
			echo form_submit('enviar','Editar Pedido','class="btn btn-primary w-100 mt-3"');
			echo '<p class="mt-2 small">* Campos necessários</p>';
		echo '</div>';

		echo form_close();
		?>
	</div>

</div>
</div>
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script src="<?=base_url('public/assets/js')?>/jquery.datetimepicker.full.min.js"></script>
<script>
jQuery('#datetimepicker1').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker2').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker3').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
</script>
<?= $this->endSection() ?>