<?= $this->extend('admin/template/template') ?>


<?= $this->section('css') ?>
<link rel="stylesheet" type="text/css" href="<?=base_url('public/assets/css')?>/jquery.datetimepicker.min.css" >
<?= $this->endSection() ?>


<?= $this->section('content') ?>
<div class="container-fluid">
	<div class="row justify-content-center">
		<div class="col-md-2">
			<h3 class="mt-5">Pedidos</h3>
			<p>
				<a class="btn btn-light w-100 mb-2" href="<?=base_url()?>/clientePedido">Ativos</a><br>
				<a class="btn btn-light w-100 mb-2" href="<?=base_url()?>/clientePedido?status=0">Cancelados</a>
			</p>
		</div>
		<div class="col-md-8 shadow rounded-bottom p-5">
			<!-- > Breadcrumb -->
			<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
					<li class="breadcrumb-item active" aria-current="page">Pedidos</li>
				</ol>
			</nav>
			<!-- # end breadcrumb -->
			<!-- > Conteudo -->
			<h3><?php echo $TituloPagina; ?></h3>
			<hr>
			<p><?= anchor('clientePedido/cadastra/new','Adicionar Pedido','class="mt-4 btn btn-outline-success"'); ?></p>
			<div class="table-responsive">
			<table class="table table-borderless">
				<thead class="table-light">
				<tr>
					<th>ID</th>
					<th>Cliente</th>
					<th>Produto</th>
					<th>Dominio</th>
					<th>Valor</th>
					<th>Inicio</th>
					<th>Próximo vencimento</th>
					<th>Periodicidade</th>
					<th>Status</th>
					<th>Ação</th>
				</tr>
				</thead>
				<tbody>
				<?php
				if($listagem):
				foreach($listagem as $cliente):
					echo '<tr>';
					echo '<td colspan="10">';
						echo '<h4 class="mt-5">' . anchor('cliente/painel/'.$cliente[0]['id_cliente'],$cliente[0]['cli_nome']) . '</h4>';
						echo '<p class="small">ID: ' . $cliente[0]['id_cliente'] . ' | e-mail: ' . $cliente[0]['cli_email'] . '</p>';

						echo '<table class="table table-striped table-hover">';
						foreach($cliente as $row):
							$row['cliped_datainicio'] = new DateTime($row['cliped_datainicio']);
							$row['cliped_datainicio'] = $row['cliped_datainicio']->format('d/m/Y');

							$row['cliped_pagamentoproximo'] = new DateTime($row['cliped_pagamentoproximo']);
							$row['cliped_pagamentoproximo'] = $row['cliped_pagamentoproximo']->format('d/m/Y');

							switch($row['cliped_pagamentoperiodo']):
								case '1' : $row['cliped_pagamentoperiodo'] = 'Anual';
								break;
								case '2' : $row['cliped_pagamentoperiodo'] = 'Semestral';
								break;
								case '4' : $row['cliped_pagamentoperiodo'] = 'Bimestral';
								break;
								case '8' : $row['cliped_pagamentoperiodo'] = 'Mensal';
								break;
								default: $row['cliped_pagamentoperiodo'] = $row['cliped_pagamentoperiodo'];
							endswitch;

							switch($row['cliped_status']):
								case '0' : $row['cliped_status'] = 'Cancelado';
								break;
								case '1' : $row['cliped_status'] = 'Ativo';;
								break;
								case '2' : $row['cliped_status'] = 'Abandonado';
								break;
								default: $row['cliped_status'] = $row['cliped_status'];
							endswitch;
							// var_dump($row);
							// echo 'Produto: ' . $row["pro_nome"] . ' ' . $row["cliped_dominio"];
							// echo  '<br>';
							// echo $row["id_clientepedido"] . '<br>';
							// echo $row["id_cliente"] . '<br>';
							// echo $row["id_produto"] . '<br>';
							// echo 'valor: R$ ' . $row["cliped_valor"] . '<br>';
							// echo 'Inicio: ' . $row["cliped_datainicio"] . '<br>';
							// echo 'Próximo: ' . $row["cliped_pagamentoproximo"] . '<br>';
							// echo 'Período: ' . $row["cliped_pagamentoperiodo"] . '<br>';
							// echo 'Status: ' . $row["cliped_status"] . '<br>';
							// echo '<br>';
							?>
							<tr>
								<td><?=$row["pro_nome"] . '<br> <small>' . $row["cliped_dominio"] . '</small>'; ?></td>
								<td><?=$row['cliped_valor']; ?></td>
								<td><?=$row['cliped_datainicio']; ?></td>
								<td><?=$row['cliped_pagamentoproximo']; ?></td>
								<td><?=$row['cliped_pagamentoperiodo']; ?></td>
								<td><?=$row['cliped_status']; ?></td>
								<td nowrap><?php
									echo anchor('clientePedido/edita/'.$row['id_clientepedido'], '<span class="material-symbols-outlined">edit_note</span>');
									echo ' | ';
									echo anchor('clientePedido/exclui/'.$row['id_clientepedido'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
								?></td>
							</tr>
							<?php
						endforeach;	
						echo '</table>';

					echo '</td>';
					echo '</tr>';
				endforeach;
				endif;
				?>
				</tbody>
			</table>
			</div><!-- end responsive table -->
		</div>
	</div><!-- end row -->
</div>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>