<?= $this->extend('admin/template/template') ?>



<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-8 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/evupt','Evupt')?></li>
				<?php
				// se vier de algum disparador
				if($id_disparador):
					echo '<li class="breadcrumb-item">' .anchor('/evupt/edita/'.$id_disparador,'Disparador') . '</li>';
				endif;
				?>
				<li class="breadcrumb-item active" aria-current="page">Cadastrar novo contato</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Novo Contato</h2>
		<?php
		$validation = \Config\Services::validation();
		$validation->listErrors();
		echo form_open('evupt/contatoCadastra/'.$id_disparador);
		
		// id_disparador
		$op_disparador[0] = 'selecione';
		foreach($disparadores as $d):
			$op_disparador[$d['id_disparador']] = $d['dis_nome'];
		endforeach;
		echo form_label('Disparador: ','input_disparador',['class'=>'mt-3']);
		echo form_dropdown('input_disparador', $op_disparador, $id_disparador,'class="form-select" placeholder="Nome disparador" id="input_disparador"');
		// <!-- input Error -->
		if($validation->getError('input_disparador')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_disparador'); ?>
			</div><?php 
		}

		//con_nome
		echo form_label('Nome: ','input_nome',['class'=>'mt-3']);
		echo form_input('input_nome', set_value('input_nome'),'class="form-control" placeholder="Nome do contato" id="input_nome"');
		// <!-- input Error -->
		if($validation->getError('input_nome')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_nome'); ?>
			</div><?php 
		}

		// con_whats
		echo form_label('Whatsapp: ','input_whats',['class'=>'mt-3']);
		echo form_input('input_whats', set_value('input_whats'),'class="form-control" placeholder="Número para envio" id="input_whats"');
		// <!-- input Error -->
		if($validation->getError('input_whats')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_whats'); ?>
			</div><?php 
		}

		// con_email
		echo form_label('E-mail: ','input_email',['class'=>'mt-3']);
		echo form_input('input_email', set_value('input_email'),'class="form-control" placeholder="E-mail para envio" id="input_email"');
		// <!-- input Error -->
		if($validation->getError('input_email')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_email'); ?>
			</div><?php 
		}

		// confirmar envio
		echo csrf_field();
		echo form_submit('enviar','Salvar Novo Contato','class="btn btn-primary w-100 mt-3"');

		echo form_close();
		?>
	</div>

</div>
</div>
</section>
<?= $this->endSection() ?>




<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>