<?= $this->extend('admin/template/template') ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-10 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/evupt','Evupt')?></li>
				<li class="breadcrumb-item active" aria-current="page">Editar Disparador: <?=$disparador['dis_nome']?></li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<!-- <h3 class="mb-0"><small class="text-secondary">Disparador</small> <?=$disparador['dis_nome']?></h3> -->
		<div class="row">
			<!-- DISPARADOR -->
			<div class="col-md-12 text-bg-light mb-3 p-2 rounded">
				<?php
				$validation = \Config\Services::validation();
				$validation->listErrors();
				echo form_open('evupt/edita/'.$disparador['id_disparador'],['class'=>'row']);
					echo '<div class="col-md-8 mb-5">';
					echo form_label('Disparador ','input_nome',['class'=>'mt-3']);
					echo form_input('input_nome', $disparador['dis_nome'] ?? '','class="form-control" placeholder="Nome disparador" id="input_nome"');
					// <!-- input Error -->
					if($validation->getError('input_nome')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_nome'); ?>
						</div><?php 
					}
					echo '</div>';

					// confirmar envio
					echo '<div class="col-md-4 mt-3 text-center">';
					echo csrf_field();
					echo form_submit('enviar','Atualizar Informações do Disparador','class="btn btn-outline-primary btn-sm btn-confirma-excluir p-3 mt-2 w-100"');
					echo '</div>';

					echo '<h6 class="col-md-12 mb-0 fw-bold">Configurações do Disparador de Emails</h6>';
					echo '<div class="col-md-3">';
					echo form_label('E-mail: ','input_email',['class'=>'mt-3']);
					echo form_input('input_email',  $disparador['dis_email'] ?? '','class="form-control" placeholder="Origem do disparo" id="input_email"');
					// <!-- input Error -->
					if($validation->getError('input_email')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_email'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-1">';
					echo form_label('Senha: ','input_senha',['class'=>'mt-3']);
					echo form_input('input_senha',  $disparador['dis_senha'] ?? '','class="form-control" placeholder="Senha do email" id="input_senha"');
					// <!-- input Error -->
					if($validation->getError('input_senha')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_senha'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-2">';
					echo form_label('SMTP: ','input_smtp',['class'=>'mt-3']);
					echo form_input('input_smtp',  $disparador['dis_smtp'] ?? '','class="form-control" placeholder="url" id="input_smtp"');
					// <!-- input Error -->
					if($validation->getError('input_smtp')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_smtp'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-1">';
					echo form_label('Seguro: ','input_secure',['class'=>'mt-3']);
					echo form_input('input_secure',  $disparador['dis_secure'] ?? '','class="form-control" placeholder=" true ou false" id="input_secure"');
					// <!-- input Error -->
					if($validation->getError('input_secure')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_secure'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-1">';
					echo form_label('Porta: ','input_porta',['class'=>'mt-3']);
					echo form_input('input_porta',  $disparador['dis_porta'] ?? '','class="form-control" placeholder="Receba respostas nele" id="input_porta"');
					// <!-- input Error -->
					if($validation->getError('input_porta')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_porta'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-2">';
					echo form_label('E-mail para respostas: ','input_reply',['class'=>'mt-3']);
					echo form_input('input_reply',  $disparador['dis_reply'] ?? '','class="form-control" placeholder="Receba respostas nele" id="input_reply"');
					// <!-- input Error -->
					if($validation->getError('input_reply')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_reply'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-2 text-center">';
						echo '<p class="mt-3 mb-0">Ações</p>';
						echo anchor('evupt/testarDisparo/1/' . $disparador['id_disparador'],'Testar Disparo Email','class="btn btn-outline-dark btn-sm"');
					echo '</div>';
					echo '<div class="col-md-12 mb-5"></div>';
					echo '<h6 class="col-md-12 mb-0 fw-bold">Configurações do Disparador de Whatsapp</h6>';
					echo '<div class="col-md-3">';
					echo form_label('Url Bot: ','input_boturl',['class'=>'mt-3']);
					echo form_input('input_boturl',  $disparador['dis_boturl'] ?? '','class="form-control" placeholder="Camino do bot" id="input_boturl"');
					// <!-- input Error -->
					if($validation->getError('input_boturl')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_boturl'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-2">';
					echo form_label('Autenticação: ','input_botauth',['class'=>'mt-3']);
					echo form_input('input_botauth',  $disparador['dis_botauth'] ?? '','class="form-control" placeholder="Identifique o bot" id="input_botauth"');
					// <!-- input Error -->
					if($validation->getError('input_botauth')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_botauth'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-2">';
					echo form_label('Hash: ','input_bothash',['class'=>'mt-3']);
					echo form_input('input_bothash',  $disparador['dis_bothash'] ?? '','class="form-control" placeholder="Informe hash do bot" id="input_bothash"');
					// <!-- input Error -->
					if($validation->getError('input_bothash')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_bothash'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-5 mt-3 text-center">';
					echo '<p class="mt-0 mb-1">Ações</p>';
					echo anchor('evupt/testarStatus/' . $disparador['id_disparador'],'Status disparador','class="btn btn-outline-success btn-sm me-3"');
					echo anchor('evupt/testarDisparo/2/' . $disparador['id_disparador'],'Testar Disparo Whatsapp','class="btn btn-outline-secondary btn-sm me-3"'); // numero 2 é o meio de disparo
					echo anchor('evupt/botCriaSessao/' . $disparador['id_disparador'],'Criar Nova Sessão','class="btn btn-outline-success btn-sm me-3 btn-confirma-excluir" id="btnCria"');
					echo anchor('evupt/botRemoveSessao/' . $disparador['id_disparador'],'Remover Sessão Atual','class="btn btn-outline-danger btn-sm btn-confirma-excluir" id="btnRemove"');
					echo '</div>';

					
					// // remover uma proxima vez					
					// // testar envios
					// echo '<div class="col-md-8 mt-3">';
					// echo '</div>';

				echo form_close();
				?>
			</div>
			<!-- TEMPLATES -->
			<div class="col-md-6">
				<h5 class="mt-5">Templates para envio</h5>
				<div class="table-responsive">
				<?php
				echo anchor('evupt/templateCadastra/'.$disparador['id_disparador'],'Novo Template','class="btn btn-success"');
				if($template):
					echo '<table class="table mt-3">';
					echo '<thead class="table-light">';
					echo '<tr>';
					echo '<th>Nome</th>';
					echo '<th>Prazo</th>';
					echo '<th>Ativo</th>';
					echo '<th width="90">Ação</th>';
					echo '</tr>';
					echo '</thead>';
					echo '<tbody>';
					echo '</tbody>';
					foreach($template as $t):
						if($t['tem_status']):
							$t['tem_status'] = 'Sim';
						else:
							$t['tem_status'] = 'Parado';
						endif;
						echo '<tr>';
						echo '<td>'.anchor('evupt/templateEdita/'.$t['id_template'],$t['tem_titulo']).'</td>';
						echo '<td>'.$t['tem_prazo'].' dias</td>';
						echo '<td>'.$t['tem_status'].'</td>';
						echo '<td class="small">' . anchor('evupt/templateEdita/'.$t['id_template'],'<span class="material-symbols-outlined">edit_note</span>') . ' | ' . anchor('evupt/templateExclui/'.$t['id_template'],'<span class="material-symbols-outlined">delete</span>','class="btn-confirma-excluir"') . '</td>';
						echo '</tr>';
					endforeach;
					echo '</table>';
				else:
					echo '<p>Cadastre um template antes de iniciar os disparos.</p>';
				endif;
				?>
				</div>
			</div>
			<!-- RELATORIO -->
			<div class="col-md-6">
				<h5 class="mt-5">Relatório do disparador</h5>
				<p>Total cadastros: <?=$total['lista']?></p>
				<p>Disparos recentes: <?=$total['disparado']?></p>
				<div class="table-responsive">
				<?php
				if($relatorio):
					echo '<table class="table">';
					echo '<thead class="table-light">';
					echo '<tr>';
					echo '<th>Nome</th>';
					echo '<th>Disparo</th>';
					echo '<th>Ativo</th>';
					echo '</tr>';
					echo '</thead>';
					echo '<tbody>';
					echo '</tbody>';
					foreach($relatorio as $r):
						$r['updated_at'] = date_create($r['updated_at']);
						echo '<tr>';
						echo '<td>' . $r['con_nome'] . '</td>';
						echo '<td>' . $r['con_relatorio'] . '</td>';
						echo '<td>' . date_format($r['updated_at'], 'd/m/y H:m:i') . '</td>';
						echo '</tr>';
					endforeach;
					echo '</table>';
				else:
					echo '<p>Nenhum relatório disponível.</p>';
				endif;
				?>
				</div>
			</div>
			<!-- CADASTROS -->
			<div class="col-md-12 mt-5">
				<h5 class="mt-5">Contatos</h5>
				<div class="table-responsive">
				<?php
				echo anchor('evupt/contatoCadastra/'.$disparador['id_disparador'],'Novo Contato','class="btn btn-success"');
				if($cadastro):
					echo '<table class="table mt-3">';
					echo '<thead class="table-light">';
					echo '<tr>';
					echo '<th>Nome</th>';
					echo '<th>Whats</th>';
					echo '<th>Email</th>';
					echo '<th>Ativo</th>';
					echo '<th>Relatorio</th>';
					echo '<th width="90">Ação</th>';
					echo '</tr>';
					echo '</thead>';
					echo '<tbody>';
					echo '</tbody>';
					foreach($cadastro as $c):
						if($c['con_status']):
							$c['con_status'] = 'Sim';
						else:
							$c['con_status'] = 'Parado';
						endif;
						echo '<tr>';
						echo '<td>'.anchor('evupt/contatoEdita/'.$c['id_contato'],$c['con_nome']).'</td>';
						echo '<td>'.$c['con_whats'].'</td>';
						echo '<td>'.$c['con_email'].'</td>';
						echo '<td>'.$c['con_status'].'</td>';
						echo '<td>'.$c['con_relatorio'].'</td>';
						echo '<td class="small">' . anchor('evupt/contatoEdita/'.$c['id_contato'],'<span class="material-symbols-outlined">edit_note</span>') . ' | ' . anchor('evupt/contatoExclui/'.$c['id_contato'],'<span class="material-symbols-outlined">delete</span>','class="btn-confirma-excluir"') . '</td>';
						echo '</tr>';
					endforeach;
					echo '</table>';
				else:
					echo '<p>Cadastre um contato antes de iniciar os disparos.</p>';
				endif;
				?>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>




<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});

$(window).on('load', function(e){
	let auth = $('#input_botauth').val();
	let hash = $('#input_bothash').val();

	// se existe seção informada não cria, apenas exclui
	if(auth != '' || hash != ''){
		$('#btnCria').removeClass('btn-outline-success').addClass('d-none');
		$('#btnCria').on('click', function($e){
			return false;
		});
		console.log('botao Cria desativado');
		// se não existe seção informada, apenas cria
	}else{
		$('#btnRemove').attr("disabled", true);
		$('#btnRemove').removeClass('btn-outline-success').addClass('d-none');
		$('#btnRemove').on('click', function($e){
			return false;
		});
		console.log('botao Remove desativado');
	}
});
</script>
<?= $this->endSection() ?>