<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h3 class="mt-5">EVUPT</h3>
		<?php
		echo anchor('evupt/contatoCadastra/0','Novo Contato','class="btn btn-light w-100 mb-2"');
		echo anchor('evupt/templateCadastra/0','Novo Template','class="btn btn-light w-100 mb-2"');
		echo '<hr>';
		echo anchor('evupt?status=excluidos','Disparadores Excluídos','class="btn btn-light w-100 mb-2 btn-sm"');
		?>
		<!-- <h5 class="mt-5">Últimas ações</h5>
		<ul>
			<li>abriu</li>
			<li>enviou</li>
			<li>...</li>
		</ul> -->
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Evupt</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h3>Listagem</h3>
		<hr>
		<?php
		echo anchor('evupt/cadastra','Cadastrar Disparador','class="btn btn-outline-success mt-3 mb-3 btn-sm"');
		if($listagemDisparadores):
		?>
		<div class="table-responsive">
			<table class="table">
				<thead class="table-light">
					<tr>
						<th>ID</th>
						<th>Disparador</th>
						<th>Email</th>
						<th>Resposta</th>
						<th>Ação</th>
					</tr>
				</thead>
				<tbody>
					<?php
					foreach($listagemDisparadores as $disparador):
						echo '<tr>';
						echo '<td>'. $disparador['id_disparador'] .'</td>';
						echo '<td>'. anchor('evupt/edita/'.$disparador['id_disparador'], $disparador['dis_nome']) .'</td>';
						echo '<td>'. $disparador['dis_email'] .'</td>';
						echo '<td>'. $disparador['dis_reply'] .'</td>';
						echo '<td class="small">';
						echo anchor('evupt/edita/'.$disparador['id_disparador'], '<span class="material-symbols-outlined">edit_note</span>');
						echo ' | ';
						echo anchor('evupt/exclui/'.$disparador['id_disparador'],'<span class="material-symbols-outlined btn-confirma-excluir">delete</span>');
						echo '</tr>';
					endforeach;
					?>
				</tbody>
			</table>
		</div>
		<?php
		else:
			echo '<p>Nenhum disparador cadastrado.</p>';
		endif;
		?>
		
		<p class="mt-5">
			Cron:<br>
			<?=anchor('crontask/evuptMotor','evuptMotor')?>
		</p>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>


<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>