<?= $this->extend('admin/template/template') ?>



<?= $this->section('content') ?>
<!-- include summernote css/js -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-bs5.min.css" rel="stylesheet">
<?= $this->endSection() ?>



<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-8 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/evupt','Evupt')?></li>
				<?='<li class="breadcrumb-item">' .anchor('/evupt/edita/'.$template['id_disparador'],'Disparador') . '</li>'?>
				<li class="breadcrumb-item active" aria-current="page">Editar template</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editando template</h2>
		<hr>
		<p>Teste o disparo desta campanha para o email padrão, <?=anchor('evupt/testarDisparoTemplate/email/'.$template['id_disparador'].'/'.$template['id_template'],'Clique Aqui')?></p>
		<?php
		$validation = \Config\Services::validation();
		$validation->listErrors();
		echo form_open('evupt/templateEdita/'.$template['id_template']);
		
		// id_disparador
		$op_disparador[0] = 'selecione';
		foreach($disparadores as $d):
			$op_disparador[$d['id_disparador']] = $d['dis_nome'];
		endforeach;
		echo form_label('Disparador: ','input_disparador',['class'=>'mt-3']);
		echo form_dropdown('input_disparador', $op_disparador, $template['id_disparador'],'class="form-select" placeholder="Nome disparador" id="input_disparador"');
		// <!-- input Error -->
		if($validation->getError('input_disparador')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_disparador'); ?>
			</div><?php 
		}

		echo form_label('Prazo: ','input_prazo',['class'=>'mt-3']);
		echo form_input('input_prazo', $template['tem_prazo'],'class="form-control" placeholder="Disparar em x dias" id="input_prazo"');
		// <!-- input Error -->
		if($validation->getError('input_prazo')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_prazo'); ?>
			</div><?php 
		}

		echo form_label('Assunto: ','input_titulo',['class'=>'mt-3']);
		echo form_input('input_titulo', $template['tem_titulo'],'class="form-control" placeholder="Título do email" id="input_titulo"');
		// <!-- input Error -->
		if($validation->getError('input_titulo')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_titulo'); ?>
			</div><?php 
		}

		echo form_label('Corpo da mensagem: ','summernote',['class'=>'mt-3']);
		echo form_textarea('input_corpo', $template['tem_corpo'],'class="form-control" placeholder="Mensagem a ser envida" id="summernote"');
		// <!-- input Error -->
		if($validation->getError('input_corpo')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_corpo'); ?>
			</div><?php 
		}
		echo '<p class="small mt-2">Mensagem para whatsapp não utiliza html</p>';

		$op_status[0] = 'Parado';
		$op_status[1] = 'Ativo';
		echo form_label('Disparador: ','input_status',['class'=>'mt-3']);
		echo form_dropdown('input_status', $op_status, $template['tem_status'],'class="form-select" placeholder="Nome disparador" id="input_status"');
		// <!-- input Error -->
		if($validation->getError('input_status')) { ?>
			<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_status'); ?>
			</div><?php 
		}

        echo form_hidden('input_id',$template['id_template']);
		
		// confirmar envio
		echo csrf_field();
		echo form_submit('enviar','Salvar Novo Template','class="btn btn-primary w-100 mt-3"');

		echo form_close();
		?>
	</div>

</div>
</div>
</section>
<?= $this->endSection() ?>




<?= $this->section('js') ?>
<!-- include summernote css/js -->
<script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-bs5.min.js"></script>
<script>
// habilita summernote
$(document).ready(function() {
	// cria instância editor wysisyg
	function habilitaEditorHtml(){
		$('#summernote').summernote({
			toolbar: [
				['style', ['style']], // Estilos gerais
				['font', ['bold', 'italic', 'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
				['fontname', ['fontname']],
				['fontsize', ['fontsize']],
				['color', ['color']],
				['para', ['ul', 'ol', 'paragraph']],
				['height', ['height']],
				['table', ['table']], // Tabela
				['insert', ['link', 'picture', 'video']], // Inserções
				['view', ['fullscreen', 'codeview', 'help']] // Visualização
			],
			fontsize: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '22', '24', '36', '48', '64', '82', '100'],
		});
	}
	habilitaEditorHtml();
});



// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>