<?= $this->extend('admin/template/template') ?>


<?= $this->section('css') ?>
<link rel="stylesheet" type="text/css" href="<?=base_url('public/assets/css')?>/jquery.datetimepicker.min.css" >
<?= $this->endSection() ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-8 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/fatura','Faturas')?></li>
				<li class="breadcrumb-item active" aria-current="page">Cadastrar</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Cadastre um novo fatura do sistema</h2>
		<?php
		// se veio com id_cliente : cadastra fatura pelo cliente
		if($id_cliente==NULL):
			$uri_id = 'new';
		else:
			$uri_id = $id_cliente;
		endif;
		$validation = \Config\Services::validation();
		echo form_open('fatura/cadastra/'.$uri_id, 'class="row g-2"');
			echo '<div class="col-md-10 offset-md-1">';
			// input ids
			echo form_label('Selecione o Cliente*', 'input_cliente');
			echo form_dropdown('input_cliente', $cliente, ($id_cliente)? $id_cliente : set_value('input_cliente'),'class="form-select"');
			// <!-- descricao Error -->
			if($validation->getError('input_cliente')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_cliente'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-8">';
			// input descricao
			echo form_label('Descrição: ','input_descricao');
			echo form_input('input_descricao', set_value('input_descricao'),'class="form-control" placeholder="Descrição do Fatura"');
			// <!-- descricao Error -->
			if($validation->getError('input_descricao')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_descricao'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input valor
			echo form_label('Valor: ','input_valor');
			echo form_input('input_valor', set_value('input_valor'),'class="form-control" placeholder="Valor"');
			// <!-- valor Error -->
			if($validation->getError('input_valor')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_valor'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input data
			echo form_label('Data: ','input_data');
			echo form_input('input_data', set_value('input_data'),'class="form-control" id="datetimepicker1"');
			// <!-- data Error -->
			if($validation->getError('input_data')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_data'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input vencimento
			echo form_label('Vencimento: ','input_vencimento');
			echo form_input('input_vencimento', set_value('input_vencimento'),'class="form-control" id="datetimepicker2"');
			// <!-- vencimento Error -->
			if($validation->getError('input_vencimento')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_vencimento'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input pagamento
			echo form_label('Pagamento: ','input_pagamento');
			echo form_input('input_pagamento', set_value('input_pagamento'),'class="form-control" id="datetimepicker3"');
			// <!-- pagamento Error -->
			if($validation->getError('input_pagamento')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pagamento'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4 offset-md-2">';
			// input nome
			echo form_label('Forma de pagamento: ','input_nome');
			echo form_dropdown('input_nome',$formapgto,set_value('input_nome'), 'class="form-select"');
			// <!-- nome Error -->
			if($validation->getError('input_nome')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_nome'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input status
			echo form_label('Status: ','input_status');
			$opStats = [
				'1'	=> 'Aberto',
				'0'	=> 'Pago',
				'2'	=> 'Cancelado',
			];
			echo form_dropdown('input_status',$opStats, set_value('input_status'), 'class="form-select"');
			// <!-- status Error -->
			if($validation->getError('input_status')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_status'); ?>
				</div><?php 
			}
			echo '</div>';

			echo '<div class="mt-3">';
			echo form_submit('enviar','Cadastrar','class="btn btn-primary w-100"');
			echo '</div>';
		echo form_close();
		?>
		<br>
		<hr>
		<h3>Opções do boleto</h3>
		<p>Após criar a fatura será possível gerar o boleto.</p>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>

<script src="<?=base_url('public/assets/js')?>/jquery.datetimepicker.full.min.js"></script>

<script>
jQuery('#datetimepicker1').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker2').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker3').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
</script>
<?= $this->endSection() ?>