<?= $this->extend('admin/template/template') ?>


<?= $this->section('css') ?>
<link rel="stylesheet" type="text/css" href="<?=base_url('public/assets/css')?>/jquery.datetimepicker.min.css" >
<?= $this->endSection() ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-8 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/fatura','Faturas')?></li>
				<li class="breadcrumb-item active" aria-current="page">Editar</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2><?php echo anchor('cliente/painel/'.$cliente['id_cliente'], $cliente['cli_nome']); ?> > Editar fatura nº: <b><?=$fatura['id_fatura']?></b></h2>
		<div class="alert alert-light small">
        Quando o boleto é gerado pelo sistema, concede automáticamente 10% de desconto até a data do vencimento;<br>
        Crie a fatura utilizando a base de calculo abaixo para estipular o novo valor com mais 10%, quando for conveniente;<br>
        NOVO_VALOR = (VALOR_ESTIPULADO*100)/90;
    	</div>
		<?php
		$validation = \Config\Services::validation();
		echo form_open('fatura/edita/'.$fatura['id_fatura'], 'class="row g-2"');
			echo form_hidden('input_cliente',$fatura['id_cliente']);
			echo form_hidden('id_fatura',$fatura['id_fatura']);
			echo '<div class="col-md-8">';
			// input descricao
			echo form_label('Descrição: ','input_descricao');
			echo form_input('input_descricao', ($fatura['fat_descricao'])? $fatura['fat_descricao'] : '','class="form-control" placeholder="Fatura"');
			// <!-- descricao Error -->
			if($validation->getError('input_descricao')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_descricao'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input valor
			echo form_label('Valor: ','input_valor');
			echo form_input('input_valor', ($fatura['fat_valor'])? $fatura['fat_valor'] : '','class="form-control" placeholder="Descrição da Fatura"');
			// <!-- valor Error -->
			if($validation->getError('input_valor')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_valor'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input data
			echo form_label('Data: ','input_data');
			echo form_input('input_data', ($fatura['fat_data'])? $fatura['fat_data'] : '','class="form-control" id="datetimepicker1"');
			// <!-- data Error -->
			if($validation->getError('input_data')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_data'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input vencimento
			echo form_label('Vencimento: ','input_vencimento');
			echo form_input('input_vencimento', ($fatura['fat_vencimento'])? $fatura['fat_vencimento'] : '','class="form-control"  id="datetimepicker2"');
			// <!-- vencimento Error -->
			if($validation->getError('input_vencimento')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_vencimento'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-4">';
			// input pagamento
			echo form_label('Pagamento: ','input_pagamento');
			echo form_input('input_pagamento', ($fatura['fat_pagamento'])? $fatura['fat_pagamento'] : '','class="form-control"  id="datetimepicker3"');
			// <!-- pagamento Error -->
			if($validation->getError('input_pagamento')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_pagamento'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';
			// input formapgto
			echo form_label('Forma de pgto: ','input_nome');
			echo form_dropdown('input_nome', $formapgto,($fatura['fatfor_nome'])? $fatura['fatfor_nome'] : '', 'class="form-select"');

			// <!-- formapgto Error -->
			if($validation->getError('input_nome')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_nome'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';
			// input status
			echo form_label('Status: ','input_status');
			$opStats = [
				'1'	=> 'Aberto',
				'0'	=> 'Pago',
				'2'	=> 'Cancelado',
			];
			echo form_dropdown('input_status',$opStats,$fatura['fat_status'], 'class="form-select"');
			// <!-- status Error -->
			if($validation->getError('input_status')) { ?>
				<div class='alert alert-danger mt-2'>
				<?= $validation->getError('input_status'); ?>
				</div><?php 
			}
			echo '</div>';
			
			echo '<div class="mt-5 d-flex justify-content-center">';
			echo form_submit('enviar','Atualizar Fatura','class="btn btn-primary me-3"');
			
			if($fatura['fat_status'] == 1):
            	echo '<a href="'.base_url('fatura/aprovarpagamento/'. $fatura['id_fatura']) . '" class="btn btn-success me-3 btn-confirma-excluir"> Aprovar Pagamento </a>';
			endif;
			echo '</div>';

			echo '<input type="hidden" name="cli_nome" value="'.$cliente['cli_nome'].'" />';
			echo '<input type="hidden" name="cli_cpfcnpj" value="'.$cliente['cli_cpfcnpj'].'" />';
		echo form_close();

		//boleto bancario vazio
		if(empty($boleto)):
			echo '<h4 class="mt-5">Opções do boleto</h4>';

			echo '<div id="gerandoboleto" class="mt-3 clearfix">'; // clearfix
			echo '<small>não temos boleto gerado.</small><br>';

			// boleto ASAAS
			echo anchor('fatura/boletar/'.$fatura['id_fatura'], 'Gerar Boleto Bancário Asaas', 'class="btn btn-outline-success float-start"');
			
			echo '</div>'; // end clearfix


		// boleto bancario ja criado
		else:
			echo '<h4 class="mt-5">Opções do boleto</h4>';
			foreach($boleto as $b):
				echo '<small class="text-secondary"> Id boleto: ' . $b["id_formapgtoboleto"] . '</small><br>';
				echo 'forbol_codigo: ' . $b["forbol_codigo"] . '<br>';
				echo 'Id Fatura: ' . $b["id_fatura"] . '<br>';
				echo $b["forbol_duedate"] . '<br>';
				echo $b["forbol_checkouturl"] . '<br>';
				echo $b["forbol_link"] . '<br>';
				echo $b["forbol_installmentlink"] . '<br>';
				echo $b["forbol_paynumber"] . '<br>';
				echo $b["forbol_barcodenumber"] . '<br>';
				echo $b["forbol_paymenttoken"] . '<br>';
				echo '<p class="small">id_fatura = Referência externa (Asaas) | ';
				echo 'forbol_codigo = id_asaas(Asaas)</p>';
			endforeach;
			echo '<hr>';
			echo anchor('fatura/boletar/'.$fatura['id_fatura'], 'Gerar Boleto Bancário Asaas Extra (Apenas quando necessário)', 'class="btn btn-sm btn-outline-success btn-confirma-excluir"');
		endif;

		// informacoes da tabela
		echo '<hr>';
		echo '<p class="small text-secondary">';
		echo 'Criado: ' . $fatura['created_at'];
		echo ' | Editado: ' . $fatura['updated_at'];
		echo ' | Excluido: '. $fatura['deleted_at'];;
		echo '</p>';
		?>
	<div id="aprovado"></div>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>

<script src="<?=base_url('public/assets/js')?>/jquery.datetimepicker.full.min.js"></script>
<script>
// Mascara em datas
jQuery('#datetimepicker1').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker2').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
jQuery('#datetimepicker3').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
</script>



<!------------------------------------ -->
<!-- cria boleto ajax -->
<!------------------------------------ -->
<script type="text/javascript">
$(document).ready(function() {

});
</script>
<?= $this->endSection() ?>