<?= $this->extend('admin/template/template') ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h3 class="mt-5">Faturas</h3>
		<ul class="list-unstyled">
			<li class="mt-3"><?php echo anchor('/fatura/cadastra/new','Cadastrar Fatura', 'class="btn btn-outline-success w-100"'); ?></li>
		</ul>
		<h5 class="mt-5">Formas de Pagamento</h5>
		<hr>
		<ul class="list-unstyled">
		<?php
		foreach($dadosFaturaFormapgto as $f):
			echo '<li class="mt-2 ms-2">. ';
			echo anchor('faturaFormapgto/edita/'.$f['id_faturaformapgto'], $f['fatfor_nome']);
			echo '</li>';
		endforeach;
		echo '<li class="mt-3">' . anchor('/faturaFormapgto/cadastra','Cadastrar Forma') . '</li>';
		?>
		</ul>
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Faturas</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<!-- Faturas Abertas -->
		<h3>Abertas</h3>
		<hr>
		<div class="table-responsive">
			<?php
			echo form_open('fatura/lembrete');
			echo form_submit('/fatura/cobrar', 'Enviar cobrança por e-mail', 'class="btn btn-sm btn-outline-primary mt-3 btn-confirma-excluir"');
			echo '<br>';
			echo '<input type="checkbox" name="select-all" id="select-all" /> Selecionar Todos';
			?>
			<table class="table mt-3">
				<thead class="table-light">
					<tr>
						<th width="30"></th>
						<th width="50">ID</th>
						<th width="135">Cliente</th>
						<th>Descrição</th>
						<th width="135">Valor</th>
						<th width="135">Vencimento</th>
						<th width="80">Status</th>
						<th width="100">NFs-e</th>
						<th width="120">Ação</th>
					</tr>
				</thead>
				<tbody>
					<?php
					$diahoje = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
					foreach($listagemFaturaAberta as $fa):
						// ajustes
						$fa['cli_nome'] = explode(' ', $fa['cli_nome']);
						$fa['fat_vencimento'] = new DateTime($fa['fat_vencimento']);
						// input status
						switch($fa['fat_status']):
							case '0': $status = '<span class="badge text-bg-light">Pago</span>';
							break;
							case '1': $status = '<span class="badge text-bg-success">Aberto</span>';
							break;
							case '2': $status = '<span class="badge text-bg-secondary">Cancelado</span>';
							break;
							default: $status = $ff['fat_status'];
						endswitch;
						//se venceu, modifica linha tr
						if($diahoje->format('Y-m-d') > $fa['fat_vencimento']->format('Y-m-d')):
							echo '<tr class="table-danger">';
						elseif($diahoje->format('Y-m-d') == $fa['fat_vencimento']->format('Y-m-d')):
							echo '<tr class="table-info">';
						else:
							echo '<tr>';
						endif;
						?>
						<td><?= form_checkbox('input_envia[]', $fa['id_fatura'], false); ?></td>
						<td><?= anchor('/fatura/edita/'.$fa['id_fatura'],$fa['id_fatura']); ?></td>
						<td><?= anchor('/cliente/painel/'.$fa['id_cliente'], $fa['cli_nome'][0] . ' ' . substr($fa['cli_nome'][1],'0','1') . '.'); ?></td>
						<td class="small"><?= $fa['fat_descricao']; ?></td>
						<td nowrap>R$ <?= $fa['fat_valor']; ?></td>
						<td class="small"><?= $fa['fat_vencimento']->format('d/m/Y'); ?></td>
						<td><?= $status; ?></td>
						<td><?php
						if($fa['id_contabil_s']):
                            echo anchor('contabil/nfse/'.$fa['id_fatura'].'/1', 'Consulta', 'class="btn-confirma-excluir text-success"');
                        else:
                            echo anchor('contabil/nfse/'.$fa['id_fatura'].'/1', 'Gerar', 'class="btn-confirma-excluir text-primary"');
                        endif;
						?></td>
						<td nowrap class="small">
							<?php
							echo anchor('fatura/edita/'.$fa['id_fatura'], '<span data-bs-toggle="tooltip" data-bs-title="Editar Fatura" class="tt material-symbols-outlined">edit_note</span>');
							echo ' | ' . anchor('fatura/exclui/'.$fa['id_fatura'], '<span data-bs-toggle="tooltip" data-bs-title="Ecluir Fatura" class="tt material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
							echo ' | <a href="' . base_url('fatura/pagamentoConfirma/'. $fa['id_fatura']) . '" data-bs-toggle="tooltip" data-bs-title="Confirmação por E-mail" class="tt btn-confirma-excluir"><span class="material-symbols-outlined">send</span></a>'; ?>
						</td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
			<?= form_close(); ?>
		</div>

		<!-- Faturas Pagas Hoje -->
		<?php
		// se houver faturas paga hoje
		if($listagemFaturaPaga): ?>
		<h2 class="mt-5">Pagas Hoje</h2>
		<table class="table mt-3 mb-5">
				<thead class="table-light">
					<tr>
						<th width="30"></th>
						<th width="50">ID</th>
						<th width="135">Cliente</th>
						<th>Descrição</th>
						<th width="135">Valor</th>
						<th width="135">Pagamento</th>
						<th width="80">Status</th>
						<th width="100">NFs-e</th>
						<th width="120">Ação</th>
					</tr>
				</thead>
				<tbody>
				<?php
				foreach($listagemFaturaPaga as $pagaHoje):
					// ajustes
					$pagaHoje['cli_nome'] = explode(' ', $pagaHoje['cli_nome']);
					$pagaHoje['fat_pagamento'] = new DateTime($pagaHoje['fat_pagamento']);
					// input status
					switch($pagaHoje['fat_status']):
						case '0': $status = '<span class="badge text-bg-light">Pago</span>';
						break;
						case '1': $status = '<span class="badge text-bg-success">Aberto</span>';
						break;
						case '2': $status = '<span class="badge text-bg-secondary">Cancelado</span>';
						break;
						default: $status = $ff['fat_status'];
					endswitch;
					?>
					<td></td>
					<td><?= anchor('/fatura/edita/'.$pagaHoje['id_fatura'],$pagaHoje['id_fatura']); ?></td>
					<td><?= anchor('/cliente/painel/'.$pagaHoje['id_cliente'],$pagaHoje['cli_nome'][0]); ?></td>
					<td class="small"><?= $pagaHoje['fat_descricao']; ?></td>
					<td nowrap>R$ <?= $pagaHoje['fat_valor']; ?></td>
					<td class="small"><?= $pagaHoje['fat_pagamento']->format('d/m/Y'); ?></td>
					<td><?= $status; ?></td>
					<td><?php
						if($pagaHoje['fat_status'] != "2" ){
						if($pagaHoje['id_contabil_s']):
                            echo anchor('contabil/nfse/'.$pagaHoje['id_fatura'].'/1', $pagaHoje['con_status'], 'class="btn-confirma-excluir text-success"');
                        else:
                            echo anchor('contabil/nfse/'.$pagaHoje['id_fatura'].'/1', 'Gerar', 'class="btn-confirma-excluir text-primary"');
                        endif;
						}else{
							echo '<span class="text-secondary small">Cancelado</span>';
						}
					?></td>
					<td nowrap class="small">
						<?php
						echo anchor('fatura/edita/'.$pagaHoje['id_fatura'], '<span data-bs-toggle="tooltip" data-bs-title="Editar Fatura" class="tt material-symbols-outlined">edit_note</span>');
						echo ' | ' . anchor('fatura/exclui/'.$pagaHoje['id_fatura'], '<span data-bs-toggle="tooltip" data-bs-title="Ecluir Fatura" class="tt material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
						echo ' | <a href="' . base_url('fatura/pagamentoConfirma/'. $pagaHoje['id_fatura']) . '" data-bs-toggle="tooltip" data-bs-title="Confirmação por E-mail" class="tt btn-confirma-excluir"><span class="material-symbols-outlined">send</span></a>'; ?>
					</td>

					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
		<?php endif; ?>

		<!-- Todas as Faturas -->
		<h2 class="mt-5">Listagem</h2>
		<div class="table-responsive mt-4">
			<table class="table">
				<thead class="table-light">
					<tr>
						<th width="80">ID</th>
						<th width="135">Cliente</th>
						<th>Descrição</th>
						<th width="135">Valor</th>
						<th width="135">Pagamento</th>
						<th width="80">Status</th>
						<th width="100">NFs-e</th>
						<th width="120">Ação</th>
					</tr>
				</thead>
				<tbody>
				<?php		
					foreach($listagemFaturas as $ff):
						
						// input nome
						$ff['cli_nome'] = explode(' ', $ff['cli_nome']);
						
						// input data
						if($ff['fat_pagamento'] != null):
							$ff['fat_pagamento'] = new DateTime($ff['fat_pagamento']);
							$ff['fat_pagamento'] = $ff['fat_pagamento']->format('d/m/Y');
						endif;

						// input status
						switch($ff['fat_status']):
							case '0': $status = '<span class="badge text-bg-light">Pago</span>';
							break;
							case '1': $status = '<span class="badge text-bg-success">Aberto</span>';
							break;
							case '2': $status = '<span class="badge text-bg-secondary">Cancelado</span>';
							break;
							default: $status = $ff['fat_status'];
						endswitch;
					?>
					<tr>
						<td><?= anchor('/fatura/edita/'.$ff['id_fatura'],$ff['id_fatura']); ?></td>
						<td><?= anchor('/cliente/painel/'.$ff['id_cliente'], $ff['cli_nome'][0] . ' ' . substr($ff['cli_nome'][1],'0','1') . '.'); ?></td>
						<td class="small"><?= $ff['fat_descricao']; ?></td>
						<td nowrap>R$ <?= $ff['fat_valor']; ?></td>
						<td class="small"><?= $ff['fat_pagamento']; ?></td>
						<td><?= $status; ?></td>
						<td><?php
						if($ff['fat_status'] != "2" ){
						if($ff['id_contabil_s']):
                            echo anchor('contabil/nfse/'.$ff['id_fatura'].'/1', $ff['con_status'], 'class="btn-confirma-excluir text-success"');
                        else:
                            echo anchor('contabil/nfse/'.$ff['id_fatura'].'/1', 'Gerar', 'class="btn-confirma-excluir text-primary"');
                        endif;
						}else{
							echo '<span class="text-secondary small">Cancelado</span>';
						}
						?></td>
						<td nowrap class="small">
							<?php
							echo anchor('fatura/edita/'.$ff['id_fatura'], '<span data-bs-toggle="tooltip" data-bs-title="Editar Fatura" class="tt material-symbols-outlined">edit_note</span>');
							echo ' | ' . anchor('fatura/exclui/'.$ff['id_fatura'], '<span data-bs-toggle="tooltip" data-bs-title="Ecluir Fatura" class="tt material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
							echo ' | <a href="' . base_url('fatura/pagamentoConfirma/'. $ff['id_fatura']) . '" data-bs-toggle="tooltip" data-bs-title="Confirmação por E-mail" class="tt btn-confirma-excluir"><span class="material-symbols-outlined">send</span></a>'; ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
		<?php		

		echo '<p class="mt-5"> </p>';
		// paginação
		echo $pager->links('default','default_full');
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});

// Listen for click on toggle checkbox
$('#select-all').click(function(event) {   
    if(this.checked) {
        // Iterate each checkbox
        $('[name="input_envia[]"]').each(function() {
            this.checked = true;                        
        });
    } else {
        $('[name="input_envia[]"]').each(function() {
            this.checked = false;                       
        });
    }
});

const tooltip = document.querySelectorAll('.tt')
tooltip.forEach( t => {
	new bootstrap.Tooltip(t);
})

</script>
<?= $this->endSection() ?>