<?= $this->extend('admin/template/template') ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-10 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/fatura','Faturas')?></li>
				<li class="breadcrumb-item active" aria-current="page">Formas de Pagamento</li>
			</ol>
		</nav>
		<!-- # end Breadcrumb -->
		<h2 class="mt-5">Formas de Pagamento</h2>
		<p><?= anchor('/','Adicionar nova','class="mt-4 btn btn-outline-success"'); ?></p>
		<div class="table-responsive mt-4">
			<table class="table">
				<thead class="table-light">
					<tr>
						<th>ID</th>
						<th>Nome</th>
						<th width="120">Ação</th>
					</tr>
				</thead>
				<tbody>
				<?php		
					foreach($listagem as $ff):
					?>
					<tr>
						<td><?= $ff['id_faturaformapgto'] ?></td>
						<td><?= $ff['fatfor_nome'] ?></td>
						<td nowrap class="small">
							<?= anchor('faturaFormapgto/edita/'.$ff['id_faturaformapgto'], '<span class="material-symbols-outlined">edit_note</span>'); ?> |
							<?= anchor('faturaFormapgto/exclui/'.$ff['id_faturaformapgto'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"'); ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>