<?= $this->extend('admin/template/template') ?>


<?= $this->section('content') ?>
<div class="container-fluid">
<div class="row justify-content-center">
<div class="col-md-8 shadow rounded-bottom p-5">
	<!-- > Breadcrumb -->
	<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
			<li class="breadcrumb-item"><?=anchor('/faturamento','Faturamento')?></li>
			<li class="breadcrumb-item active" aria-current="page">Categorias</li>
		</ol>
	</nav>
	<!-- # end breadcrumb -->
	<!-- > Conteudo -->
	<h3><?php echo $TituloPagina; ?></h3>
	<p><?= anchor('/faturamentoCategoria/cadastra','Nova Categoria','class="mt-4 btn btn-outline-success"') ?></p>
	<div class="table-responsive">
	<table class="table">
		<thead class="table-light">
		<tr>
			<th>ID</th>
			<th>Nome</th>
			<th width="120">Ação</th>
		</tr>
		</thead>
		<tbody>
			<?php
			foreach($listagem as $l):
				echo '<tr>';
				echo '<td>' . $l['id_faturamentocategoria'] . '</td>';
				echo '<td>' . $l['fatcat_nome'] . '</td>';
				echo '<td nowrap class="small">';
				echo anchor('faturamentoCategoria/edita/'.$l['id_faturamentocategoria'], '<span class="material-symbols-outlined">edit_note</span>');
				echo ' | ';
				echo anchor('faturamentoCategoria/exclui/'.$l['id_faturamentocategoria'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
				echo '</td>';
				echo '</tr>';
			endforeach;
			?>

		</tbody>
	</table>
	</div><!-- end responsive table -->


</div><!-- end 12 -->
</div><!-- end row -->
</div>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>