<?= $this->extend('admin/template/template') ?>



<?= $this->section('css') ?>
<link rel="stylesheet" type="text/css" href="<?=base_url('public/assets/css')?>/jquery.datetimepicker.min.css" >
<?= $this->endSection() ?>



<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-8 shadow p-5 rounded">
		<div class="card">
			<div class="card-body">
				<?php
				// trata retorno de erro
				try {
					$errors = session('errors');
				} catch (Exception $e) {
					echo '', $e->getMessage(), "\n";
				}
				// formulario	
				echo form_open_multipart('midia/upload', 'class="row justify-content-center mt-5 pb-5"');
					echo '<div class="col-10 pb-3">';
					echo form_label('Insira o arquivo: ','fileuploads');
					echo form_upload('fileuploads[]',set_value('fileuploads[]'),'class="form-control" multiple');
					if(isset($errors['fileuploads'])):
						echo '<div class="alert alert-danger">';
						echo $errors['fileuploads'];
						echo '</div>';
					endif;
					echo '</div>';
					echo '<div class="col-auto">';
					echo form_label('Descrição: ','mid_descricao');
					echo form_input('mid_descricao',set_value('mid_descricao'),'class="form-control" placeholder="Descrição"');
					if(isset($errors['mid_descricao'])):
						echo '<div class="alert alert-danger">';
						echo $errors['mid_descricao'];
						echo '</div>';
					endif;
					echo '</div>';
					echo '<div class="col-auto">';
					echo form_label('Remover em: ','mid_vencimento');
					echo form_input('mid_vencimento',set_value('mid_vencimento'),'class="form-control" id="datetimepicker1"');
					if(isset($errors['mid_vencimento'])):
						echo '<div class="alert alert-danger">';
						echo $errors['mid_vencimento'];
						echo '</div>';
					endif;
					echo '</div>';
					echo '<div class="col-auto"><br>';
					echo form_submit('submit','Enviar','class="btn btn-success"');
					echo '</div>';
				echo form_close();
				?>
				<table class="table table-bordered mt-5">
					<thead>
						<tr>
							<th width="120">File</th>
							<th>Nome</th>
							<th>Descrição</th>
							<th>Vencimento</th>
							<th>Criação</th>
							<th>Ação</th>
						</tr>
					</thead>
					<tbody>
					<?php foreach ($files as $d):?>
						<tr>
							<td><?= anchor('public/uploads/'.$d['mid_file'],'<img src="'. base_url('public/uploads/'.$d['mid_file']) .'" class="w-100 img-fluid" alt="">', 'target="_blank"') ?></td>
							<td><?= $d['mid_nome'] ?></td>
							<td><?= $d['mid_descricao'] ?></td>
							<td><?= $d['mid_vencimento'] ?></td>
							<td><?= $d['created_at'] ?></td>
							<td><?=anchor('/midia/remove/'.$d['id_midia'],'Remover', 'class="btn btn-outline-secondary btn-sm btn-confirma-excluir w-100"')?></td>
						</tr>
						<?php endforeach;?>
					</tbody>
				</table>
			</div>
		</div>
	</div><!-- end shadow -->
</div><!-- end row -->
</div><!-- end container -->
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>

<script src="<?=base_url('public/assets/js')?>/jquery.datetimepicker.full.min.js"></script>

<script>
jQuery('#datetimepicker1').datetimepicker({
	format:'Y-m-d H:i:s',
	lang:'pt-BR',
	mask:true,
});
</script>
<?= $this->endSection() ?>