<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-10 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/orcamento','Orçamento')?></li>
				<li class="breadcrumb-item active" aria-current="page">Editar</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editar dados de <b><?=$orcamento['orc_titulo']?></b></h2>
		<?php
		$validation = \Config\Services::validation();
		echo form_open('orcamento/edita/'.$orcamento['id_orcamento']);

			// se com ou sem id do cliente | com id mostra listagem
			if($orcamento['id_cliente'] != null):
				// input cliente
				echo form_label('ID Cliente','input_id_cliente',['class'=>'mt-2']);
				echo form_input('input_id_cliente', ($orcamento['id_cliente'])? $orcamento['id_cliente'] : '','class="form-control" placeholder="Seu nome"');
				// input cliente Error
				if($validation->getError('input_id_cliente')):
					echo '<div class="alert alert-danger mt-2">';
					$validation->getError('input_id_cliente');
					echo '</div>';
				endif;
				echo form_hidden('input_nome','');
				echo form_hidden('input_email','');
				echo form_hidden('input_whats','');
			
			// se com ou sem id do cliente | sem id mostra cadastro
			else:
				echo form_hidden('input_id_cliente','NULL');

				// input name
				echo form_label('Nome','input_nome',['class'=>'mt-2']);
				echo form_input('input_nome', ($orcamento['orc_nome'])? $orcamento['orc_nome'] : '','class="form-control" placeholder="Seu nome"');
				// <!-- name Error -->
				if($validation->getError('input_nome')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_nome'); ?>
					</div><?php 
				}
				// input email
				echo form_label('E-Mail','input_email',['class'=>'mt-2']);
				echo form_input('input_email', ($orcamento['orc_email'])? $orcamento['orc_email'] : '','class="form-control" placeholder="Seu email"');
				// <!-- email Error -->
				if($validation->getError('input_email')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_email'); ?>
					</div><?php 
				}
				// input phone
				echo form_label('Whatsapp|Telefone','input_whats',['class'=>'mt-2']);
				echo form_input('input_whats', ($orcamento['orc_whats'])? $orcamento['orc_whats'] : '','class="form-control" placeholder="Seu telefone"');
				// <!-- email Error -->
				if($validation->getError('input_whats')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_whats'); ?>
					</div><?php 
				}
			endif;
			// input status
			$opts = [
				'aberto' => 'Aberto',
				'recusado' => 'Recusado',
				'aprovado' => 'Aprovado',
			];
			echo form_label('Status','input_status',['class'=>'mt-2']);
			echo form_dropdown('input_status', $opts, ($orcamento['orc_status'])? $orcamento['orc_status'] : '','class="form-control" placeholder="Seu nome"');
			// input status Error
			if($validation->getError('input_status')):
				echo '<div class="alert alert-danger mt-2">';
				$validation->getError('input_status');
				echo '</div>';
			endif;
			// input titulo orcamento
			echo form_label('Titulo','input_titulo',['class'=>'mt-5']);
			echo form_input('input_titulo', ($orcamento['orc_titulo'])? $orcamento['orc_titulo'] : '','class="form-control" placeholder="Seu email"');
			// <!-- email Error -->
			if($validation->getError('input_titulo')) {
				echo '<div class="alert alert-danger mt-2">';
				$validation->getError('input_status');
				echo '</div>';
			}
			// textarea descrição
			echo form_label('Descrição','input_descricao',['class'=>'mt-2']);
			echo form_textarea('input_descricao', $orcamento['orc_descricao'], array('rows' => '5', 'class' => 'mt-1 form-control', 'placeholder'=>'CNPJ, Descrição do orçamento e link da apresentação.'));
        	// textarea descrição Error
			if($validation->getError('input_descricao')) {
				echo '<div class="alert alert-danger mt-2">';
				$validation->getError('input_status');
				echo '</div>';
			}
			// confirmar envio
			echo '<div class="d-grid mt-3">';
			echo form_hidden('id_orcamento',$orcamento['id_orcamento']);
			echo csrf_field();
			echo form_submit('enviar','Atualizar Orçamento','class="btn btn-primary"');
			echo '</div>';
		echo form_close();

		echo '<br>Criado: ' . $orcamento['created_at'];
		echo '<br>Editado: ' . $orcamento['updated_at'];
		echo '<br>Excluido: '. $orcamento['deleted_at'];
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>