<?= $this->extend('admin/template/template') ?>



<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h3 class="mt-5">Orçamento</h3>
		<p>

			<a href="<?php echo base_url('orcamento?status=aberto'); ?>" rel="nofollow" class="btn btn-light w-100 mb-2"><span class="glyphicon glyphicon-list-alt"></span> Aberto</a><br>
			<a href="<?php echo base_url('orcamento?status=aprovado'); ?>" rel="nofollow" class="btn btn-light w-100 mb-2"><span class="glyphicon glyphicon-list-alt"></span> Aprovado</a><br>
			<a href="<?php echo base_url('orcamento?status=recusado'); ?>" rel="nofollow" class="btn btn-light w-100 mb-2"><span class="glyphicon glyphicon-list-alt"></span> Recusado</a><br>

		</p>
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Orçamentos</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h3>Listagem</h3>
		<hr>
		<?=anchor('/orcamento/cadastra','Novo Orcamento', 'class="btn btn-outline-success mt-3 mb-3"'); ?>
		<div class="table-responsive">
			<table class="table">
				<thead class="table-light">
					<tr>
						<th>ID</th>
						<th>Orçamento</th>
						<th>E-Mail</th>
						<th>Status</th>
						<th>Ação</th>
					</tr>
				</thead>
				<tbody>
				<?php
				foreach($listagemOrcamento as $orcamento):
					echo '<tr>';
					echo '<td>' . $orcamento['id_orcamento'] . '</td>';
					echo '<td>';
					// se vier id_cliente no orçamento
					if($orcamento['id_cliente'] != null):
						$cliente = array_column($clientes, 'id_cliente');
						$found_key = array_search($orcamento['id_cliente'], $cliente);
						echo '<span class="material-symbols-outlined">person</span> ';
						echo '<small>' . anchor('cliente/painel/'.$clientes[$found_key]['id_cliente'],$clientes[$found_key]['cli_nome']) . '</small>';
						echo '<br>';
					// se vier nome de prospect no orçamento
					else:
						echo '<small>';
						echo '<span class="material-symbols-outlined">person</span> ';
						echo $orcamento['orc_nome'] . ' ';
						echo $orcamento['orc_email'] . ' ';
						echo $orcamento['orc_whats'];
						echo '<br>';
						echo '</small>';
					endif;
					echo '<span class="material-symbols-outlined">contract</span>';
					echo anchor('orcamento/edita/'.$orcamento['id_orcamento'],$orcamento['orc_titulo']);
					echo '</td>';
					echo '<td>' . $orcamento['orc_email'] . '</td>';
					echo '<td><span class="badge text-bg-light">' . ucfirst($orcamento['orc_status']) . '</span></td>';
					echo '<td class="small">';
					echo anchor('orcamento/edita/'.$orcamento['id_orcamento'], '<span class="material-symbols-outlined">edit_note</span>') . ' | ';
					echo anchor('orcamento/exclui/'.$orcamento['id_orcamento'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
					echo '</td>';
					echo '</tr>';
				endforeach;
				?>
				</tbody>
			</table>
		</div>
		<?php
		// paginação
		echo $pager->links('default','default_full');
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>