<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-10 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/organizacao','Organizacoes')?></li>
				<li class="breadcrumb-item active" aria-current="page">Editar</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editar dados de <b><?=$organizacao['org_nome']?></b></h2>
		<?php
		$validation = \Config\Services::validation();
		echo form_open('organizacao/edita/'.$organizacao['id_organizacao'], 'class="mt-5"');
		?>
	
		<nav>
		<div class="nav nav-tabs" id="nav-tab" role="tablist">
			<button class="nav-link active" id="nav-perfil-tab" data-bs-toggle="tab" data-bs-target="#nav-perfil" type="button" role="tab" aria-controls="nav-perfil" aria-selected="true">Perfil</button>
			<button class="nav-link" id="nav-endereco-tab" data-bs-toggle="tab" data-bs-target="#nav-endereco" type="button" role="tab" aria-controls="nav-endereco" aria-selected="false">Endereço</button>

			<?php if($organizacao['id_organizacao'] == 1):?>
				<button class="nav-link" id="nav-email-tab" data-bs-toggle="tab" data-bs-target="#nav-email" type="button" role="tab" aria-controls="nav-email" aria-selected="false">Email</button>
				<button class="nav-link" id="nav-whatsapp-tab" data-bs-toggle="tab" data-bs-target="#nav-whatsapp" type="button" role="tab" aria-controls="nav-whatsapp" aria-selected="false">Whatsapp</button>
			<?php else: ?>
				<button class="nav-link" id="nav-disabled-tab" data-bs-toggle="tab" data-bs-target="#nav-disabled" type="button" role="tab" aria-controls="nav-disabled" aria-selected="false" disabled>Email</button>
				<button class="nav-link" id="nav-disabled-tab" data-bs-toggle="tab" data-bs-target="#nav-disabled" type="button" role="tab" aria-controls="nav-disabled" aria-selected="false" disabled>Whatsapp</button>
			<?php endif; ?>

		</div>
		</nav>
	
		<div class="tab-content shadow border rounded border-top-0 p-5" id="nav-tabContent">

			<div class="tab-pane fade show active mt-4" id="nav-perfil" role="tabpanel" aria-labelledby="nav-perfil-tab" tabindex="0">
				<div class="row">
					<?php
					echo '<h4 class="col-md-12">Responsável</h4>';
					echo '<div class="col-md-6">';
					echo form_label('Responsável: ','input_responsavel',['class'=>'mt-3']);
					echo form_input('input_responsavel', ($organizacao['org_responsavel'])? $organizacao['org_responsavel'] : '','class="form-control" placeholder="Responsável"');
					// <!-- input_responsavel Error -->
					if($validation->getError('input_responsavel')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_responsavel'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-6">';
					echo form_label('CPF: ','input_responsavel_cpf',['class'=>'mt-3']);
					echo form_input('input_responsavel_cpf', ($organizacao['org_responsavel_cpf'])? $organizacao['org_responsavel_cpf'] : '','class="form-control" placeholder="CPF do responsável"');
					// <!-- input_responsavel_cpf Error -->
					if($validation->getError('input_responsavel_cpf')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_responsavel_cpf'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<h3 class="col-md-12 mt-5">Empresa</h3>';
					echo '<div class="col-md-6">';
					echo form_label('Nome: ','input_nome',['class'=>'mt-3']);
					echo form_input('input_nome', ($organizacao['org_nome'])? $organizacao['org_nome'] : '','class="form-control" placeholder="Nome da organizacao"');
					// <!-- input_nome Error -->
					if($validation->getError('input_nome')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_nome'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-6">';
					echo form_label('Fantasia: ','input_nome_fantasia',['class'=>'mt-3']);
					echo form_input('input_nome_fantasia', ($organizacao['org_nome_fantasia'])? $organizacao['org_nome_fantasia'] : '','class="form-control" placeholder="Nome fantasia da organizacao"');
					// <!-- input_nome_fantasia Error -->
					if($validation->getError('input_nome_fantasia')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_nome_fantasia'); ?>
						</div><?php 
					}
					echo '</div>';
					
					echo '<div class="col-md-6">';
					echo form_label('E-mail: ','input_email',['class'=>'mt-3']);
					echo form_input('input_email', ($organizacao['org_email'])? $organizacao['org_email'] : '','class="form-control" placeholder="E-mail de contato"');
					// <!-- input_email Error -->
					if($validation->getError('input_email')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_email'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-6">';
					echo form_label('CNPJ','input_cnpj',['class'=>'mt-3']);
					echo form_input('input_cnpj', ($organizacao['org_cnpj'])? $organizacao['org_cnpj'] : '','class="form-control" placeholder="CNPJ"');
					// <!-- input_cnpj Error -->
					if($validation->getError('input_cnpj')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_cnpj'); ?>
						</div><?php 
					}
					echo '</div>';
					echo '<div class="col-md-6">';
					echo form_label('Inscrição Municipal: ','input_insc_municipal',['class'=>'mt-3']);
					echo form_input('input_insc_municipal', ($organizacao['org_insc_municipal'])? $organizacao['org_insc_municipal'] : '','class="form-control" placeholder="Inscrição Municipal"');
					// <!-- input_insc_municipal Error -->
					if($validation->getError('input_insc_municipal')) { ?>
						<div class='alert alert-danger mt-2'>
						<?= $validation->getError('input_insc_municipal'); ?>
						</div><?php 
					}
					echo '</div>';
					?>
				</div>
			</div>

			<div class="tab-pane fade show mt-4" id="nav-endereco" role="tabpanel" aria-labelledby="nav-endereco-tab" tabindex="0">
				<?php
				echo '<h3>Endereço</h3>';
				echo '<div class="row">';
				echo '<div class="col-md-6">';
				echo form_label('Endereço: ','input_endereco',['class'=>'mt-3']);
				echo form_input('input_endereco', ($organizacao['org_endereco'])? $organizacao['org_endereco'] : '','class="form-control" placeholder="Endereço"');
				// <!-- input_endereco Error -->
				if($validation->getError('input_endereco')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_endereco'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '<div class="col-md-3">';
				echo form_label('Nº: ','input_endereco_numero',['class'=>'mt-3']);
				echo form_input('input_endereco_numero', ($organizacao['org_endereco_numero'])? $organizacao['org_endereco_numero'] : '','class="form-control" placeholder="Número"');
				// <!-- input_endereco_numero Error -->
				if($validation->getError('input_endereco_numero')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_endereco_numero'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '<div class="col-md-3">';
				echo form_label('Complemento: ','input_endereco_compl',['class'=>'mt-3']);
				echo form_input('input_endereco_compl', ($organizacao['org_endereco_compl'])? $organizacao['org_endereco_compl'] : '','class="form-control" placeholder="Complemento"');
				// <!-- input_endereco_compl Error -->
				if($validation->getError('input_endereco_compl')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_endereco_compl'); ?>
					</div><?php 
				}echo '</div>';
				echo '<div class="col-md-6">';
				echo form_label('Bairro: ','input_bairro',['class'=>'mt-3']);
				echo form_input('input_bairro', ($organizacao['org_bairro'])? $organizacao['org_bairro'] : '','class="form-control" placeholder="Bairro"');
				// <!-- input_bairro Error -->
				if($validation->getError('input_bairro')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_bairro'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '<div class="col-md-6">';
				echo form_label('Município: ','input_municipio',['class'=>'mt-3']);
				echo form_input('input_municipio', ($organizacao['org_municipio'])? $organizacao['org_municipio'] : '','class="form-control" placeholder="Município"');
				// <!-- input_municipio Error -->
				if($validation->getError('input_municipio')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_municipio'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '<div class="col-md-4">';
				echo form_label('Estado (UF)','input_estado_uf',['class'=>'mt-3']);
				echo form_input('input_estado_uf', ($organizacao['org_estado_uf'])? $organizacao['org_estado_uf'] : '','class="form-control" placeholder="Estado (UF)"');
				// <!-- input_estado_uf Error -->
				if($validation->getError('input_estado_uf')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_estado_uf'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '<div class="col-md-4">';
				echo form_label('País: ','input_pais',['class'=>'mt-3']);
				echo form_input('input_pais', ($organizacao['org_pais'])? $organizacao['org_pais'] : '','class="form-control" placeholder="País"');
				// <!-- input_pais Error -->
				if($validation->getError('input_pais')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_pais'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '<div class="col-md-4">';
				echo form_label('CEP: ','input_cep',['class'=>'mt-3']);
				echo form_input('input_cep', ($organizacao['org_cep'])? $organizacao['org_cep'] : '','class="form-control" placeholder="CEP"');
				// <!-- input_cep Error -->
				if($validation->getError('input_cep')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_cep'); ?>
					</div><?php 
				}
				echo '</div>';
				echo '</div>';
				?>
			</div>

			<div class="tab-pane fade mt-4" id="nav-email" role="tabpanel" aria-labelledby="nav-email-tab" tabindex="0">
				<?php
				echo '<h4>Disparo de Emails</h4>';
				echo form_label('Email para disparo: ','input_email_disparo',['class'=>'mt-3']);
				echo form_input('input_email_disparo', ($organizacao['org_email_disparo'])? $organizacao['org_email_disparo'] : '','class="form-control" placeholder="naoresponda@ndnw.com.br"');
				// <!-- input_email_disparo Error -->
				if($validation->getError('input_email_disparo')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_email_disparo'); ?>
					</div><?php 
				}
				echo form_label('Senha do email: ','input_email_senha',['class'=>'mt-3']);
				echo form_input('input_email_senha', ($organizacao['org_email_senha'])? $organizacao['org_email_senha'] : '','class="form-control" placeholder="senha"');
				// <!-- input_email_senha Error -->
				if($validation->getError('input_email_senha')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_email_senha'); ?>
					</div><?php 
				}
				echo form_label('Protocolo: ','input_email_protocol',['class'=>'mt-3']);
				echo form_input('input_email_protocol', ($organizacao['org_email_protocol'])? $organizacao['org_email_protocol'] : '','class="form-control" placeholder="smtp ou mail"');
				// <!-- input_email_protocol rror -->
				if($validation->getError('input_email_protocol')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_email_protocol'); ?>
					</div><?php 
				}
				echo form_label('Smtp: ','input_email_smtp',['class'=>'mt-3']);
				echo form_input('input_email_smtp', ($organizacao['org_email_smtp'])? $organizacao['org_email_smtp'] : '','class="form-control" placeholder="mail.ndnw.com.br"');
				// <!-- input_email_smtp rror -->
				if($validation->getError('input_email_smtp')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_email_smtp'); ?>
					</div><?php 
				}
				echo form_label('Porta: ','input_email_port',['class'=>'mt-3']);
				echo form_input('input_email_port', ($organizacao['org_email_port'])? $organizacao['org_email_port'] : '','class="form-control" placeholder="Porta"');
				// <!-- input_email_port rror -->
				if($validation->getError('input_email_port')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_email_port'); ?>
					</div><?php 
				}
				?>
			</div>

			<div class="tab-pane fade mt-4" id="nav-whatsapp" role="tabpanel" aria-labelledby="nav-whatsapp-tab" tabindex="0">
				<?php
				echo '<h4 class="">BOT WHATSAPP</h4>';
				echo form_label('Url: ','input_botUrl',['class'=>'mt-3']);
				echo form_input('input_botUrl', ($organizacao['org_botUrl'])? $organizacao['org_botUrl'] : '','class="form-control" placeholder="BOT URL"');
				// <!-- input_botUrl Error -->
				if($validation->getError('input_botUrl')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_botUrl'); ?>
					</div><?php 
				}
				echo form_label('Auth: ','input_botAuth',['class'=>'mt-3']);
				echo form_input('input_botAuth', ($organizacao['org_botAuth'])? $organizacao['org_botAuth'] : '','class="form-control" placeholder="Auth"');
				// <!-- input_botAuth Error -->
				if($validation->getError('input_botAuth')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_botAuth'); ?>
					</div><?php 
				}
				echo form_label('Hash: ','input_botHash',['class'=>'mt-3']);
				echo form_input('input_botHash', ($organizacao['org_botHash'])? $organizacao['org_botHash'] : '','class="form-control" placeholder="Hash"');
				// <!-- input_botHash rror -->
				if($validation->getError('input_botHash')) { ?>
					<div class='alert alert-danger mt-2'>
					<?= $validation->getError('input_botHash'); ?>
					</div><?php 
				}
				?>
			</div>

		</div>
		<?php
		echo '<div class="col-md-12">';
			// confirmar envio
			echo '<div class="d-grid mt-5">';
			echo form_hidden('id_organizacao',$organizacao['id_organizacao']);
			echo csrf_field();
			echo form_submit('enviar','Atualizar Cadastro','class="btn btn-primary"');
			echo '</div>';
		echo '</div>';
		echo form_close();

		echo '<br>Criado: ' . $organizacao['created_at'];
		echo '<br>Editado: ' . $organizacao['updated_at'];
		echo '<br>Excluido: '. $organizacao['deleted_at'];
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>




<?= $this->section('js') ?>
<script>
	

// habilita tooltip
$(document).ready(function() {
    $("body").tooltip({ selector: '[data-bs-toggle=tooltip]' });
});
</script>
<?= $this->endSection() ?>