<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h3 class="mt-5">Organizações</h3>
		<hr>
		<p>Disparador Whatsapp Padrão:</p>
		<?php
		echo '<p class="small text-break">';
		echo 'Bot Url: ' . $organizacao['org_botUrl'] . '<br>';
		echo 'Auth: ' . $organizacao['org_botAuth'] . '<br>';
		echo 'Hash: ' . $organizacao['org_botHash'] . '<br>';
		echo '</p>';
		echo anchor('organizacao?bot=status', '<span class="glyphicon glyphicon-list-alt"></span> Ver Status do Bot', 'rel="nofollow" class="btn btn-outline-warning w-100 mb-2"');
		echo anchor('organizacao?bot=cria', '<span class="glyphicon glyphicon-list-alt"></span> Cria Bot', 'rel="nofollow" class="btn btn-outline-warning w-100 mb-2"');
		echo anchor('organizacao?bot=remove', '<span class="glyphicon glyphicon-list-alt"></span> Remove Bot', 'rel="nofollow" class="btn btn-outline-warning w-100 mb-2"');
		echo anchor('organizacao?bot=qrCode', '<span class="glyphicon glyphicon-list-alt"></span> qrCode', 'rel="nofollow" class="btn btn-outline-warning w-100 mb-2"');
		?>
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Organizacoes</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h3>Listagem Ativas</h3>
		<hr>

		<?=anchor('/organizacao/cadastra','Cadastrar Organizacao', 'rel="nofollow" class="btn btn-outline-success mt-3 mb-3"'); ?>

		<div class="table-responsive">
			<table class="table">
				<thead class="table-light">
					<tr>
						<th>ID</th>
						<th>Nome</th>
						<th>E-Mail</th>
						<th>Ação</th>
					</tr>
				</thead>
				<tbody>
				<?php
				foreach($listagemOrganizacoes as $lo):
					echo '<tr>';
					echo '<td>';
					echo $lo['id_organizacao'];
					echo '</td>';
					echo '<td>';
					echo anchor('organizacao/edita/'.$lo['id_organizacao'],$lo['org_nome']);
					echo '</td>';
					echo '<td>';
					echo $lo['org_email'];
					echo '</td>';
					echo '<td>';
					echo anchor('organizacao/edita/'.$lo['id_organizacao'], '<span class="material-symbols-outlined">edit_note</span>');
					echo ' | ';
					echo anchor('organizacao/exclui/'.$lo['id_organizacao'], '<span class="material-symbols-outlined">delete</span>', 'class="btn-confirma-excluir"');
					echo '</td>';
					echo '</tr>';
				endforeach;
				?>
				</tbody>
			</table>
		</div>
		<?php
		// paginação
		// echo $pager->links('default','default_full');
		?>

	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>


<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>