<?= $this->extend('admin/template/template') ?>


<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h3 class="mt-5">Menu Rápido</h3>
        <a href="<?php echo base_url('cliente/cadastra'); ?>" rel="nofollow" class="btn btn-light w-100 mb-2"><span class="glyphicon glyphicon-user"></span> Novo Cliente</a>
        <a href="<?php echo base_url('fatura/cadastra/new'); ?>" rel="nofollow" class="btn btn-light w-100 mb-2"><span class="glyphicon glyphicon-usd"></span> Nova Fatura</a>
        <a href="<?php echo base_url('clientePedido/cadastra/new'); ?>" rel="nofollow" class="btn btn-light w-100 mb-2"><span class="glyphicon glyphicon-list-alt"></span> Novo Pedido</a>
        <div class="text-bg-light mb-3 p-2">
            <h5 class="mt-3">Busque fácil</h5>
            <input type="text" name="search_text" id="search_text" placeholder="Cliente ou email" class="form-control" />
            <br />
            <div id="result"></div>
        </div>
        <b class="mt-3">Relatorio de acessos</b><br>
        <ol>
        <?php
        foreach($retorno as $r):
            echo '<li class="mb-1">' . $r['conteudo'] . '</li>';
        endforeach;
        ?>
        </ol>
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <h3>DashBoard</h3>
        <div class="row">
            <div class="col-6 col-md-2">
            <div class="card border-light mb-3" style="max-width: 18rem;">
                <div class="card-header">Faturas Abertas</div>
                <div class="card-body">
                    <h5 class="card-title"><?= $totalFatura?></h5>
                </div>
            </div>
            </div>
            <div class="col-6 col-md-2">
            <div class="card border-light mb-3" style="max-width: 18rem;">
                <div class="card-header">Faturas de Hoje</div>
                <div class="card-body">
                    <h5 class="card-title"><?= $totalFaturaVencendo?></h5>
                </div>
            </div>
            </div>
            <div class="col-6 col-md-2">
            <div class="card border-light mb-3" style="max-width: 18rem;">
                <div class="card-header">Faturas Vencidas</div>
                <div class="card-body">
                    <h5 class="card-title"><?= $totalFaturaVencida?></h5>
                </div>
            </div>
            </div>
            <div class="col-6 col-md-2">
            <div class="card col-card border-light mb-3" style="max-width: 18rem;">
                <div class="card-header">Orçamentos</div>
                <div class="card-body">
                    <h5 class="card-title"><?=count($listagemOrcamento)?></h5>
                </div>
            </div>
            </div>
            <div class="col-6 col-md-2">
            <div class="card col-card border-light mb-3" style="max-width: 18rem;">
                <div class="card-header">Clientes</div>
                <div class="card-body">
                    <h5 class="card-title"><?= $totalCliente?></h5>
                </div>
            </div>
            </div>
            <div class="col-6 col-md-2">
            <div class="card border-light mb-3" style="max-width: 18rem;">
                <div class="card-header">Contratos</div>
                <div class="card-body">
                    <h5 class="card-title"><?= $totalContratos?></h5>
                </div>
            </div>
            </div>
        </div>
        
		<h3 class="mt-5 pt-5">Orçamentos</h3>
        <?php
        // listage orcamentos em aberto
        if($listagemOrcamento):
            foreach($listagemOrcamento as $o):
                echo '<div class="d-flex justify-content-between border-bottom pt-3 pb-2">';
                if($o['orc_nome']!=''):
                    echo '<div class="pb-2">';
                    echo '<small>';
                    echo $o['orc_nome'] . ' ';
                    echo $o['orc_email'] . ' ';
                    echo $o['orc_whats'];
                    echo '<br>';
                    echo $o['id_orcamento'] . ' | ';
                    echo '</small>';
                    echo anchor('orcamento/edita/' . $o['id_orcamento'], $o['orc_titulo']);
                    echo '</div>';
                    echo '<div class="pb-2"><span class="badge text-bg-primary">';
                    echo ucfirst($o['orc_status']);
                    echo '</span></div>';
                    echo '<div class="pb-2 small">';
                    echo anchor('orcamento/lembretewhats/'.$o['id_orcamento'], 'Enviar no whats', 'class="btn-confirma-excluir"');
                    echo '</div>';
                else:
                    $clientes = array_column($listagemCliente, 'id_cliente');
                    $found_key = array_search($o['id_cliente'], $clientes);
                    echo '<div class="pb-2">';
                    echo '<small>';
                    echo anchor('cliente/painel/'.$listagemCliente[$found_key]['id_cliente'],$listagemCliente[$found_key]['cli_nome']);
                    echo '<br>';
                    echo $o['id_orcamento'] . ' | ';
                    echo '</small>';
                    echo anchor('orcamento/edita/' . $o['id_orcamento'], $o['orc_titulo']);
                    echo '</div>';
                    echo '<div class="pb-2"><span class="badge text-bg-primary">';
                    echo ucfirst($o['orc_status']);
                    echo '</span></div>';
                    echo '<div class="pb-2 small">';
                    echo anchor('orcamento/lembretewhats/'.$o['id_orcamento'], 'Enviar no whats', 'class="btn-confirma-excluir"');
                    echo '</div>';
                endif;
                echo '</div>';
            endforeach;
        else:
            echo '<p class="mb-3 small">Nenhum orçamento em aberto. ' . anchor('orcamento','ver todos') . '</p>';
        endif;

        // formulario orçamento
        $validation = \Config\Services::validation();
        echo form_open('orcamento/cadastra',['class'=>'row text-bg-light mb-3 pt-2 pb-2',]);
        echo '<div class="col-md-2">';
        $opts = [
            'NULL'  => 'Cliente'
        ];
        foreach($listagemCliente as $l):
            $opts[$l['id_cliente']] = $l['cli_nome'];
        endforeach;
        echo form_dropdown('input_id_cliente', $opts, set_value('input_id_cliente'),'class="form-select"');
        // <!-- Error -->
        if($validation->getError('input_id_cliente')) { ?>
            <div class='alert alert-danger mt-2'>
                <?= $validation->getError('input_id_cliente'); ?>
            </div><?php 
        }
        echo '</div>';
        echo '<div class="col-md-1">';
        echo 'OU';
        echo '</div>';
        echo '<div class="col-md-3">';
        echo form_input('input_nome', set_value('input_nome'),'class="form-control" placeholder="Nome"');
        // <!-- Error -->
        if($validation->getError('input_nome')) { ?>
            <div class='alert alert-danger mt-2'>
                <?= $validation->getError('input_nome'); ?>
            </div><?php 
        }
        echo '</div>';
        echo '<div class="col-md-3">';
        echo form_input('input_email', set_value('input_email'),'class="form-control" placeholder="E-Mail"');
        // <!-- Error -->
        if($validation->getError('input_email')) { ?>
            <div class='alert alert-danger mt-2'>
                <?= $validation->getError('input_email'); ?>
            </div><?php 
        }
        echo '</div>';
        echo '<div class="col-md-3">';
        echo form_input('input_whats', set_value('input_whats'),'class="form-control" placeholder="Telefone|Whatsapp"');
        // <!-- Error -->
        if($validation->getError('input_whats')) { ?>
            <div class='alert alert-danger mt-2'>
                <?= $validation->getError('input_whats'); ?>
            </div><?php 
        }
        echo '</div>';
        echo '<div class="col-md-12">';
        echo form_input('input_titulo', set_value('input_titulo'),'class="form-control mt-1" placeholder="Título do Projeto"');
        // <!-- Error -->
        if($validation->getError('input_titulo')) { ?>
            <div class='alert alert-danger mt-2'>
                <?= $validation->getError('input_titulo'); ?>
            </div><?php 
        }
        echo form_textarea('input_descricao', set_value('input_descricao'), array('rows' => '3', 'class' => 'mt-1 form-control', 'placeholder'=>'CNPJ, Descrição do orçamento e link da apresentação.'));
        // <!-- Error -->
        if($validation->getError('input_descricao')) { ?>
            <div class='alert alert-danger mt-2'>
                <?= $validation->getError('input_descricao'); ?>
            </div><?php 
        }
        echo form_submit('Enviar', 'Gerar Orçamento', 'class="mt-1 btn btn-success w-100"');
        echo '</div>';
        echo form_close();
        
        date_default_timezone_set('America/Sao_Paulo');
        
        $mesAtual = date_format(date_create('NOW', new DateTimeZone('America/Sao_Paulo')), 'M');
        $mes_extenso = array(
            'Jan' => 'Janeiro',
            'Feb' => 'Fevereiro',
            'Mar' => 'Março',
            'Apr' => 'Abril',
            'May' => 'Maio',
            'Jun' => 'Junho',
            'Jul' => 'Julho',
            'Aug' => 'Agosto',
            'Sep' => 'Setembro',
            'Oct' => 'Outubro',
            'Nov' => 'Novembro',
            'Dec' => 'Dezembro'
        );
        ?>
        <h3 class="mt-5 pt-5">Contratos de <?=$mes_extenso[$mesAtual]?></h3>
        <div class="table-responsive">
            <table class="table">
                <thead class="table-light">
                    <tr>
                        <th width="50">ID</th>
                        <th width="135">Cliente</th>
                        <th>Descrição</th>
                        <th width="135">Valor</th>
                        <th width="135">Vencimento</th>
                    </tr>
                </thead>
                    <tbody>
                        <?php
                        foreach($listagemCobranca as $f):
                            $clientes = array_column($listagemCliente, 'id_cliente');
                            $found_key = array_search($f['id_cliente'], $clientes);
                            $nomeCliente = explode(' ',$listagemCliente[$found_key]['cli_nome']);
                            ?>
                        <tr>
                            <td><?= $f['id_clientepedido'] ?></td>
                            <td><?=anchor('cliente/painel/'.$listagemCliente[$found_key]['id_cliente'], $nomeCliente[0]); ?></td>
                            <td><small class="badge text-bg-secondary"><?= $f['pro_nome'] . '</small> ' . $f['cliped_dominio'] ?></td>
                            <td nowrap>R$ <?= $f['cliped_valor']; ?></td>
                            <td class="small"><?= $f['cliped_pagamentoproximo']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="4" class="text-end">
                                R$ <?= $totalCobrancas; ?>
                            </td>
                            <td colspan="2" class="text-end">
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</footer>
<?= $this->endSection() ?>




<?= $this->section('js') ?>
<!------------------------------------ -->
<!-- busca rapida -->
<!------------------------------------ -->
<script>
$(document).ready(function(){
    function load_data(query){
        $.ajax({
            url:"<?php echo base_url('painel/fetch'); ?>",
            method:"POST",
            data:{query:query},
            success:function(data){
                $('#result').html(data);
            }
        })
    }

    $('#search_text').keyup(function(){
        var search = $(this).val();
        if(search != ''){
            load_data(search);
        }
    });
});


// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>