<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-10 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/produto','Produtos')?></li>
				<li class="breadcrumb-item active" aria-current="page">Editar</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editar dados de <b><?=$produto['pro_nome']?></b></h2>
		<?php
		
		$validation = \Config\Services::validation();

		echo form_open('produto/edita/'.$produto['id_produto'],'class="row"');
			echo '<div class="col-md-6">';
			// input name
			echo form_label(' ','input_name');
			echo form_input('input_name', ($produto['pro_nome'])? $produto['pro_nome'] : '','class="form-control" placeholder="Seu nome"');
			// <!-- name Error -->
			if($validation->getError('input_name')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_name'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-3">';
			// input valor
			echo form_label(' ','input_valor');
			echo form_input('input_valor', ($produto['pro_valor'])? $produto['pro_valor'] : '','class="form-control" placeholder="Valor Único"');
			// <!-- valor Error -->
			if($validation->getError('input_valor')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_valor'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-3">';
			// input valor mensal
			echo form_label(' ','input_valormensal');
			echo form_input('input_valormensal', ($produto['pro_valormensal'])? $produto['pro_valormensal'] : '','class="form-control" placeholder="Valor Mensal"');
			// <!-- valor mensal Error -->
			if($validation->getError('input_valormensal')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_valormensal'); ?>
				</div><?php 
			}
			echo '</div>';
			// confirmar envio
			echo '<div class="d-grid mt-3">';
			echo form_hidden('id_produto',$produto['id_produto']);
			echo csrf_field();
			echo form_submit('enviar','Atualizar Cadastro','class="btn btn-primary"');
			echo '</div>';
		echo form_close();

		echo '<br>Criado: ' . $produto['created_at'];
		echo '<br>Editado: ' . $produto['updated_at'];
		echo '<br>Excluido: '. $produto['deleted_at'];
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>