<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h2>Acesso rápido</h2>
		<?php
		echo anchor('/produto/cadastra','Cadastrar Produto');
		echo '<br>';
		?>
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Produtos</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Listagem de Produtos</h2>
		<?php
		foreach($listagemProdutos as $produto):
			echo $produto['id_produto'] . ' | ';
			echo $produto['pro_nome'] . ' | ';
			echo $produto['pro_valor'] . ' | ';
			echo $produto['pro_valormensal'] . ' | ';
			echo anchor('produto/edita/'.$produto['id_produto'], 'Editar') . ' | ';
			echo anchor('produto/exclui/'.$produto['id_produto'], 'Excluir', 'class="btn-confirma-excluir"');
			echo '<hr>';
		endforeach;
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>


<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>