<!DOCTYPE html>
<html lang="pt-br">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		
		<!-- SEO -->
		<title><?=$TituloPagina; ?></title>
		<meta name="description" content="The small framework with powerful features">
		<link rel="shortcut icon" type="image/png" href="/favicon.ico" />
		<!-- SEM -->

		<!-- CSS -->
		<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
		<link rel="stylesheet" href="<?=base_url();?>/public/assets/css/style.css">
		<?=$this->renderSection('css'); ?>	
	</head>
	<body>

		<header>
			<nav class="navbar navbar-expand-lg">
				<div class="container-fluid">
					<a class="offset-md-1 navbar-brand pb-3" href="<?=base_url()?>"><img src="<?= base_url('public/assets/img/logo-caixapreta.png') ?>" width="200px"></a>
					<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
					</button>
					<div class="collapse navbar-collapse justify-content-center" id="navbarNavDropdown">
						<ul class="navbar-nav">
							<li class="nav-item pe-3">
							<?= anchor('/', 'Painel','class="nav-link"');?>
							</li>
							<li class="nav-item pe-3">
							<?= anchor('/orcamento','Orçamento','class="nav-link"');?>
							</li>
							<li class="nav-item pe-3">
							<?= anchor('/cliente','Cliente','class="nav-link"');?>
							</li>
							<li class="nav-item pe-3">
							<?= anchor('/clientePedido','Pedidos','class="nav-link"');?>
							</li>
							<li class="nav-item pe-3">
							<?= anchor('/fatura','Fatura','class="nav-link"');?>
							</li>
							<li class="nav-item pe-3">
							<?= anchor('/faturamento','Faturamento','class="nav-link"');?>
							</li>
							<li class="nav-item pe-3 dropdown">
								<a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
								Marketing
								</a>
								<ul class="dropdown-menu">
									<?= anchor('/evupt','Evupt','class="dropdown-item"');?>
									<?= anchor('/midia','Midias','class="dropdown-item"');?>
								</ul>
							</li>
							<li class="nav-item pe-3 dropdown">
								<a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
								Sistema
								</a>
								<ul class="dropdown-menu">
									<li><?= anchor('/organizacao','Organização','class="dropdown-item"');?></li>
									<li><?= anchor('/usuario','Usuarios','class="dropdown-item"');?></li>
									<li><?= anchor('/produto','Produtos','class="dropdown-item"');?></li>
									<li><?= anchor('/faturaFormapgto','Formas de Pagamento','class="dropdown-item"');?></li>
									<li><?= anchor('/faturamentoCategoria','Categorias de Faturamento','class="dropdown-item"');?></li>
								</ul>
							</li>
							<li class="nav-item">
							<?= anchor('login/signout', ' Sair','class="nav-link"');?>
							</li>
						</ul>
					</div>
				</div>
			</nav>
		</header>

		
		<!-- Exibe Mensagens dwe alerta quando houver -->
		<?php
		$msg = session()->getFlashData('msg');
		$msgType = (session()->getFlashData('msgType'))? session()->getFlashData('msgType') : 'info' ;
		if (!empty($msg)) : ?>
		<div class="alert alert-<?=$msgType?> alert-dismissible fade show" role="alert">
			<?=$msg?>;
			<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
		</div>
		<?php endif; ?>


		<!-- Conteudo -->
		<?=$this->renderSection('content'); ?>


		<!-- --- -- -- -- - -- -- - -- [ FOOTER ] -->
		<footer class="bg-light mt-5">
		<div class="container-fluid mt-5">
			<div class="row justify-content-center mt-5">
				<div class="col-md-5 p-5 mt-5 small text-center text-secondary">
					<p>
						[ Caixa Preta ]<br>
						CRM . Núcleo de Negócios WEB
					</p>
				</div>
			</div>
		</div>
		</footer>


		<!-- JS -->
		<script src="https://code.jquery.com/jquery-3.6.3.min.js" integrity="sha256-pvPw+upLPUjgMXY0G+8O0xUf+/Im1MZjXxxgOcBQBXU=" crossorigin="anonymous"></script>
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2XofN4zfuZxLkoj1gXtW8ANNCe9d5Y3eG5eD" crossorigin="anonymous"></script>
		<?=$this->renderSection('js'); ?>

	</body>
</html>