<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-10 shadow rounded-bottom p-5">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item"><?=anchor('/usuario','Usuarios')?></li>
				<li class="breadcrumb-item active" aria-current="page">Editar</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Editar dados de <b><?=$usuario['usu_nome']?></b></h2>
		<?php
		$validation = \Config\Services::validation();

		echo form_open('usuario/edita/'.$usuario['id_usuario']);
			// input name
			echo form_label(' ','input_name');
			echo form_input('input_name', ($usuario['usu_nome'])? $usuario['usu_nome'] : '','class="form-control" placeholder="Seu nome"');
			// <!-- name Error -->
			if($validation->getError('input_name')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_name'); ?>
				</div><?php 
			}
			// input email
			echo form_label(' ','input_email');
			echo form_input('input_email', ($usuario['usu_email'])? $usuario['usu_email'] : '','class="form-control" placeholder="Seu email"');
			// <!-- email Error -->
			if($validation->getError('input_email')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_email'); ?>
				</div><?php 
			}
			// input phone
			echo form_label(' ','input_phone');
			echo form_input('input_phone', ($usuario['usu_telefone'])? $usuario['usu_telefone'] : '','class="form-control" placeholder="Seu telefone"');
			// <!-- email Error -->
			if($validation->getError('input_phone')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_phone'); ?>
				</div><?php 
			}
			echo '<div class="row mt-3">';
			echo '<div class="col-md-6">';
			// input senha
			echo form_label('<small>Apenas informe a senha para altera-la</small>','input_pass');
			echo form_input('input_pass', '','class="form-control" placeholder="Informe a senha"');
			// <!-- erro Error -->
			if($validation->getError('input_pass')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pass'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '<div class="col-md-6">';			
			// input confirmar senha
			echo form_label(' ','input_pass_confirm');
			echo form_input('input_pass_confirm', '','class="form-control" placeholder="Repita a mesma senha acima, para Confirmar"');
			// <!-- erro Error -->
			if($validation->getError('input_pass_confirm')) { ?>
				<div class='alert alert-danger mt-2'>
				  <?= $validation->getError('input_pass_confirm'); ?>
				</div><?php 
			}
			echo '</div>';
			echo '</div>';
			
			// confirmar envio
			echo '<div class="d-grid mt-3">';
			echo form_hidden('id_usuario',$usuario['id_usuario']);
			echo csrf_field();
			echo form_submit('enviar','Atualizar Cadastro','class="btn btn-primary');
			echo '</div>';
		echo form_close();

		echo '<br>Criado: ' . $usuario['created_at'];
		echo '<br>Editado: ' . $usuario['updated_at'];
		echo '<br>Excluido: '. $usuario['deleted_at'];
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>