<?= $this->extend('admin/template/template') ?>

<?= $this->section('content') ?>
<section>
<div class="container-fluid">
<div class="row justify-content-center">
	<div class="col-md-2">
		<h2>Acesso rápido</h2>
		<?php
		echo anchor('/usuario/cadastra','Cadastrar Usuario');
		echo '<br>';
		?>
	</div>
	<div class="col-md-8 shadow p-5 rounded">
        <!-- > Breadcrumb -->
		<nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><?=anchor('/','Painel')?></li>
				<li class="breadcrumb-item active" aria-current="page">Usuários</li>
			</ol>
		</nav>
		<!-- # end breadcrumb -->
		<!-- > Conteudo -->
		<h2>Listagem de Usuários</h2>
		<?php
		foreach($listagemUsuarios as $usuario):
			echo $usuario['id_usuario'] . ' | ';
			echo anchor('usuario/edita/'.$usuario['id_usuario'],$usuario['usu_nome']) . ' | ';
			echo $usuario['usu_email'];
			echo ' | ';
			echo anchor('usuario/edita/'.$usuario['id_usuario'], 'Editar') . ' | ';
			echo anchor('usuario/exclui/'.$usuario['id_usuario'], 'Excluir', 'class="btn-confirma-excluir"');
			echo '<hr>';
		endforeach;
		?>
	</div>
</div>
</div>
</section>
<?= $this->endSection() ?>


<?= $this->section('js') ?>
<script>
// confirma excluir item clicado
$('.btn-confirma-excluir').on('click',function(e){
	let text = "Confirme para continuar\nou cancele.";
	if (confirm(text) == true) {
		text = "You pressed OK!";
	} else {
        e.stopImmediatePropagation();
        e.preventDefault();
	}
});
</script>
<?= $this->endSection() ?>