<?= $this->extend('cliente/template/template') ?>

<?= $this->section('css') ?>
<style type="text/css">
	h1{font-weight: 900;}
	.top{
		background:#000; color:#fff; padding:60px;
	}
	.titulo,
    #ticket_medio{
		padding:30px;
		margin-top:30px;
		background: #eee;
	}
	.card-header{
		font-weight: 800;
	}
	a{color: var(--preto);}
	.form-switch{
		padding-top: 10px;
		padding-bottom: 10px;
		border-bottom: 1px dashed #ccc;
		cursor: pointer;
	}
</style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!-- TOPO -->
<div class="container-fluid">
<div class="row top">
    <div class="col-md-10">
        <?php
        if($cliente['cli_avatar']!=""):
            $img=base_url('public/'.$cliente['cli_avatar']);
            echo '<img src="'.$img.'" width="200" style="border-radius:50%; margin:0 5%; float:left;" />';
        endif;
        echo '<h1>Olá '.$cliente['cli_nome'].'</h1>';
        echo '<h6>Bem vindo ao Núcleo de Negócios WEB</h6>';
        ?>
    </div>
    <div class="col-md-2">
        <p class="small">
            <a href="loginCliente/signout" style="color:#999;">Encerrar seção com segurança.<br>
            <span class="material-symbols-outlined mt-3">fingerprint</span>
        </a>
        </p>
    </div>
</div>
</div>
<!-- FIM TOPO -->

<!-- CONTEUDO -->
<div class="container-fluid">
<div class="row justify-content-center mt-5">
	<div class="col-md-3 d-grid">
        <a href="https://www.ndnw.com.br/consultoria" target="_blank" class="btn btn-primary btn-block"><span class="material-symbols-outlined" style="font-size:55px;">support</span> <br>Solicitar Suporte</a>
    </div>
	<div class="col-md-3 d-grid">
        <a href="https://www.ndnw.com.br/consultoria" target="_blank" class="btn btn-warning"><span class="material-symbols-outlined" style="font-size:55px;">dashboard_customize</span><br>Novo Produto</a>
    </div>
	<div class="col-md-3 d-grid">
        <a href="https://www.ndnw.com.br/consultoria" target="_blank" class="btn btn-success"><span class="material-symbols-outlined" style="font-size:55px;">tips_and_updates</span><br>Consultoria Web</a>
    </div>
	<div class="col-md-10">
        <?php
        
        //ATRIBUTOS
        if((isset($detalhe))&&($detalhe != '')):
            echo '<h3 class="titulo"><span class="material-symbols-outlined">info</span> Detalhes da conta</h3>';
            echo '<div class="table-responsive">';
            echo '<table class="table table-bordered table-striped table-hover">';
            echo '<tr>';
            echo '<th>Atributo</th>';
            echo '<th>Descrição</th>';
            echo '</tr>';
            foreach($detalhe as $d):
                echo '<tr>';
                echo '<td>'.$d['clidet_atributo'].'</td>';
                echo '<td>'.$d['clidet_descricao'].'</td>';
                echo '</tr>';
            endforeach;
            echo '</table>';
            echo '</div>';
        endif;

        // PRODUTOS
        echo '<h3 class="titulo"><span class="material-symbols-outlined">dashboard_customize</span> Produtos contratados</h3>';
        echo '<div class="table-responsive">';
        echo '<table class="table table-bordered table-striped table-hover">';
        echo '<tr>';
        echo '<th>Produto</th>';
        echo '<th>Períodicidade</th>';
        echo '<th>Vencimento</th>';
        echo '<th>Status</th>';
        echo '</tr>';
        //mostra produtos
        foreach($produtos as $p):
            //define status
            switch($p['cliped_status']):
                case '1':
                $produtoStatus = '<span style="color:green;">ativo</span>';
                $statusCor = 'background-color:;';
                break;
                case '0':
                $produtoStatus =  '<span style="color:#ccc;">inativo</span>';
                $statusCor = 'background-color:#eee; color:#ccc;';
                break;
                default: $produtoStatus = $p['cliped_status'];
            endswitch;
            //constroi tabela
            echo '<tr style="'.$statusCor.'">';
            echo '<td>';
            echo $p['pro_nome'].' <small>'.$p['cliped_dominio'].'</small>';
            echo '</td>';
            echo '<td>';    
            switch($p['cliped_pagamentoperiodo']):
                case '1':
                echo ' Anual';
                break;
                case '2':
                echo ' Semestral';
                break;
                case '3':
                echo ' Trimestral';
                break;
                case '8':
                echo ' Mensal';
                break;

                default: echo $p['cliped_pagamentoperiodo'];
            endswitch;
            echo '</td>';    
            echo '<td>';
            echo dataBrasil($p['cliped_pagamentoproximo'],'data');
            echo '</td>';
            echo '<td>'.$produtoStatus.'</td>';
            echo '</tr>';
        endforeach;
        echo '</table>';
        echo '</div>';

        echo '<div class="alert alert-dark mt-5 small alert-dismissible fade show" role="alert">';
        echo '<h6>Pense nisso:</h6> Uma forma de ganhar mais desconto nas faturas é indicando nossos serviços. Outra idéia para conseguir ainda mais ganhos é inscrevendo-se em nosso <a href="https://www.ndnw.com.br/parceiro-comercial" alt="Acessar" target="_blank">Programa Parceiro Comercial</a>.';
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></button></div>';

        // verifica se possui faturas em aberto
        $possui = FALSE;
        foreach($listagem as $r):
            if($r['fat_status'] == 1):
                $possui = TRUE;
            endif;
        endforeach;

        // FATURAS ABERTAS
        if($possui):
        echo '<h3 class="titulo"> <span class="material-symbols-outlined">ads_click</span> Faturas abertas</h3>';
        echo '<div class="table-responsive">';
        echo '<table class="table table-bordered table-striped table-hover">';
        echo '<tr>';
        echo '<th>Nº</th>';
        echo '<th>Descrição</th>';
        echo '<th>Vencimento</th>';
        echo '<th>Status</th>';
        echo '<th>Boleto</th>';
        echo '</tr>';
        echo '<tr>';
        echo '</tr>';

        //mostra faturas abertas
        foreach($listagem as $r):
            if($r['fat_status'] == 1):
            echo '<tr>';
            echo '<td>';
            echo $r['id_fatura'];
            echo '</td>';
            echo '<td>';
            echo '<small>'.$r['fat_descricao'].'</small>';
            echo '</td>';
            echo '<td>';
            echo dataBrasil($r['fat_vencimento'],'data');
            echo '</td>';
            echo '<td>';
            //mostra status da fatura
            switch($r['fat_status']):
                case '0':
                echo '<span style="color:green;">pago</span>';
                break;
                case '2':
                echo '<span style="color:lightgray;">cancelado</span>';
                break;
                default :
                echo '<span style="color:blue;">aberto</span><br />';
                break;
            endswitch;
            echo '</td>';
            echo '<td>';
            //mostra o boleto da fatura
            if((empty($r['boleto']))||($r['fat_status']==0)||($r['fat_status']==2)):
                echo '<small style="color:gray;">Boleto não gerado.</small>';
            else:
                foreach($r['boleto'] as $b):
                    echo '<a href="'.$b['forbol_link'].'" target="_blank" class="btn btn-success">Abrir Boleto</a><br>';
                    echo '<div style="font-size:13px; color:gray; border-bottom:1px solid gray; padding:5px;">Código de barras:</div>';
                    echo '<p class="m-0 p-2">'. $b['forbol_paynumber'] .'</p>';
                endforeach;
            endif;
            echo '</td>';
            echo '</tr>';
            endif;
        endforeach;
        echo '</table>';
        echo '</div>';
        endif;

        // FATURAS FECHADAS
        echo '<h3 class="titulo"><a data-bs-toggle="collapse" href="#collapseExample" role="button" aria-expanded="false" aria-controls="collapseExample"><span class="material-symbols-outlined">payments</span> Histórico de faturas <span style="font-size:13px; text-decoration:none;">Clique para abrir</span></a></h3>';
        echo '<div class="collapse" id="collapseExample">';
        echo '<div class="card card-body">';
        //tabela faturas fechadas
        echo '<div class="table-responsive">';
        echo '<table class="table table-bordered table-striped table-hover">';
        echo '<tr>';
        echo '<th>Nº</th>';
        echo '<th>Descrição</th>';
        echo '<th>Vencimento</th>';
        echo '<th>Pago</th>';
        echo '<th>Status</th>';
        echo '<th nowrap>NFs-e</th>';
        echo '</tr>';
        // se nao possui faturas em aberto
        if(!$possui):
        echo '<tr>';
        echo '<td colspan="6" class="table-dark p-3 small text-center">Todas as faturas encontram-se pagas ou fechadas. Para adiantar um pagamento, entre em contato.</td>';
        echo '</tr>';
        endif;
        //listagem
        foreach($listagem as $r):
            if($r['fat_status'] != 1):
            echo '<tr>';
            echo '<td>';
            echo $r['id_fatura'];
            echo '</td>';
            echo '<td>';
            echo '<small>'.$r['fat_descricao'].'</small>';
            echo '</td>';
            echo '<td>';
            echo dataBrasil($r['fat_vencimento'],'data');
            echo '</td>';
            echo '<td>';
            echo (isset($r['fat_pagamento'])) ? dataBrasil($r['fat_pagamento'],'data') : false ;
            echo '</td>';
            echo '<td>';
            switch($r['fat_status']):
                case '0':
                echo '<span style="color:green;">pago</span>';
                break;
                case '2':
                echo '<span style="color:lightgray;">cancelado</span>';
                break;
                default :
                echo '<span style="color:blue;">aberto</span><br />';
                break;
            endswitch;
            echo '</td>';
            echo '<td>';
            foreach($r['nfse'] as $nfse):
                echo '<a href="';
                echo $nfse['con_url'];
                echo '" target="_blank">Abrir</a>';
            endforeach;
            echo '</td>';
            echo '</tr>';
            endif;
        endforeach;
        echo '</table>';
        echo '</div>';
        echo '</div>';
        echo '</div>';


        // HISTÓRICO DE COMISSÕES
        echo '<h3 class="titulo"><a data-bs-toggle="collapse" href="#collapseComissoes" role="button" aria-expanded="false" aria-controls="collapseComissoes"><span class="material-symbols-outlined">currency_exchange</span> Comissões <span style="font-size:13px; text-decoration:none;">Clique para abrir</span></a></h3>';
        echo '<div class="collapse" id="collapseComissoes">';
        echo '<div class="card card-body">';
        //tabela faturas fechadas
        echo '<div class="table-responsive">';
        echo '<table class="table table-bordered table-striped table-hover">';
        echo '<tr>';
        echo '<th>Nº</th>';
        echo '<th>Descrição</th>';
        echo '<th>Pago</th>';
        echo '<th>Status</th>';
        echo '</tr>';
        // se nao possui faturas em aberto
        
        echo '<tr>';
        echo '<td colspan="5" class="table-success">
        Você ainda não possui comissões geradas. <br>
        </td>';
        echo '</tr>';

        echo '</table>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        ?>
        
	</div>
</div>
</div>
<!-- FIM CONTEUDO -->

<!-- PDCA -->
<div class="container-fluid">
<div class="row justify-content-center mt-5 pt-5 text-center">
    <h2 class="col-md-10" style="font-weight: 200;">Quão grande sua empresa está, na web?</h2>
    <p class="col-md-10" style="font-weight: 200;">Posicione-se bem para garantir a vantagem sobre seus concorrentes.</p>
</div>
<form action="" id="ticket_medio" class="row justify-content-center text-center">
    <div class="col-md-3">
        Faturamento do mês:<br>
        <input type="text" class="form-control" name="calc_faturamento" id="calc_faturamento">
    </div>
    <div class="col-md-3">
        Total de clientes atendidos este mês:<br>
        <input type="text" class="form-control" name="calc_leads" id="calc_leads">
    </div>
    <div class="col-md-3">
        Vendas concluídas este mês:<br>
        <input type="text" class="form-control" name="calc_vendas" id="calc_vendas">
    </div>
    <h3 class="col-md-10 mt-5" style="font-weight: 200;">O <a href="#" data-bs-toggle="tooltip" title="É o valor médio gasto nos pedidos; Quanto maior for o valor, mais os clientes estão gastando. Este indicador expõe o comportamento do cliente e pode ser relacionado à satisfação com a empresa.">ticket médio</a> atual está em<br> R$ <span id="calc_result"> 0,00</span></h3>
</form>
<div class="row justify-content-center text-center">
    <h4 class="col-md-10 mt-5" style="font-weight: 200;">Conheça a sua estrutura</h4>
	<div class="col-md-3">
        <div class="text-bg-primary">Consultoria e Implementação</div>
        <p class="text-bg-primary p-2 m-0">
            Inicie sua empresa na web.
        </p>
        <table width="100%" class="text-bg-primary small">
            <tr>
                <td width="50%" class="p-3">ROI: <br> <span class="material-symbols-outlined">savings</span></td>
                <td width="50%" class="p-3">Implantação: <br> <span class="material-symbols-outlined">schedule</span> <span class="material-symbols-outlined">schedule</span></td>
            </tr>
        </table>
        <p class="text-bg-primary p-2 m-0 small">É necessário pouco investimento mas demanda configurações da equipe técnica que podem levar tempo.</p>
        <p class="text-bg-primary p-2 m-0 small">Minha empresa possui os seguintes ativos:</p>
        <!-- CONSULTORIA E IMPLEMENTAÇÃO -->
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_dominio" name="sel_dominio">
            <label class="form-check-label" for="sel_dominio">Domínio .com.br</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_hospedagem" name="sel_hospedagem">
            <label class="form-check-label" for="sel_hospedagem">Hospedagem Segura</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_email" name="sel_email">
            <label class="form-check-label" for="sel_email">Email Profissional</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_whatsapp" name="sel_whatsapp">
            <label class="form-check-label" for="sel_whatsapp">Whatsapp Business</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_places" name="sel_places">
            <label class="form-check-label" for="sel_places">Business Place</label>
        </div>
        <!-- FIM CONSULTORIA E IMPLEMENTAÇÃO -->
    </div>
    <div class="col-md-3">
        <div class="text-bg-warning">Desenvolvimento</div>
        <p class="text-bg-warning p-2 m-0">
            Tenha uma base sólida de negócio.
        </p>
        <table width="100%" class="text-bg-warning small">
            <tr>
                <td width="50%" class="p-3">ROI: <br> <span class="material-symbols-outlined">savings</span> <span class="material-symbols-outlined">savings</span></td>
                <td width="50%" class="p-3">Implantação: <br> <span class="material-symbols-outlined">schedule</span> <span class="material-symbols-outlined">schedule</span> <span class="material-symbols-outlined">schedule</span></td>
            </tr>
        </table>
        <p class="text-bg-warning p-2 m-0 small">
            Possuir uma imagem profissional demanda investimento e tempo, mas o resultado começa a aparecer.</p>
        <p class="text-bg-warning p-2 m-0 small">Minha empresa possui os seguintes ativos:</p>
        <!-- DESENVOLVIMENTO -->
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_loja" name="sel_loja">
            <label class="form-check-label" for="sel_loja">Loja Virtual</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_site" name="sel_site">
            <label class="form-check-label" for="sel_site">Site Personalizado</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_pagina" name="sel_pagina">
            <label class="form-check-label" for="sel_pagina">Página de Vendas</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_midia" name="sel_midia">
            <label class="form-check-label" for="sel_midia">Mídias Sociais</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_criativo" name="sel_criativo">
            <label class="form-check-label" for="sel_criativo">Criativo Personalizadas</label>
        </div>
        <!-- FIM DESENVOLVIMENTO -->
    </div>
    <div class="col-md-3">
        <div class="text-bg-success">Marketing Digital</div>
        <p class="text-bg-success p-2 m-0">
            Seu motor de vendas automático.
        </p>
        <table width="100%" class="text-bg-success small">
            <tr>
                <td width="50%" class="p-3">ROI: <br> <span class="material-symbols-outlined">savings</span> <span class="material-symbols-outlined">savings</span> <span class="material-symbols-outlined">savings</span></td>
                <td width="50%" class="p-3">Implantação: <br> <span class="material-symbols-outlined">schedule</span></td>
            </tr>
        </table>
        <p class="text-bg-success p-2 m-0 small">
            É possível criar automatizações de vendas para fidelizar ou atrair novos clientes, todos os dias 24/7.</p>
        <p class="text-bg-success p-2 m-0 small">Minha empresa possui os seguintes ativos:</p>
        <!-- MARKETING DIGITAL -->
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_faceads" name="sel_faceads">
            <label class="form-check-label" for="sel_faceads">Facebook Ads</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_googleads" name="sel_googleads">
            <label class="form-check-label" for="sel_googleads">Google Ads</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_emkt" name="sel_emkt">
            <label class="form-check-label" for="sel_emkt">Email Marketing</label>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="sel_follow" name="sel_follow">
            <label class="form-check-label" for="sel_follow">Anúncios Seguidores</label>
        </div>
        <!-- FIM MARKETING DIGITAL -->
    </div>
</div>
</div>
<!-- FIM PDCA -->

<!-- RODAPE -->
<div class="container-fluid">
	<div class="row justify-content-center">
		<div class="col-md-10 text-center mt-5">
            <p class="text-bg-light p-5">
                <span class="material-symbols-outlined">insights</span> <br> Resultado<br><br>
                <span id="consultoria_result"></span> 
            </p>
            <p style="font-weight:300; line-height:16px; margin-top:90px;">Gostaria de obter melhores números com a web?<br>
            <p><a href="https://wa.me/5547989188375?text=Oi, Quero melhorar o posicionamento da minha empresa e faturar mais, segue o endereço do site: www." target="_blank">Agendar consultoria gratuita</a> | <a href="https://www.ndnw.com.br/projeto-web/vantagens/" target="_blank" class="small">Mais Info.</a></p>
            <p class="small" style="font-weight: 800; letter-spacing:-1px; line-height:13px; margin-top:90px;">Núcleo de Negócios WEB<br>
            <span style="font-size:10px; font-weight: 300;">Desde 2003</span></p>
		</div>
	</div>
</div>
<!-- FIM RODAPE -->
<?= $this->endSection() ?>



<?= $this->section('js') ?>
<script>
$(document).ready(function(){
	//
    // - - - - - - - - - - - - - - - - - - - - [ Calcula o ticket médio da empresa ]
    //
    $('#ticket_medio').focusout(function() {
        // define variaveis
        var faturamento = $('#calc_faturamento').val().replace(".", "").replace(",", ".");
        var leads       = $('#calc_leads').val();
        var vendas      = $('#calc_vendas').val();
        
        // faturamento dividido pelo total de vendas
        // resultado é a média do custo por cliente
        // adiciona duas casas decimais
        // altera marcador das dezenas de . para ,
        // adiciona . nos milhares
        var value = (faturamento / vendas).toFixed(2).replace(".", ",").replace(/\B(?=(\d{3})+(?!\d))/g, ".");

        // salva informações na base
        var dados = [faturamento, leads, vendas];
        salvabase({dados});

        // imprime na variável
        $('#calc_result').text(value);
    });


    //
    // - - - - - - - - - - - - - - - - - - - - [ Sistema de consultoria ]
    //
    $('.form-check-input').on('click', function(){
        // verifica em todos da mesma classe .form-check.input, quem foi selecionado
        const elements = [];
        $('.form-check-input').each(function(index, element) {
            var status = $(this).prop('checked');
            var seletor = $(this).attr("name");
            // grava no array quem foi marcado
            if(status==true){
                elements[elements.length] = seletor;
            }
        });

        // imprime array de opções ativas
        console.log(elements);

        // salva informações na base
        salvabase( {elements} );

        // Contabiliza a Consultoria
        var count = 0;
        $(elements).each(function(index, element) {
            if(element == "sel_dominio"){ count = count+1; }
            if(element == "sel_hospedagem"){ count = count+1; }
            if(element == "sel_email"){ count = count+1; }
            if(element == "sel_whatsapp"){ count = count+1; }
            if(element == "sel_places"){ count = count+1; }
            if(element == "sel_loja"){ count = count+10; }
            if(element == "sel_site"){ count = count+10; }
            if(element == "sel_pagina"){ count = count+10; }
            if(element == "sel_midia"){ count = count+10; }
            if(element == "sel_criativo"){ count = count+10; }
            if(element == "sel_faceads"){ count = count+50; }
            if(element == "sel_googleads"){ count = count+50; }
            if(element == "sel_emkt"){ count = count+50; }
            if(element == "sel_follow"){ count = count+50; }
        });
        
        // imprimi no console
        //console.log(count);

        // Realiza Consultoria
        if(count <= 10){
            conclusao = "A empresa possui a base necessária para alavancar seus negócios. Foque na estrutura";
        }else if(count <= 50){
            conclusao = "Parabéns, continue a invistir em novidades e personalização das pautas. Foque no motor";
        }else if(count <= 200){
            conclusao = "Sua empresa está em crescimento constante, explore nixos e segmentos para lucrar mais com os lançamentos. Foque na otimizacao";
        }

        // retorna resultado da consultoria
        $('#consultoria_result').text(conclusao);

    });

    function salvabase(e){
        // $.ajax({
        //     url : "<?=base_url('painelcliente/capturar');?>",
        //     type : 'post',
        //     data : e,
        //     beforeSend : function(){
        //         console.log('enviando');
        //     }
        // })
        // .done(function(msg){
        //     console.log(msg);
        // })
        // .fail(function(jqXHR, textStatus, msg){
        //     alert(msg);
        // });
    };

    
    //
    // - - - - - - - - - - - - - - - - - - - - [ habilitar tootips ]
    //
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })

});
</script>
<?= $this->endSection() ?>
