<!DOCTYPE html>
<html lang="pt-br">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		
		<!-- SEO -->
		<title><?=$TituloPagina; ?></title>
		<meta name="description" content="The small framework with powerful features">
		<link rel="shortcut icon" type="image/png" href="/favicon.ico" />
		<!-- SEM -->

		<!-- CSS -->
		<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
		<link rel="stylesheet" href="<?=base_url();?>/public/assets/css/style.css">
		<?=$this->renderSection('css'); ?>	
	</head>
	<body>
		
		<!-- Exibe Mensagens dwe alerta quando houver -->
		<?php
		$msg = session()->getFlashData('msg');
		$msgType = (session()->getFlashData('msgType'))? session()->getFlashData('msgType') : 'info' ;
		if (!empty($msg)) : ?>
		<div class="alert alert-<?=$msgType?> alert-dismissible fade show" role="alert">
			<?=$msg?>;
			<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
		</div>
		<?php endif; ?>


		<!-- Conteudo -->
		<?=$this->renderSection('content'); ?>


		<!-- JS -->
		<script src="https://code.jquery.com/jquery-3.6.3.min.js" integrity="sha256-pvPw+upLPUjgMXY0G+8O0xUf+/Im1MZjXxxgOcBQBXU=" crossorigin="anonymous"></script>
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2XofN4zfuZxLkoj1gXtW8ANNCe9d5Y3eG5eD" crossorigin="anonymous"></script>
		<?=$this->renderSection('js'); ?>

	</body>
</html>